/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedFieldAccessNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedSubstitutionBodyNode;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;
import com.oracle.truffle.espresso.substitutions.Substitutions;

public class InlinedMethodNode
extends InvokeQuickNode
implements InlinedFrameAccess {
    protected final int opcode;
    protected final int statementIndex;
    @Node.Child
    BodyNode body;

    public static InlinedMethodNode createFor(Method resolutionSeed, int top, int opcode, int curBCI, int statementIndex) {
        JavaSubstitution.Factory factory;
        if (!InlinedMethodNode.isInlineCandidate(resolutionSeed, opcode)) {
            return null;
        }
        if (resolutionSeed.isInlinableGetter()) {
            return InlinedFieldAccessNode.createGetter(resolutionSeed, top, opcode, curBCI, statementIndex);
        }
        if (resolutionSeed.isInlinableSetter()) {
            return InlinedFieldAccessNode.createSetter(resolutionSeed, top, opcode, curBCI, statementIndex);
        }
        if (InlinedMethodNode.isUnconditionalInlineCandidate(opcode) && (factory = Substitutions.lookupSubstitution(resolutionSeed)) != null && factory.inlineInBytecode()) {
            return InlinedSubstitutionBodyNode.create(resolutionSeed, top, opcode, curBCI, statementIndex, factory);
        }
        return null;
    }

    public InlinedMethodNode(Method.MethodVersion inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, BodyNode body) {
        super(inlinedMethod, top, callerBCI);
        this.opcode = opcode;
        this.statementIndex = statementIndex;
        this.body = body;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        this.preludeChecks(frame);
        return this.executeBody(frame);
    }

    protected final void preludeChecks(VirtualFrame frame) {
        if (this.method.isStatic()) {
            this.initCheck();
        } else {
            this.nullCheck(this.peekReceiver(frame));
        }
    }

    protected final int executeBody(VirtualFrame frame) {
        this.body.execute(frame, this);
        return this.stackEffect;
    }

    @Override
    public int top() {
        return this.top;
    }

    @Override
    public int resultAt() {
        return this.resultAt;
    }

    @Override
    public int statementIndex() {
        return this.statementIndex;
    }

    @Override
    public Method.MethodVersion inlinedMethod() {
        return this.method;
    }

    private void initCheck() {
        ObjectKlass k = this.method.getDeclaringKlass();
        if (!k.isInitialized()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            k.safeInitialize();
        }
    }

    public final BaseQuickNode revertToGeneric(BytecodeNode parent) {
        return parent.generifyInlinedMethodNode(this.top, this.opcode, this.getCallerBCI(), this.statementIndex, this.method.getMethod());
    }

    public static boolean isInlineCandidate(Method resolutionSeed, int opcode) {
        if (resolutionSeed.isSynchronized()) {
            return false;
        }
        if (opcode == 184 || opcode == 183) {
            return true;
        }
        return opcode == 182 && resolutionSeed.getContext().getClassHierarchyOracle().isLeafMethod(resolutionSeed).isValid();
    }

    public static boolean isUnconditionalInlineCandidate(int opcode) {
        return opcode == 184 || opcode == 183;
    }

    public static abstract class BodyNode
    extends EspressoNode {
        protected final Method.MethodVersion m;
        private volatile SourceSection sourceSection;

        public BodyNode(Method.MethodVersion m) {
            this.m = m;
        }

        public abstract void execute(VirtualFrame var1, InlinedFrameAccess var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceSection getSourceSection() {
            if (this.m.getSource() == null) {
                return null;
            }
            if (this.sourceSection == null) {
                SourceSection localSourceSection = this.m.getWholeMethodSourceSection();
                BodyNode bodyNode = this;
                synchronized (bodyNode) {
                    if (this.sourceSection == null) {
                        this.sourceSection = localSourceSection;
                    }
                }
            }
            return this.sourceSection;
        }
    }
}

