/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.preinit;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.ContextDescription;
import com.oracle.truffle.espresso.impl.LinkedKlass;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.preinit.CachedLinkedKlassProvider;
import com.oracle.truffle.espresso.preinit.CachedParserKlassProvider;
import com.oracle.truffle.espresso.preinit.DefaultLinkedKlassProvider;
import com.oracle.truffle.espresso.preinit.DefaultParserKlassProvider;
import com.oracle.truffle.espresso.preinit.LinkedKlassProvider;
import com.oracle.truffle.espresso.preinit.ParserKlassProvider;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class EspressoLanguageCache {
    private static final byte FROZEN = (byte)(CacheCapability.MASK + 1);
    private final TruffleLogger logger = TruffleLogger.getLogger((String)"java", EspressoLanguageCache.class);
    @CompilerDirectives.CompilationFinal
    private ParserKlassProvider parserKlassProvider = new DefaultParserKlassProvider();
    @CompilerDirectives.CompilationFinal
    private LinkedKlassProvider linkedKlassProvider = new DefaultLinkedKlassProvider();
    @CompilerDirectives.CompilationFinal
    private volatile byte capabilities = 0;

    private static boolean isFrozen(byte kind) {
        return (kind & FROZEN) != 0;
    }

    public void addCapability(CacheCapability capability) {
        this.addCapability(capability.kind);
    }

    public void ensureFrozen() {
        if (!this.isFrozen()) {
            this.addCapability(FROZEN);
        }
    }

    public void importFrom(EspressoLanguageCache other) {
        assert (CacheCapability.areCompatible(this.capabilities, other.capabilities));
        this.parserKlassProvider = other.parserKlassProvider;
        this.linkedKlassProvider = other.linkedKlassProvider;
    }

    private synchronized void addCapability(byte capability) {
        byte currentCapabilities = this.capabilities;
        if ((capability & currentCapabilities) == 0) {
            if (EspressoLanguageCache.isFrozen(currentCapabilities)) {
                throw EspressoError.fatal("Adding new capability to the language cache when a context has been used.");
            }
            if (EspressoLanguageCache.needsAddCache(currentCapabilities, capability)) {
                this.parserKlassProvider = new CachedParserKlassProvider(this.logger, this.parserKlassProvider);
                this.linkedKlassProvider = new CachedLinkedKlassProvider(this.logger, this.linkedKlassProvider);
            }
            this.capabilities = (byte)(currentCapabilities | capability);
        }
    }

    private static boolean needsAddCache(byte old, byte capability) {
        return !CacheCapability.hasCache(old) && CacheCapability.hasCache(capability);
    }

    private boolean isFrozen() {
        return EspressoLanguageCache.isFrozen(this.capabilities);
    }

    public void logCacheStatus() {
        this.logger.fine(() -> {
            int parserKlassCacheSize = this.parserKlassProvider.getCachedParserKlassCount();
            int linkedKlassCacheSize = this.linkedKlassProvider.getCachedLinkedKlassCount();
            return String.format("Cache state: [ParserKlasses: %d] [LinkedKlasses: %d]", parserKlassCacheSize, linkedKlassCacheSize);
        });
    }

    public ParserKlass getOrCreateParserKlass(ClassLoadingEnv env, StaticObject classLoader, Symbol<Symbol.Type> typeOrNull, byte[] bytes, ClassRegistry.ClassDefinitionInfo info) {
        this.ensureFrozen();
        return this.parserKlassProvider.getParserKlass(env, classLoader, typeOrNull, bytes, info);
    }

    public LinkedKlass getOrCreateLinkedKlass(ClassLoadingEnv env, ContextDescription description, StaticObject loader, ParserKlass parserKlass, LinkedKlass linkedSuperKlass, LinkedKlass[] linkedInterfaces, ClassRegistry.ClassDefinitionInfo info) {
        this.ensureFrozen();
        return this.linkedKlassProvider.getLinkedKlass(env, description, loader, parserKlass, linkedSuperKlass, linkedInterfaces, info);
    }

    public static enum CacheCapability {
        DEFAULT(0),
        PRE_INITIALIZED(1),
        SHARED(2);

        private final byte kind;
        private static final byte MASK;

        private CacheCapability(int kind) {
            this.kind = (byte)kind;
        }

        static boolean hasCache(byte kind) {
            return CacheCapability.mask(kind) != 0;
        }

        static boolean areCompatible(byte kind, byte other) {
            return CacheCapability.mask(kind) == CacheCapability.mask(other);
        }

        private static byte mask(byte kind) {
            return (byte)(kind & MASK);
        }

        static {
            MASK = (byte)((1 << CacheCapability.values().length - 1) - 1);
        }
    }
}

