/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition.plugins.jdkcaches;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.redefinition.plugins.api.InternalRedefinitionPlugin;
import com.oracle.truffle.espresso.redefinition.plugins.impl.RedefinitionPluginHandler;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JDKCacheRedefinitionPlugin
extends InternalRedefinitionPlugin {
    private final List<WeakReference<StaticObject>> threadGroupContexts = new ArrayList<WeakReference<StaticObject>>(4);
    private Method flushFromCachesMethod;
    private Method removeBeanInfoMethod;

    @Override
    public void activate(EspressoContext espressoContext, RedefinitionPluginHandler handler) {
        super.activate(espressoContext, handler);
        this.flushFromCachesMethod = espressoContext.getMeta().java_beans_Introspector_flushFromCaches;
        this.removeBeanInfoMethod = espressoContext.getMeta().java_beans_ThreadGroupContext_removeBeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postClassRedefinition(ObjectKlass[] changedKlasses) {
        List<WeakReference<StaticObject>> list = this.threadGroupContexts;
        synchronized (list) {
            for (ObjectKlass changedKlass : changedKlasses) {
                if (this.flushFromCachesMethod != null) {
                    this.flushFromCachesMethod.invokeDirect(null, changedKlass.mirror());
                }
                Iterator<WeakReference<StaticObject>> iterator = this.threadGroupContexts.iterator();
                while (iterator.hasNext()) {
                    WeakReference<StaticObject> ref = iterator.next();
                    StaticObject context = (StaticObject)ref.get();
                    if (context != null) {
                        this.removeBeanInfoMethod.invokeDirect(context, changedKlass.mirror());
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerThreadGroupContext(StaticObject context) {
        List<WeakReference<StaticObject>> list = this.threadGroupContexts;
        synchronized (list) {
            this.threadGroupContexts.add(new WeakReference<StaticObject>(context));
        }
    }
}

