/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.BootClassPathType;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class PlatformBuilder
extends EspressoProperties.Builder {
    private static final Path RT_JAR = Paths.get("lib", "rt.jar");
    private static final Path MODULES_IMAGE = Paths.get("lib", "modules");
    private static final Path MODULES_EXPLODED = Paths.get("modules", "java.base");
    private static final List<Path> BOOT_CLASSPATH = Collections.unmodifiableList(Arrays.asList(RT_JAR, Paths.get("lib", "resources.jar"), Paths.get("lib", "sunrsasign.jar"), Paths.get("lib", "jsse.jar"), Paths.get("lib", "jce.jar"), Paths.get("lib", "charsets.jar"), Paths.get("lib", "jfr.jar"), Paths.get("classes", new String[0])));
    private static final int PATHS_SIZE = BOOT_CLASSPATH.size();
    static final String CPU_ARCH = System.getProperty("os.arch");
    static final Path EXTENSIONS_DIR = Paths.get("lib", "ext");

    PlatformBuilder(Path espressoLibs) {
        super(espressoLibs);
    }

    @Override
    List<Path> defaultClasspath() {
        return Collections.emptyList();
    }

    @Override
    List<Path> defaultBootClasspath() {
        Path path = this.javaHome().resolve(RT_JAR);
        if (Files.isReadable(path)) {
            this.bootClassPathVersion(BootClassPathType.RT_JAR);
            ArrayList<Path> paths = new ArrayList<Path>(PATHS_SIZE);
            for (Path p : BOOT_CLASSPATH) {
                paths.add(this.javaHome().resolve(p));
            }
            return paths;
        }
        path = this.javaHome().resolve(MODULES_IMAGE);
        if (Files.isReadable(path)) {
            this.bootClassPathVersion(BootClassPathType.IMAGE);
            ArrayList<Path> paths = new ArrayList<Path>(1);
            paths.add(path);
            return paths;
        }
        path = this.javaHome().resolve(MODULES_EXPLODED);
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.bootClassPathVersion(BootClassPathType.EXPLODED);
            ArrayList<Path> paths = new ArrayList<Path>(1);
            paths.add(path);
            return paths;
        }
        throw EspressoError.shouldNotReachHere("Cannot find boot class path for java home: " + String.valueOf(this.javaHome()));
    }

    protected static void expandEnvToPath(String envName, List<Path> paths) {
        String envPath = System.getenv(envName);
        if (envPath != null) {
            for (String e : envPath.split(File.pathSeparator)) {
                paths.add(Paths.get(e, new String[0]));
            }
        }
    }

    @Override
    Path defaultJavaHome() {
        throw EspressoError.shouldNotReachHere("Java home not defined, use --java.JavaHome=/path/to/java/home");
    }
}

