/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
public class IteratorInterop
extends EspressoInterop {
    @ExportMessage
    @Shareable
    public static boolean isIterator(StaticObject receiver) {
        return true;
    }

    @ExportMessage
    public static boolean hasIteratorNextElement(StaticObject receiver, @Bind(value="getMeta().java_util_Iterator_hasNext") Method hasNext, @Cached LookupAndInvokeKnownMethodNode lookupAndInvoke) {
        return (Boolean)lookupAndInvoke.execute(receiver, hasNext);
    }

    @ExportMessage
    static Object getIteratorNextElement(StaticObject receiver, @Bind(value="getMeta().java_util_Iterator_next") Method next, @Cached LookupAndInvokeKnownMethodNode lookupAndInvoke) throws StopIterationException {
        try {
            return lookupAndInvoke.execute(receiver, next);
        }
        catch (EspressoException e) {
            if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_util_NoSuchElementException)) {
                throw StopIterationException.create((Throwable)((Object)e));
            }
            throw e;
        }
    }
}

