/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage.decompressor;

import com.oracle.truffle.espresso.runtime.jimage.BasicImageReader;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressor;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class ZipDecompressor
implements ResourceDecompressor {
    public static final String NAME = "zip";

    ZipDecompressor() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ByteBuffer decompress(ResourceDecompressor.StringsProvider reader, ByteBuffer content, long originalSize) {
        Inflater inflater = new Inflater();
        inflater.setInput(content);
        ByteBuffer output = ByteBuffer.allocate(Math.toIntExact(originalSize)).order(content.order());
        try {
            inflater.inflate(output);
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        boolean finished = inflater.finished();
        inflater.end();
        if (!finished) {
            throw new RuntimeException("Unexpected end of zip data");
        }
        if (output.hasRemaining()) {
            BasicImageReader.LOGGER.warning("ZipDecompressor output was smaller than expected: " + output.remaining() + "bytes of output remaining");
        }
        return output.flip();
    }
}

