/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@GeneratedBy(value=StaticObject.class)
public final class StaticObjectGen {
    private StaticObjectGen() {
    }

    static {
        LibraryExport.register(StaticObject.class, (LibraryExport[])new LibraryExport[]{new DynamicDispatchLibraryExports()});
    }

    @GeneratedBy(value=StaticObject.class)
    public static class DynamicDispatchLibraryExports
    extends LibraryExport<DynamicDispatchLibrary> {
        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, StaticObject.class, false, false, 0);
        }

        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert (receiver instanceof StaticObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert (receiver instanceof StaticObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=StaticObject.class)
        public static class Uncached
        extends DynamicDispatchLibrary
        implements UnadoptableNode {
            protected Uncached(Object receiver) {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver instanceof StaticObject;
            }

            @CompilerDirectives.TruffleBoundary
            public Object cast(Object receiver) {
                return (StaticObject)receiver;
            }

            @CompilerDirectives.TruffleBoundary
            public Class<?> dispatch(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((StaticObject)receiver).dispatch();
            }
        }

        @GeneratedBy(value=StaticObject.class)
        public static class Cached
        extends DynamicDispatchLibrary {
            private final Class<? extends StaticObject> receiverClass_;

            protected Cached(Object receiver) {
                StaticObject castReceiver = (StaticObject)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public Object cast(Object receiver) {
                return CompilerDirectives.castExact((Object)receiver, this.receiverClass_);
            }

            public boolean accepts(Object receiver) {
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public Class<?> dispatch(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((StaticObject)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).dispatch();
            }
        }
    }
}

