/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.Classpath;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JImageExtensions {
    private final ZipFile zipFile;
    private final Map<String, Set<String>> extensions;

    public JImageExtensions(Path jarPath, Map<String, Set<String>> extensions) {
        this.extensions = extensions;
        try {
            this.zipFile = new ZipFile(jarPath.toFile());
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    public byte[] getClassBytes(ByteSequence name) {
        ZipEntry entry = this.zipFile.getEntry(name.toString());
        if (entry == null) {
            return null;
        }
        try {
            return Classpath.readZipEntry(this.zipFile, entry);
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }
}

