/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.Pair;

@EspressoSubstitutions
public final class Target_java_lang_invoke_MethodHandleNatives {
    @Substitution
    public static void init(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Object.class) StaticObject ref, @Inject Meta meta, @Inject EspressoLanguage language) {
        Klass targetKlass = ref.getKlass();
        if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Method) {
            Method target = Method.getHostReflectiveMethodRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(self, target, target.getRefKind(), meta);
            meta.java_lang_invoke_MemberName_clazz.setObject(self, target.getDeclaringKlass().mirror());
        } else if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Field) {
            Field field = Field.getReflectiveFieldRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedField(self, field, Target_java_lang_invoke_MethodHandleNatives.getRefKind(meta.java_lang_invoke_MemberName_flags.getInt(self)), meta, language);
            Klass fieldKlass = meta.java_lang_reflect_Field_class.getObject(ref).getMirrorKlass(meta);
            meta.java_lang_invoke_MemberName_clazz.setObject(self, fieldKlass.mirror());
        } else if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Constructor) {
            Method target = Method.getHostReflectiveConstructorRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(self, target, target.getRefKind(), meta);
            meta.java_lang_invoke_MemberName_clazz.setObject(self, target.getDeclaringKlass().mirror());
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("invalid argument for MemberName.init: " + String.valueOf(ref.getKlass()));
        }
    }

    @Substitution
    public static void expand(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(self)) {
            profiler.profile(0);
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "MemberName is null");
        }
        boolean haveClazz = !StaticObject.isNull(meta.java_lang_invoke_MemberName_clazz.getObject(self));
        boolean haveName = !StaticObject.isNull(meta.java_lang_invoke_MemberName_name.getObject(self));
        boolean haveType = !StaticObject.isNull(meta.java_lang_invoke_MemberName_type.getObject(self));
        int flags = meta.java_lang_invoke_MemberName_flags.getInt(self);
        switch (flags & 0xF0000) {
            case 65536: 
            case 131072: {
                Method m = (Method)meta.HIDDEN_VMTARGET.getHiddenObject(self);
                if (m == null) {
                    profiler.profile(2);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                if (!haveClazz) {
                    meta.java_lang_invoke_MemberName_clazz.setObject(self, m.getDeclaringKlass().mirror());
                }
                if (!haveName) {
                    meta.java_lang_invoke_MemberName_name.setObject(self, meta.toGuestString(m.getName()));
                }
                if (haveType) break;
                meta.java_lang_invoke_MemberName_type.setObject(self, meta.toGuestString(m.getRawSignature()));
                break;
            }
            case 262144: {
                Field f;
                StaticObject clazz = meta.java_lang_invoke_MemberName_clazz.getObject(self);
                if (StaticObject.isNull(clazz)) {
                    profiler.profile(3);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                Klass holder = clazz.getMirrorKlass(meta);
                int slot = Target_sun_misc_Unsafe.guestOffsetToSlot((Long)meta.HIDDEN_VMINDEX.getHiddenObject(self), language);
                boolean isStatic = (flags & 8) != 0;
                try {
                    f = isStatic ? holder.lookupStaticFieldTable(slot) : holder.lookupFieldTable(slot);
                }
                catch (IndexOutOfBoundsException e) {
                    f = null;
                }
                if (f == null) {
                    profiler.profile(4);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                if (!haveName) {
                    meta.java_lang_invoke_MemberName_name.setObject(self, meta.toGuestString(f.getName()));
                }
                if (haveType) break;
                if (Types.isPrimitive(f.getType())) {
                    Klass k = meta.resolvePrimitive(f.getType());
                    meta.java_lang_invoke_MemberName_type.setObject(self, k.mirror());
                    break;
                }
                meta.java_lang_invoke_MemberName_type.setObject(self, meta.toGuestString(f.getType()));
                break;
            }
            default: {
                profiler.profile(1);
                throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "MemberName is null");
            }
        }
    }

    @Substitution
    public static int getNamedCon(int which, @JavaType(value=Object[].class) StaticObject name, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (name.getKlass() == meta.java_lang_Object_array && name.length(language) > 0 && which < Constants.CONSTANTS.size()) {
            if (which >= Constants.CONSTANTS_BEFORE_16 && !meta.getJavaVersion().java16OrLater()) {
                return 0;
            }
            Pair<String, Integer> pair = Constants.CONSTANTS.get(which);
            meta.getInterpreterToVM().setArrayObject(language, meta.toGuestString((String)pair.getLeft()), 0, name);
            return (Integer)pair.getRight();
        }
        return 0;
    }

    @Substitution
    public static void setCallSiteTargetNormal(@JavaType(value=CallSite.class) StaticObject site, @JavaType(value=MethodHandle.class) StaticObject target, @Inject Meta meta) {
        meta.java_lang_invoke_CallSite_target.setObject(site, target);
    }

    @Substitution
    public static void setCallSiteTargetVolatile(@JavaType(value=CallSite.class) StaticObject site, @JavaType(value=MethodHandle.class) StaticObject target, @Inject Meta meta) {
        meta.java_lang_invoke_CallSite_target.setObject(site, target, true);
    }

    @Substitution
    public static int getMembers(@JavaType(value=Class.class) StaticObject defc, @JavaType(value=String.class) StaticObject matchName, @JavaType(value=String.class) StaticObject matchSig, int matchFlags, @JavaType(value=Class.class) StaticObject originalCaller, int skip, @JavaType(internalName="[Ljava/lang/invoke/MemberName;") StaticObject resultsArr, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(defc) || StaticObject.isNull(resultsArr)) {
            return -1;
        }
        EspressoContext context = meta.getContext();
        StaticObject[] results = (StaticObject[])resultsArr.unwrap(language);
        Symbol<Symbol.Name> name = null;
        if (!StaticObject.isNull(matchName) && (name = context.getNames().lookup(meta.toHostString(matchName))) == null) {
            return 0;
        }
        String sig = meta.toHostString(matchSig);
        if (sig == null) {
            return 0;
        }
        Klass caller = null;
        if (!StaticObject.isNull(originalCaller) && (caller = originalCaller.getMirrorKlass(meta)) == null) {
            return -1;
        }
        return Target_java_lang_invoke_MethodHandleNatives.findMemberNames(defc.getMirrorKlass(meta), name, sig, matchFlags, caller, skip, results);
    }

    private static int findMemberNames(Klass klass, Symbol<Symbol.Name> name, String sig, int matchFlags, Klass caller, int skip, StaticObject[] results) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.unimplemented();
    }

    @Substitution
    public static void registerNatives() {
    }

    @Substitution
    public static int getConstant(int which) {
        switch (which) {
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Substitution
    public static long objectFieldOffset(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return (Long)meta.HIDDEN_VMINDEX.getHiddenObject(self);
    }

    @Substitution
    public static long staticFieldOffset(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return (Long)meta.HIDDEN_VMINDEX.getHiddenObject(self);
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject staticFieldBase(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return meta.java_lang_invoke_MemberName_clazz.getObject(self).getMirrorKlass(meta).getStatics();
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject getMemberVMInfo(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        Object vmtarget = meta.HIDDEN_VMTARGET.getHiddenObject(self);
        Object vmindex = meta.HIDDEN_VMINDEX.getHiddenObject(self);
        StaticObject[] result = new StaticObject[]{vmindex == null ? meta.boxLong(-2000000L) : meta.boxLong((Long)vmindex), vmtarget == null ? StaticObject.NULL : (vmtarget instanceof Klass ? ((Klass)vmtarget).mirror() : self)};
        return StaticObject.createArray(meta.java_lang_Object_array, result, meta.getContext());
    }

    private static String asSignature(StaticObject typeObject, Meta meta) {
        Klass typeKlass = typeObject.getKlass();
        if (meta.java_lang_invoke_MethodType.isAssignableFrom(typeKlass)) {
            return Target_java_lang_invoke_MethodHandleNatives.methodTypeAsSignature(typeObject, meta);
        }
        if (meta.java_lang_Class.isAssignableFrom(typeKlass)) {
            return typeObject.getMirrorKlass(meta).getTypeAsString();
        }
        if (meta.java_lang_String.isAssignableFrom(typeKlass)) {
            return meta.toHostString(typeObject);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    private static String methodTypeAsSignature(StaticObject methodType, Meta meta) {
        EspressoLanguage language = meta.getLanguage();
        StringBuilder sb = new StringBuilder("(");
        StaticObject ptypes = meta.java_lang_invoke_MethodType_ptypes.getObject(methodType);
        int numParamTypes = ptypes.length(language);
        for (int i = 0; i < numParamTypes; ++i) {
            StaticObject ptype = (StaticObject)ptypes.get(language, i);
            sb.append(ptype.getMirrorKlass(meta).getTypeAsString());
        }
        sb.append(")");
        StaticObject rtype = meta.java_lang_invoke_MethodType_rtype.getObject(methodType);
        sb.append(rtype.getMirrorKlass(meta).getTypeAsString());
        return sb.toString();
    }

    private static void plantInvokeBasic(StaticObject memberName, Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig, ObjectKlass callerKlass, boolean accessCheck, Meta meta) {
        assert (name == Symbol.Name.invokeBasic);
        Method target = resolutionKlass.lookupMethod(name, sig);
        if (accessCheck) {
            MemberRefConstant.doAccessCheck(callerKlass, target.getDeclaringKlass(), target, meta);
        }
        meta.HIDDEN_VMTARGET.setHiddenObject(memberName, target);
        meta.java_lang_invoke_MemberName_flags.setInt(memberName, Target_java_lang_invoke_MethodHandleNatives.getMethodFlags(target, 7));
    }

    private static void plantMethodMemberName(StaticObject memberName, Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig, int refKind, ObjectKlass callerKlass, boolean accessCheck, boolean constraintsChecks, Meta meta) {
        if (refKind == 5 && resolutionKlass.isInterface()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, EspressoError.cat("Found interface ", resolutionKlass.getName(), ", but class was expected"));
        }
        Method target = refKind == 9 || refKind == 7 && resolutionKlass.isInterface() ? Target_java_lang_invoke_MethodHandleNatives.doInterfaceMethodLookup(resolutionKlass, name, sig, meta) : Target_java_lang_invoke_MethodHandleNatives.doMethodLookup(resolutionKlass, name, sig);
        if (target == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, EspressoError.cat("Failed lookup for method ", resolutionKlass.getName(), "#", name, ":", sig));
        }
        if (target.isStatic() != (refKind == 6)) {
            String expected = refKind == 6 ? "Static" : "Instance";
            String actual = refKind == 6 ? "Instance" : "Static";
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, EspressoError.cat(expected, " method lookup resulted in ", actual, " resolution for method ", resolutionKlass.getName(), "#", name, ":", sig));
        }
        if (accessCheck) {
            MemberRefConstant.doAccessCheck(callerKlass, target.getDeclaringKlass(), target, meta);
        }
        if (constraintsChecks) {
            target.checkLoadingConstraints(callerKlass.getDefiningClassLoader(), resolutionKlass.getDefiningClassLoader());
        }
        Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(memberName, target, refKind, meta);
    }

    public static void plantResolvedMethod(StaticObject memberName, Method target, int refKind, Meta meta) {
        meta.HIDDEN_VMTARGET.setHiddenObject(memberName, target);
        meta.java_lang_invoke_MemberName_flags.setInt(memberName, Target_java_lang_invoke_MethodHandleNatives.getMethodFlags(target, refKind));
        meta.java_lang_invoke_MemberName_clazz.setObject(memberName, target.getDeclaringKlass().mirror());
    }

    private static void plantFieldMemberName(StaticObject memberName, Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, int refKind, Klass callerKlass, boolean constraintsCheck, Meta meta, EspressoLanguage language) {
        Field field = Target_java_lang_invoke_MethodHandleNatives.doFieldLookup(resolutionKlass, name, type);
        if (field == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, EspressoError.cat("Failed lookup for field ", resolutionKlass.getName(), "#", name, ":", type));
        }
        if (constraintsCheck) {
            field.checkLoadingConstraints(callerKlass.getDefiningClassLoader(), resolutionKlass.getDefiningClassLoader());
        }
        Target_java_lang_invoke_MethodHandleNatives.plantResolvedField(memberName, field, refKind, meta, language);
    }

    private static void plantResolvedField(StaticObject memberName, Field field, int refKind, Meta meta, EspressoLanguage language) {
        meta.HIDDEN_VMTARGET.setHiddenObject(memberName, field.getDeclaringKlass());
        meta.HIDDEN_VMINDEX.setHiddenObject(memberName, Target_sun_misc_Unsafe.slotToGuestOffset(field.getSlot(), field.isStatic(), language));
        meta.java_lang_invoke_MemberName_flags.setInt(memberName, Target_java_lang_invoke_MethodHandleNatives.getFieldFlags(refKind, field));
        meta.java_lang_invoke_MemberName_clazz.setObject(memberName, field.getDeclaringKlass().mirror());
    }

    private static int getMethodFlags(Method target, int refKind) {
        int res = target.getMethodModifiers();
        if (refKind == 9) {
            if (target.isPrivate() || target.isFinalFlagSet() || target.getDeclaringKlass().isFinalFlagSet()) {
                res |= 0x7010000;
            } else if (target.getDeclaringKlass().isJavaLangObject()) {
                assert (target.getVTableIndex() >= 0);
                res |= 0x5010000;
            } else {
                assert (target.getITableIndex() >= 0);
                res |= 0x9010000;
            }
        } else if (refKind == 5) {
            if (target.isPrivate() || target.isFinalFlagSet() || target.getDeclaringKlass().isFinalFlagSet()) {
                res |= 0x7010000;
            } else {
                assert (target.getVTableIndex() >= 0);
                res |= 0x5010000;
            }
        } else {
            res = target.isStatic() ? (res |= 0x6010000) : (target.isConstructor() || target.isClassInitializer() ? (res |= 0x7020000) : (res |= 0x7010000));
        }
        if (target.isCallerSensitive()) {
            res |= 0x100000;
        }
        return res;
    }

    private static int getFieldFlags(int refKind, Field fd) {
        int res = fd.getModifiers();
        boolean isSetter = refKind <= 4 && refKind > 2;
        res |= 0x40000 | (fd.isStatic() ? 2 : 1) << 24;
        if (isSetter) {
            res += 0x2000000;
        }
        return res;
    }

    private static Method doMethodLookup(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)resolutionKlass)) {
            return Target_java_lang_invoke_MethodHandleNatives.lookupMethod(resolutionKlass, name, sig);
        }
        return Target_java_lang_invoke_MethodHandleNatives.lookupMethodBoundary(resolutionKlass, name, sig);
    }

    @CompilerDirectives.TruffleBoundary
    private static Method doInterfaceMethodLookup(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig, Meta meta) {
        if (!resolutionKlass.isInterface()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, meta.toGuestString(name));
        }
        return ((ObjectKlass)resolutionKlass).resolveInterfaceMethod(name, sig);
    }

    private static Method lookupMethod(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig) {
        return resolutionKlass.lookupMethod(name, sig);
    }

    @CompilerDirectives.TruffleBoundary
    private static Method lookupMethodBoundary(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> sig) {
        return Target_java_lang_invoke_MethodHandleNatives.lookupMethod(resolutionKlass, name, sig);
    }

    private static Field doFieldLookup(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Type> sig) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)resolutionKlass)) {
            return Target_java_lang_invoke_MethodHandleNatives.lookupField(resolutionKlass, name, sig);
        }
        return Target_java_lang_invoke_MethodHandleNatives.lookupFieldBoundary(resolutionKlass, name, sig);
    }

    private static Field lookupField(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Type> sig) {
        return resolutionKlass.lookupField(name, sig);
    }

    @CompilerDirectives.TruffleBoundary
    private static Field lookupFieldBoundary(Klass resolutionKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Type> sig) {
        return Target_java_lang_invoke_MethodHandleNatives.lookupField(resolutionKlass, name, sig);
    }

    public static int getRefKind(int flags) {
        return flags >> 24 & 0xF;
    }

    public static boolean isValidRefKind(int flags) {
        return flags > 0 && flags < 10;
    }

    @Substitution
    public static void clearCallSiteContext(@JavaType(internalName="Ljava/lang/invoke/MethodHandleNatives$CallSiteContext;") StaticObject context) {
    }

    public static final class Constants {
        public static final int MN_IS_METHOD = 65536;
        public static final int MN_IS_CONSTRUCTOR = 131072;
        public static final int MN_IS_FIELD = 262144;
        public static final int MN_IS_TYPE = 524288;
        public static final int MN_CALLER_SENSITIVE = 0x100000;
        public static final int MN_TRUSTED_FINAL = 0x200000;
        public static final int MN_REFERENCE_KIND_SHIFT = 24;
        public static final int MN_REFERENCE_KIND_MASK = 15;
        public static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        public static final int MN_SEARCH_INTERFACES = 0x200000;
        public static final int NESTMATE_CLASS = 1;
        public static final int HIDDEN_CLASS = 2;
        public static final int STRONG_LOADER_LINK = 4;
        public static final int ACCESS_VM_ANNOTATIONS = 8;
        public static final int LM_MODULE = 16;
        public static final int LM_UNCONDITIONAL = 32;
        public static final int LM_TRUSTED = -1;
        public static final int ALL_KINDS = 983040;
        static final List<Pair<String, Integer>> CONSTANTS = new ArrayList<Pair<String, Integer>>();
        static final int CONSTANTS_BEFORE_16;

        private Constants() {
        }

        static {
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_METHOD", (Object)65536));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_CONSTRUCTOR", (Object)131072));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_FIELD", (Object)262144));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_TYPE", (Object)524288));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_CALLER_SENSITIVE", (Object)0x100000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_TRUSTED_FINAL", (Object)0x200000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_SEARCH_SUPERCLASSES", (Object)0x100000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_SEARCH_INTERFACES", (Object)0x200000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_REFERENCE_KIND_SHIFT", (Object)24));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_REFERENCE_KIND_MASK", (Object)15));
            CONSTANTS_BEFORE_16 = CONSTANTS.size();
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"NESTMATE_CLASS", (Object)1));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"HIDDEN_CLASS", (Object)2));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"STRONG_LOADER_LINK", (Object)4));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"ACCESS_VM_ANNOTATIONS", (Object)8));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_MODULE", (Object)16));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_UNCONDITIONAL", (Object)32));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_TRUSTED", (Object)-1));
        }
    }

    static abstract class ResolveNode
    extends SubstitutionNode {
        ResolveNode() {
        }

        abstract @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject execute(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject var1, @JavaType(value=Class.class) StaticObject var2, int var3);

        @Specialization
        @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject doCached(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject memberName, @JavaType(value=Class.class) StaticObject caller, int lookupMode, @Bind(value="getMeta()") Meta meta, @Cached BranchProfile isMethodProfile, @Cached BranchProfile isFieldProfile, @Cached BranchProfile isConstructorProfile, @Cached BranchProfile noMethodNameProfile, @Cached BranchProfile isSignaturePolymorphicIntrinsicProfile, @Cached BranchProfile isInvokeStaticOrInterfaceProfile, @Cached BranchProfile isInvokeVirtualOrSpecialProfile, @Cached BranchProfile isHandleMethodProfile) {
            Symbol<Symbol.Name> methodName;
            if (meta.HIDDEN_VMTARGET.getHiddenObject(memberName) != null) {
                return memberName;
            }
            StaticObject clazz = meta.java_lang_invoke_MemberName_clazz.getObject(memberName);
            if (StaticObject.isNull(clazz)) {
                return StaticObject.NULL;
            }
            Klass resolutionKlass = clazz.getMirrorKlass(meta);
            int flags = meta.java_lang_invoke_MemberName_flags.getInt(memberName);
            int refKind = Target_java_lang_invoke_MethodHandleNatives.getRefKind(flags);
            StaticObject name = meta.java_lang_invoke_MemberName_name.getObject(memberName);
            if (StaticObject.isNull(name)) {
                return StaticObject.NULL;
            }
            try {
                methodName = meta.getNames().lookup(meta.toHostString(name));
            }
            catch (EspressoError e) {
                methodName = null;
            }
            if (methodName == null) {
                noMethodNameProfile.enter();
                if ((flags & 0xF0000) == 262144) {
                    throw meta.throwException(meta.java_lang_NoSuchFieldException);
                }
                throw meta.throwException(meta.java_lang_NoSuchMethodException);
            }
            MethodHandleIntrinsics.PolySigIntrinsics mhMethodId = MethodHandleIntrinsics.PolySigIntrinsics.None;
            if ((flags & 0xF0000) == 65536 && (resolutionKlass.getType() == Symbol.Type.java_lang_invoke_MethodHandle || resolutionKlass.getType() == Symbol.Type.java_lang_invoke_VarHandle)) {
                MethodHandleIntrinsics.PolySigIntrinsics iid;
                isHandleMethodProfile.enter();
                if ((refKind == 5 || refKind == 7 || refKind == 6) && (iid = MethodHandleIntrinsics.getId(methodName, resolutionKlass)) != MethodHandleIntrinsics.PolySigIntrinsics.None && refKind == 6 == iid.isStaticPolymorphicSignature()) {
                    mhMethodId = iid;
                }
            }
            ObjectKlass callerKlass = StaticObject.isNull(caller) ? null : (ObjectKlass)caller.getMirrorKlass(meta);
            boolean doAccessChecks = callerKlass != null;
            boolean doConstraintsChecks = callerKlass != null && (lookupMode & 0x20) == 0;
            StaticObject type = meta.java_lang_invoke_MemberName_type.getObject(memberName);
            if (StaticObject.isNull(type)) {
                return StaticObject.NULL;
            }
            String desc = Target_java_lang_invoke_MethodHandleNatives.asSignature(type, meta);
            switch (flags & 0xF0000) {
                case 131072: {
                    isConstructorProfile.enter();
                    Symbol<Symbol.Signature> constructorSignature = mhMethodId != MethodHandleIntrinsics.PolySigIntrinsics.None ? meta.getSignatures().symbolifyValidSignature(desc) : meta.getSignatures().lookupValidSignature(desc);
                    if (constructorSignature == null) {
                        throw meta.throwException(meta.java_lang_NoSuchMethodException);
                    }
                    Target_java_lang_invoke_MethodHandleNatives.plantMethodMemberName(memberName, resolutionKlass, methodName, constructorSignature, refKind, callerKlass, doAccessChecks, doConstraintsChecks, meta);
                    meta.HIDDEN_VMINDEX.setHiddenObject(memberName, -3000000L);
                    break;
                }
                case 65536: {
                    isMethodProfile.enter();
                    Symbol<Symbol.Signature> sig = mhMethodId != MethodHandleIntrinsics.PolySigIntrinsics.None ? meta.getSignatures().symbolifyValidSignature(desc) : meta.getSignatures().lookupValidSignature(desc);
                    if (sig == null) {
                        throw meta.throwException(meta.java_lang_NoSuchMethodException);
                    }
                    if (refKind == 6 || refKind == 9) {
                        isInvokeStaticOrInterfaceProfile.enter();
                        Target_java_lang_invoke_MethodHandleNatives.plantMethodMemberName(memberName, resolutionKlass, methodName, sig, refKind, callerKlass, doAccessChecks, doConstraintsChecks, meta);
                    } else if (mhMethodId != MethodHandleIntrinsics.PolySigIntrinsics.None) {
                        isSignaturePolymorphicIntrinsicProfile.enter();
                        assert (!mhMethodId.isStaticPolymorphicSignature()) : "Should have been handled by refKind == REF_invokeStatic";
                        EspressoError.guarantee(mhMethodId.isSignaturePolymorphicIntrinsic(), "Should never need to resolve invokeGeneric MemberName");
                        Target_java_lang_invoke_MethodHandleNatives.plantInvokeBasic(memberName, resolutionKlass, methodName, sig, callerKlass, doAccessChecks, meta);
                    } else if (refKind == 5 || refKind == 7) {
                        isInvokeVirtualOrSpecialProfile.enter();
                        Target_java_lang_invoke_MethodHandleNatives.plantMethodMemberName(memberName, resolutionKlass, methodName, sig, refKind, callerKlass, doAccessChecks, doConstraintsChecks, meta);
                    }
                    flags = meta.java_lang_invoke_MemberName_flags.getInt(memberName);
                    refKind = Target_java_lang_invoke_MethodHandleNatives.getRefKind(flags);
                    meta.HIDDEN_VMINDEX.setHiddenObject(memberName, refKind == 9 || refKind == 5 ? 1000000L : -1000000L);
                    break;
                }
                case 262144: {
                    isFieldProfile.enter();
                    Symbol<Symbol.Type> t = meta.getLanguage().getTypes().lookup(desc);
                    if (t == null) {
                        throw meta.throwException(meta.java_lang_NoSuchFieldException);
                    }
                    Target_java_lang_invoke_MethodHandleNatives.plantFieldMemberName(memberName, resolutionKlass, methodName, t, refKind, callerKlass, doConstraintsChecks, meta, this.getLanguage());
                    break;
                }
                default: {
                    throw meta.throwExceptionWithMessage(meta.java_lang_LinkageError, "Member name resolution failed");
                }
            }
            return memberName;
        }
    }

    @Substitution(methodName="resolve")
    static abstract class ResolveOverload17
    extends SubstitutionNode {
        ResolveOverload17() {
        }

        abstract @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject execute(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject var1, @JavaType(value=Class.class) StaticObject var2, int var3, boolean var4);

        @Specialization
        @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject doCached(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, int lookupMode, boolean speculativeResolve, @Cached ResolveNode resolve) {
            EspressoException error = null;
            try {
                return resolve.execute(self, caller, lookupMode);
            }
            catch (EspressoException e) {
                error = e;
                Meta meta = this.getMeta();
                int refKind = Target_java_lang_invoke_MethodHandleNatives.getRefKind(meta.java_lang_invoke_MemberName_flags.getInt(self));
                if (!Target_java_lang_invoke_MethodHandleNatives.isValidRefKind(refKind)) {
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "obsolete MemberName format");
                }
                if (!speculativeResolve) {
                    throw error;
                }
                return StaticObject.NULL;
            }
        }
    }

    @Substitution(methodName="resolve")
    static abstract class ResolveOverload11
    extends EspressoNode {
        ResolveOverload11() {
        }

        abstract @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject execute(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject var1, @JavaType(value=Class.class) StaticObject var2, boolean var3);

        @Specialization
        @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject doCached(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, boolean speculativeResolve, @Cached ResolveNode resolve) {
            try {
                return resolve.execute(self, caller, 32);
            }
            catch (EspressoException e) {
                if (speculativeResolve) {
                    return StaticObject.NULL;
                }
                throw e;
            }
        }
    }

    @Substitution(methodName="resolve")
    static abstract class ResolveOverload8
    extends EspressoNode {
        ResolveOverload8() {
        }

        abstract @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject execute(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject var1, @JavaType(value=Class.class) StaticObject var2);

        @Specialization
        @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject doCached(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, @Cached ResolveOverload11 resolve) {
            return resolve.execute(self, caller, false);
        }
    }
}

