/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.Target_java_util_regex_Matcher;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

@EspressoSubstitutions
public final class Target_java_util_regex_Pattern {
    static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", (String)"Regex");
    private static final int ALL_FLAGS = 511;

    private Target_java_util_regex_Pattern() {
    }

    static boolean isUnsupportedPattern(StaticObject parentPattern, Meta meta) {
        if (meta.java_util_regex_Pattern_HIDDEN_unsupported == null) {
            return true;
        }
        Object unsupported = meta.java_util_regex_Pattern_HIDDEN_unsupported.getHiddenObject(parentPattern);
        return unsupported == null || (Boolean)unsupported != false;
    }

    @CompilerDirectives.TruffleBoundary
    public static String convertFlags(int flags) {
        StringBuilder sb = new StringBuilder(8);
        if (Target_java_util_regex_Pattern.isSet(flags, 128)) {
            sb.append('c');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 256)) {
            sb.append('U');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 1)) {
            sb.append('d');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 2)) {
            sb.append('i');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 8)) {
            sb.append('m');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 32)) {
            sb.append('s');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 64)) {
            sb.append('u');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 4)) {
            sb.append('x');
        }
        if (Target_java_util_regex_Pattern.isSet(flags, 16)) {
            sb.append('l');
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static String unknownFlagMessage(int f) {
        return "Unknown flag 0x" + Integer.toHexString(f);
    }

    private static boolean isSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    @Substitution(hasReceiver=true, methodName="namedGroups")
    static abstract class NamedGroups
    extends SubstitutionNode {
        NamedGroups() {
        }

        abstract @JavaType(value=Map.class) StaticObject execute(@JavaType(value=Pattern.class) StaticObject var1);

        @Specialization(guards={"context.regexSubstitutionsEnabled()"})
        static @JavaType(value=Map.class) StaticObject doDefault(StaticObject self, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Pattern_namedGroups.getCallTargetNoSubstitution())") DirectCallNode original, @Cached(value="create(context.getMeta().java_util_regex_Pattern_init.getCallTargetNoSubstitution())") DirectCallNode initOriginal) {
            if (context.getMeta().java_util_regex_Pattern_namedGroups_field.getObject(self) == StaticObject.NULL) {
                StaticObject pattern = context.getMeta().java_util_regex_Pattern_pattern.getObject(self);
                Object flags = context.getMeta().java_util_regex_Pattern_flags.getValue(self);
                initOriginal.call(new Object[]{self, pattern, flags});
            }
            return (StaticObject)original.call(new Object[]{self});
        }

        @Specialization(guards={"!context.regexSubstitutionsEnabled()"})
        static StaticObject doDisabled(StaticObject self, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Pattern_namedGroups.getCallTargetNoSubstitution())") DirectCallNode original) {
            return (StaticObject)original.call(new Object[]{self});
        }
    }

    @Substitution(hasReceiver=true, methodName="<init>")
    static abstract class Init
    extends SubstitutionNode {
        Init() {
        }

        abstract void execute(@JavaType(value=Pattern.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2, int var3);

        @Specialization(guards={"context.regexSubstitutionsEnabled()"})
        void doDefault(StaticObject self, StaticObject p, int f, @Bind(value="getContext()") EspressoContext context, @CachedLibrary(limit="3") InteropLibrary regexInterop, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Pattern_init.getCallTargetNoSubstitution())") DirectCallNode original, @Cached InlinedBranchProfile parseErrorProfile, @Cached InlinedBranchProfile argErrorProfile) {
            Meta meta = context.getMeta();
            if (StaticObject.isNull(p)) {
                argErrorProfile.enter((Node)this);
                throw meta.throwNullPointerException();
            }
            if ((f & 0xFFFFFE00) != 0) {
                argErrorProfile.enter((Node)this);
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, Target_java_util_regex_Pattern.unknownFlagMessage(f));
            }
            String pattern = meta.toHostString(p);
            Source src = Target_java_util_regex_Matcher.getSource(Target_java_util_regex_Matcher.RegexAction.Validate, pattern, f, meta.getJavaVersion());
            try {
                context.getEnv().parseInternal(src, new String[0]).call(new Object[0]);
            }
            catch (Exception e) {
                parseErrorProfile.enter((Node)this);
                try {
                    if (regexInterop.isException((Object)e) && regexInterop.getExceptionType((Object)e) == ExceptionType.PARSE_ERROR) {
                        LOGGER.log(Level.FINE, (Throwable)e, () -> "Unsupported Pattern: " + pattern);
                        meta.java_util_regex_Pattern_HIDDEN_unsupported.setHiddenObject(self, true);
                        original.call(new Object[]{self, p, f});
                        return;
                    }
                    throw e;
                }
                catch (UnsupportedMessageException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere(ex);
                }
            }
            meta.java_util_regex_Pattern_HIDDEN_tregexSearch.setHiddenObject(self, null);
            meta.java_util_regex_Pattern_HIDDEN_tregexMatch.setHiddenObject(self, null);
            meta.java_util_regex_Pattern_HIDDEN_tregexFullmatch.setHiddenObject(self, null);
            meta.java_util_regex_Pattern_HIDDEN_unsupported.setHiddenObject(self, false);
            meta.java_util_regex_Pattern_capturingGroupCount.setInt(self, -1);
            meta.java_util_regex_Pattern_pattern.setObject(self, p);
            meta.java_util_regex_Pattern_flags.setInt(self, f);
            meta.java_util_regex_Pattern_flags0.setInt(self, f);
            meta.java_util_regex_Pattern_compiled.setBoolean(self, true);
        }

        @Specialization(guards={"!context.regexSubstitutionsEnabled()"})
        static void doDisabled(StaticObject self, StaticObject p, int f, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Pattern_init.getCallTargetNoSubstitution())") DirectCallNode original) {
            original.call(new Object[]{self, p, f});
        }
    }
}

