/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.ModuleExtension;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.util.ArrayList;
import java.util.Set;

@EspressoSubstitutions(nameProvider=Provider.class)
public final class Target_jdk_internal_module_ModuleLoaderMap_Modules {
    private static final String[] TARGET_NAME = new String[]{"Target_jdk_internal_module_ModuleLoaderMap$Modules"};

    public static class Provider
    extends SubstitutionNamesProvider {
        public static final Provider INSTANCE = new Provider();

        @Override
        public String[] substitutionClassNames() {
            return TARGET_NAME;
        }
    }

    @Substitution(methodName="<clinit>")
    public static abstract class Clinit
    extends SubstitutionNode {
        public abstract void execute();

        @Specialization
        public static void clinit(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().jdk_internal_module_ModuleLoaderMap_Modules_clinit.getCallTargetNoSubstitution())") DirectCallNode original) {
            ModuleExtension[] platformExtensions;
            Meta meta = context.getMeta();
            assert (meta.getJavaVersion().java17OrLater());
            original.call(new Object[0]);
            ModuleExtension[] bootExtensions = ModuleExtension.getBootExtensions(context);
            if (bootExtensions.length > 0) {
                Clinit.spoofModules(Symbol.Name.bootModules, meta, bootExtensions);
            }
            if ((platformExtensions = ModuleExtension.getPlatformExtensions(context)).length > 0) {
                Clinit.spoofModules(Symbol.Name.platformModules, meta, platformExtensions);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void spoofModules(Symbol<Symbol.Name> fieldName, Meta meta, ModuleExtension[] toAdd) {
            Field field = meta.jdk_internal_module_ModuleLoaderMap_Modules.lookupDeclaredField(fieldName, Symbol.Type.java_util_Set);
            StaticObject staticStorage = meta.jdk_internal_module_ModuleLoaderMap_Modules.tryInitializeAndGetStatics();
            @JavaType(value=Set.class) StaticObject originalResult = field.getObject(staticStorage);
            ArrayList<String> moduleNames = new ArrayList<String>(toAdd.length);
            for (ModuleExtension moduleExtension : toAdd) {
                moduleNames.add(moduleExtension.moduleName());
            }
            field.setObject(staticStorage, meta.extendedStringSet(originalResult, moduleNames));
        }
    }
}

