/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.VersionFilter;

@EspressoSubstitutions
public final class Target_jdk_internal_util_ArraysSupport {

    static abstract class CopyToGuestArrayNode
    extends EspressoNode {
        static final int LIMIT = 4;

        CopyToGuestArrayNode() {
        }

        public abstract @JavaType(value=Object.class) StaticObject execute(StaticObject var1);

        @Specialization(guards={"foreignArray.getKlass() == cachedKlass"}, limit="LIMIT")
        @JavaType(value=Object.class) StaticObject doCached(StaticObject foreignArray, @Cached(value="foreignArray.getKlass()") Klass cachedKlass, @Bind(value="getMeta()") Meta meta, @CachedLibrary(value="foreignArray.rawForeignObject(meta.getLanguage())") InteropLibrary interop) {
            return CopyToGuestArrayNode.copyToGuestArray(foreignArray.rawForeignObject(meta.getLanguage()), meta, interop, cachedKlass);
        }

        @Specialization(replaces={"doCached"})
        @JavaType(value=Object.class) StaticObject generic(StaticObject foreignArray, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return CopyToGuestArrayNode.copyToGuestArray(foreignArray.rawForeignObject(meta.getLanguage()), meta, interop, foreignArray.getKlass());
        }

        private static StaticObject copyToGuestArray(Object rawForeignObject, Meta meta, InteropLibrary interop, Klass klass) {
            assert (interop.hasArrayElements(rawForeignObject) || interop.hasBufferElements(rawForeignObject));
            StaticObject result = null;
            try {
                if (klass == meta._boolean_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    boolean[] primitiveArray = new boolean[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = (Boolean)interop.readArrayElement(rawForeignObject, (long)i);
                    }
                    result = StaticObject.createArray(meta._boolean_array, primitiveArray, meta.getContext());
                } else if (klass == meta._int_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    int[] primitiveArray = new int[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = (Integer)interop.readArrayElement(rawForeignObject, (long)i);
                    }
                    result = StaticObject.createArray(meta._int_array, primitiveArray, meta.getContext());
                } else if (klass == meta._long_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    long[] primitiveArray = new long[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = (Long)interop.readArrayElement(rawForeignObject, (long)i);
                    }
                    result = StaticObject.createArray(meta._long_array, primitiveArray, meta.getContext());
                } else if (klass == meta._double_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    double[] primitiveArray = new double[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = (Double)interop.readArrayElement(rawForeignObject, (long)i);
                    }
                    result = StaticObject.createArray(meta._double_array, primitiveArray, meta.getContext());
                } else if (klass == meta._float_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    float[] primitiveArray = new float[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = ((Float)interop.readArrayElement(rawForeignObject, (long)i)).floatValue();
                    }
                    result = StaticObject.createArray(meta._float_array, primitiveArray, meta.getContext());
                } else if (klass == meta._short_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    short[] primitiveArray = new short[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = (Short)interop.readArrayElement(rawForeignObject, (long)i);
                    }
                    result = StaticObject.createArray(meta._short_array, primitiveArray, meta.getContext());
                } else if (klass == meta._byte_array) {
                    if (interop.hasBufferElements(rawForeignObject)) {
                        long bufferSize = interop.getBufferSize(rawForeignObject);
                        byte[] primitiveArray = new byte[(int)bufferSize];
                        interop.readBuffer(rawForeignObject, 0L, primitiveArray, 0, (int)bufferSize);
                        result = StaticObject.createArray(meta._byte_array, primitiveArray, meta.getContext());
                    } else {
                        long arraySize = interop.getArraySize(rawForeignObject);
                        byte[] primitiveArray = new byte[(int)arraySize];
                        for (int i = 0; i < primitiveArray.length; ++i) {
                            primitiveArray[i] = (Byte)interop.readArrayElement(rawForeignObject, (long)i);
                        }
                        result = StaticObject.createArray(meta._byte_array, primitiveArray, meta.getContext());
                    }
                } else if (klass == meta._char_array) {
                    long arraySize = interop.getArraySize(rawForeignObject);
                    char[] primitiveArray = new char[(int)arraySize];
                    for (int i = 0; i < primitiveArray.length; ++i) {
                        primitiveArray[i] = ((Character)interop.readArrayElement(rawForeignObject, (long)i)).charValue();
                    }
                    result = StaticObject.createArray(meta._char_array, primitiveArray, meta.getContext());
                }
            }
            catch (InvalidArrayIndexException | InvalidBufferOffsetException | UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("unsupported foreign array in ArraysSupport.vectorizedMismatch", ex);
            }
            return result;
        }
    }

    @Substitution(versionFilter=VersionFilter.Java9OrLater.class)
    static abstract class VectorizedMismatch
    extends SubstitutionNode {
        static final int LIMIT = 5;

        VectorizedMismatch() {
        }

        abstract int execute(@JavaType(value=Object.class) StaticObject var1, long var2, @JavaType(value=Object.class) StaticObject var4, long var5, int var7, int var8);

        @Specialization(guards={"a.isEspressoObject()", "b.isEspressoObject()"})
        int doEspresso(@JavaType(value=Object.class) StaticObject a, long aOffset, @JavaType(value=Object.class) StaticObject b, long bOffset, int length, int log2ArrayIndexScale, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.jdk_internal_util_ArraysSupport_vectorizedMismatch.getCallTargetNoSubstitution())") DirectCallNode original) {
            return (Integer)original.call(new Object[]{a, aOffset, b, bOffset, length, log2ArrayIndexScale});
        }

        @Specialization(guards={"a.isForeignObject()", "b.isForeignObject()"})
        int doBothForeign(@JavaType(value=Object.class) StaticObject a, long aOffset, @JavaType(value=Object.class) StaticObject b, long bOffset, int length, int log2ArrayIndexScale, @Bind(value="getMeta()") Meta meta, @Cached CopyToGuestArrayNode copyNode, @Cached(value="create(meta.jdk_internal_util_ArraysSupport_vectorizedMismatch.getCallTargetNoSubstitution())") DirectCallNode original) {
            assert (a.getKlass().isArray());
            assert (a.getKlass() == b.getKlass());
            return (Integer)original.call(new Object[]{copyNode.execute(a), aOffset, copyNode.execute(b), bOffset, length, log2ArrayIndexScale});
        }

        @Specialization(guards={"a.isForeignObject()", "b.isEspressoObject()"})
        int doFirstForeign(@JavaType(value=Object.class) StaticObject a, long aOffset, @JavaType(value=Object.class) StaticObject b, long bOffset, int length, int log2ArrayIndexScale, @Cached CopyToGuestArrayNode copyNode, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.jdk_internal_util_ArraysSupport_vectorizedMismatch.getCallTargetNoSubstitution())") DirectCallNode original) {
            assert (a.getKlass().isArray());
            assert (a.getKlass() == b.getKlass());
            return (Integer)original.call(new Object[]{copyNode.execute(a), aOffset, b, bOffset, length, log2ArrayIndexScale});
        }

        @Specialization(guards={"a.isEspressoObject()", "b.isForeignObject()"})
        int doSecondForeign(@JavaType(value=Object.class) StaticObject a, long aOffset, @JavaType(value=Object.class) StaticObject b, long bOffset, int length, int log2ArrayIndexScale, @Bind(value="getMeta()") Meta meta, @Cached CopyToGuestArrayNode copyNode, @Cached(value="create(meta.jdk_internal_util_ArraysSupport_vectorizedMismatch.getCallTargetNoSubstitution())") DirectCallNode original) {
            assert (a.getKlass().isArray());
            assert (a.getKlass() == b.getKlass());
            return (Integer)original.call(new Object[]{a, aOffset, copyNode.execute(b), bOffset, length, log2ArrayIndexScale});
        }
    }
}

