/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.meta.EspressoError;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class UnsafeSupport {
    private static final Unsafe UNSAFE;

    private UnsafeSupport() {
    }

    static boolean isBigEndian() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    static boolean compareAndSetByte(Object o, long offset, byte expected, byte x) {
        return UnsafeSupport.compareAndExchangeByte(o, offset, expected, x) == expected;
    }

    static boolean compareAndSetBoolean(Object o, long offset, boolean expected, boolean x) {
        byte byteExpected = expected ? (byte)1 : 0;
        byte byteX = x ? (byte)1 : 0;
        return UnsafeSupport.compareAndSetByte(o, offset, byteExpected, byteX);
    }

    static boolean compareAndSetShort(Object o, long offset, short expected, short x) {
        return UnsafeSupport.compareAndExchangeShort(o, offset, expected, x) == expected;
    }

    static boolean compareAndSetChar(Object o, long offset, char expected, char x) {
        return UnsafeSupport.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    static boolean compareAndSetFloat(Object o, long offset, float expected, float x) {
        return UNSAFE.compareAndSwapInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    static boolean compareAndSetDouble(Object o, long offset, double expected, double x) {
        return UNSAFE.compareAndSwapLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    static byte compareAndExchangeByte(Object o, long offset, byte expected, byte x) {
        int fullWord;
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (UnsafeSupport.isBigEndian()) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (x & 0xFF) << shift;
        do {
            if (((fullWord = UNSAFE.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!UNSAFE.compareAndSwapInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    static boolean compareAndExchangeBoolean(Object o, long offset, boolean expected, boolean x) {
        byte byteExpected = expected ? (byte)1 : 0;
        byte byteX = x ? (byte)1 : 0;
        return UnsafeSupport.compareAndExchangeByte(o, offset, byteExpected, byteX) != 0;
    }

    static short compareAndExchangeShort(Object o, long offset, short expected, short x) {
        int fullWord;
        if ((offset & 3L) == 3L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (UnsafeSupport.isBigEndian()) {
            shift = 16 - shift;
        }
        int mask = 65535 << shift;
        int maskedExpected = (expected & 0xFFFF) << shift;
        int maskedX = (x & 0xFFFF) << shift;
        do {
            if (((fullWord = UNSAFE.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (short)((fullWord & mask) >> shift);
        } while (!UNSAFE.compareAndSwapInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    static char compareAndExchangeChar(Object o, long offset, char expected, char x) {
        return (char)UnsafeSupport.compareAndExchangeShort(o, offset, (short)expected, (short)x);
    }

    static int compareAndExchangeInt(Object o, long offset, int expected, int x) {
        do {
            int result;
            if ((result = UNSAFE.getIntVolatile(o, offset)) == expected) continue;
            return result;
        } while (!UNSAFE.compareAndSwapInt(o, offset, expected, x));
        return expected;
    }

    static Object compareAndExchangeObject(Object o, long offset, Object expected, Object x) {
        do {
            Object result;
            if ((result = UNSAFE.getObjectVolatile(o, offset)) == expected) continue;
            return result;
        } while (!UNSAFE.compareAndSwapObject(o, offset, expected, x));
        return expected;
    }

    static float compareAndExchangeFloat(Object o, long offset, float expected, float x) {
        return Float.intBitsToFloat(UnsafeSupport.compareAndExchangeInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x)));
    }

    static long compareAndExchangeLong(Object o, long offset, long expected, long x) {
        do {
            long result;
            if ((result = UNSAFE.getLongVolatile(o, offset)) == expected) continue;
            return result;
        } while (!UNSAFE.compareAndSwapLong(o, offset, expected, x));
        return expected;
    }

    static double compareAndExchangeDouble(Object o, long offset, double expected, double x) {
        return Double.longBitsToDouble(UnsafeSupport.compareAndExchangeLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x)));
    }

    static void copySwapMemory(Object src, long srcOffset, Object dst, long destOffset, long bytes, long elemSize) {
        switch ((int)elemSize) {
            case 2: {
                CSMHelper.do2(src, srcOffset, dst, destOffset, bytes, elemSize);
                return;
            }
            case 4: {
                CSMHelper.do4(src, srcOffset, dst, destOffset, bytes, elemSize);
                return;
            }
            case 8: {
                CSMHelper.do8(src, srcOffset, dst, destOffset, bytes, elemSize);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InternalError();
        }
    }

    private static final class CSMHelper {
        private CSMHelper() {
        }

        private static Direction getDirection(Object src, long srcOffset, Object dst, long destOffset, long bytes) {
            long srcEnd = srcOffset + bytes;
            if (src == dst) {
                return destOffset <= srcOffset || destOffset >= srcEnd ? Direction.Right : Direction.Left;
            }
            return Direction.Right;
        }

        private static char swap(char c) {
            return Character.reverseBytes(c);
        }

        private static int swap(int i) {
            return Integer.reverseBytes(i);
        }

        private static long swap(long l) {
            return Long.reverseBytes(l);
        }

        static void do2(Object src, long srcOffset, Object dst, long destOffset, long bytes, long elemSize) {
            assert (elemSize == 2L) : elemSize;
            Direction d = CSMHelper.getDirection(src, srcOffset, dst, destOffset, bytes);
            long pos = d.initPos(bytes, elemSize);
            for (long copied = 0L; copied < bytes; copied += elemSize) {
                char tmp = UNSAFE.getChar(src, srcOffset + pos);
                tmp = CSMHelper.swap(tmp);
                UNSAFE.putChar(dst, destOffset + pos, tmp);
                pos += d.inc(elemSize);
            }
        }

        static void do4(Object src, long srcOffset, Object dst, long destOffset, long bytes, long elemSize) {
            assert (elemSize == 4L) : elemSize;
            Direction d = CSMHelper.getDirection(src, srcOffset, dst, destOffset, bytes);
            long pos = d.initPos(bytes, elemSize);
            for (long copied = 0L; copied < bytes; copied += elemSize) {
                int tmp = CSMHelper.swap(UNSAFE.getInt(src, srcOffset + pos));
                UNSAFE.putInt(dst, destOffset + pos, tmp);
                pos += d.inc(elemSize);
            }
        }

        static void do8(Object src, long srcOffset, Object dst, long destOffset, long bytes, long elemSize) {
            assert (elemSize == 8L) : elemSize;
            Direction d = CSMHelper.getDirection(src, srcOffset, dst, destOffset, bytes);
            long pos = d.initPos(bytes, elemSize);
            for (long copied = 0L; copied < bytes; copied += elemSize) {
                long tmp = CSMHelper.swap(UNSAFE.getLong(src, srcOffset + pos));
                UNSAFE.putLong(dst, destOffset + pos, tmp);
                pos += d.inc(elemSize);
            }
        }

        private static enum Direction {
            Right(1),
            Left(-1);

            final int dir;

            private Direction(int dir) {
                this.dir = dir;
            }

            long initPos(long bytes, long elemSize) {
                return this == Right ? 0L : bytes - elemSize;
            }

            long inc(long elemSize) {
                return (long)this.dir * elemSize;
            }
        }
    }
}

