/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;

class ReferenceOperand
extends Operand {
    protected final Symbol<Symbol.Type> type;
    final Klass thisKlass;
    protected Klass klass = null;

    ReferenceOperand(Symbol<Symbol.Type> type, Klass thisKlass) {
        super(JavaKind.Object);
        this.type = type;
        this.thisKlass = thisKlass;
    }

    ReferenceOperand(Klass klass, Klass thisKlass) {
        super(JavaKind.Object);
        this.type = klass.getType();
        this.klass = klass;
        this.thisKlass = thisKlass;
    }

    @Override
    boolean isReference() {
        return true;
    }

    @Override
    Symbol<Symbol.Type> getType() {
        return this.type;
    }

    @Override
    Klass getKlass() {
        if (this.klass == null) {
            try {
                this.klass = this.getType() == this.thisKlass.getType() ? this.thisKlass : this.thisKlass.getMeta().resolveSymbolOrNull(this.type, this.thisKlass.getDefiningClassLoader(), this.thisKlass.protectionDomain());
            }
            catch (EspressoException e) {
                if (this.thisKlass.getMeta().java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                    throw MethodVerifier.failNoClassDefFound(this.type.toString());
                }
                throw e;
            }
            if (this.klass == null) {
                throw MethodVerifier.failNoClassDefFound(this.type.toString());
            }
        }
        return this.klass;
    }

    @Override
    boolean compliesWith(Operand other) {
        if (other.isReference()) {
            Klass otherKlass;
            if (this.type == null || other.getType() == Symbol.Type.java_lang_Object) {
                return true;
            }
            if (other.getType() == null) {
                return false;
            }
            if (other.getType() == this.type && ((otherKlass = ((ReferenceOperand)other).klass) == null || this.klass == null)) {
                Klass k;
                Klass klass = k = this.klass == null ? otherKlass : this.klass;
                if (k == null || k.getDefiningClassLoader() == this.thisKlass.getDefiningClassLoader()) {
                    return true;
                }
            }
            if ((otherKlass = other.getKlass()).isInterface()) {
                return true;
            }
            return otherKlass.isAssignableFrom(this.getKlass());
        }
        return other.isTopOperand();
    }

    @Override
    boolean compliesWithInMerge(Operand other) {
        if (other.isUninit()) {
            return false;
        }
        return this.compliesWith(other);
    }

    @Override
    Operand mergeWith(Operand other) {
        if (!other.isReference()) {
            return null;
        }
        if (other.isUninit()) {
            return null;
        }
        if (other.isArrayType()) {
            return MethodVerifier.jlObject;
        }
        if (other.isNull()) {
            return this;
        }
        Klass result = this.getKlass().findLeastCommonAncestor(other.getKlass());
        return result == null ? null : new ReferenceOperand(result, this.thisKlass);
    }

    public String toString() {
        return this.type == null ? "null" : this.type.toString();
    }
}

