/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

public final class FrameCookie {
    private final CookieKind kind;
    private final long data;

    public long getData() {
        return this.data;
    }

    private FrameCookie(CookieKind kind, long data) {
        this.kind = kind;
        this.data = data;
    }

    public static FrameCookie createPrivilegedCookie(long data) {
        return new FrameCookie(CookieKind.Privileged, data);
    }

    public static FrameCookie createStackWalkCookie(long data) {
        return new FrameCookie(CookieKind.StackWalk, data);
    }

    public boolean isPrivileged() {
        return this.kind == CookieKind.Privileged;
    }

    public boolean isStackWalk() {
        return this.kind == CookieKind.StackWalk;
    }

    static enum CookieKind {
        Privileged,
        StackWalk;

    }
}

