/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EspressoScope {
    public static Object createVariables(Local[] liveLocals, Frame frame, Symbol<Symbol.Name> scopeName) {
        Map<String, FrameSlotInfo> identifiersMap;
        Map<String, FrameSlotInfo> slotsMap;
        int slotCount = liveLocals.length;
        if (liveLocals.length == 0) {
            slotsMap = Collections.emptyMap();
            identifiersMap = Collections.emptyMap();
        } else if (liveLocals.length == 1) {
            int slot = 0;
            String identifier = "0";
            Local local = liveLocals[0];
            FrameSlotInfo frameSlotInfo = new FrameSlotInfo(slot, Types.getJavaKind(local.getType().value()));
            slotsMap = Collections.singletonMap(identifier, frameSlotInfo);
            identifiersMap = Collections.singletonMap(local.getNameAsString(), frameSlotInfo);
        } else {
            slotsMap = new LinkedHashMap(slotCount);
            identifiersMap = new LinkedHashMap<String, FrameSlotInfo>(slotCount);
            for (Local local : liveLocals) {
                String slotNumber = String.valueOf(local.getSlot());
                String localName = local.getNameAsString();
                FrameSlotInfo frameSlotInfo = new FrameSlotInfo(local.getSlot(), Types.getJavaKind(local.getType().value()));
                slotsMap.put(slotNumber, frameSlotInfo);
                identifiersMap.put(localName, frameSlotInfo);
            }
        }
        return new VariablesMapObject(slotsMap, identifiersMap, frame, scopeName);
    }

    private static class FrameSlotInfo {
        private final int slot;
        private final JavaKind kind;

        FrameSlotInfo(int slot, JavaKind kind) {
            this.slot = slot;
            this.kind = kind;
        }

        public int getSlot() {
            return this.slot;
        }

        public JavaKind getKind() {
            return this.kind;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariablesMapObject
    implements TruffleObject {
        final Map<String, FrameSlotInfo> slots;
        final Map<String, FrameSlotInfo> identifiers;
        final Frame frame;
        final Symbol<Symbol.Name> scopeName;

        private VariablesMapObject(Map<String, FrameSlotInfo> slots, Map<String, FrameSlotInfo> identifiers, Frame frame, Symbol<Symbol.Name> scopeName) {
            this.slots = slots;
            this.identifiers = identifiers;
            this.frame = frame;
            this.scopeName = scopeName;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return EspressoLanguage.class;
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects) {
            return this.scopeName.toString();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String member) throws UnknownIdentifierException {
            if (this.frame == null) {
                return NullValue.INSTANCE;
            }
            FrameSlotInfo slotInfo = this.slots.get(member);
            if (slotInfo == null) {
                slotInfo = this.identifiers.get(member);
            }
            if (slotInfo == null) {
                throw UnknownIdentifierException.create((String)member);
            }
            switch (slotInfo.getKind()) {
                case Boolean: {
                    return EspressoFrame.getLocalInt(this.frame, slotInfo.getSlot()) != 0;
                }
                case Byte: {
                    return (byte)EspressoFrame.getLocalInt(this.frame, slotInfo.getSlot());
                }
                case Short: {
                    return (short)EspressoFrame.getLocalInt(this.frame, slotInfo.getSlot());
                }
                case Char: {
                    return Character.valueOf((char)EspressoFrame.getLocalInt(this.frame, slotInfo.getSlot()));
                }
                case Int: {
                    return EspressoFrame.getLocalInt(this.frame, slotInfo.getSlot());
                }
                case Float: {
                    return Float.valueOf(EspressoFrame.getLocalFloat(this.frame, slotInfo.getSlot()));
                }
                case Long: {
                    return EspressoFrame.getLocalLong(this.frame, slotInfo.getSlot());
                }
                case Double: {
                    return EspressoFrame.getLocalDouble(this.frame, slotInfo.getSlot());
                }
                case Object: {
                    return EspressoFrame.getLocalObject(this.frame, slotInfo.getSlot());
                }
            }
            CompilerAsserts.neverPartOfCompilation();
            throw EspressoError.shouldNotReachHere();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            return new VariableNamesObject(this.identifiers.keySet());
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String member) {
            return this.slots.containsKey(member) || this.identifiers.containsKey(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberModifiable(String member) {
            return (this.slots.containsKey(member) || this.identifiers.containsKey(member)) && this.frame != null;
        }

        @ExportMessage(limit="9")
        @CompilerDirectives.TruffleBoundary
        void writeMember(String member, Object value, @CachedLibrary(value="value") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.frame == null) {
                throw UnsupportedMessageException.create();
            }
            FrameSlotInfo slotInfo = this.slots.get(member);
            if (slotInfo == null) {
                slotInfo = this.identifiers.get(member);
            }
            if (slotInfo == null) {
                throw UnknownIdentifierException.create((String)member);
            }
            EspressoFrame.taint(this.frame);
            switch (slotInfo.getKind()) {
                case Boolean: {
                    EspressoFrame.setLocalInt(this.frame, slotInfo.getSlot(), interop.asBoolean(value) ? 1 : 0);
                    break;
                }
                case Byte: {
                    EspressoFrame.setLocalInt(this.frame, slotInfo.getSlot(), interop.asByte(value));
                    break;
                }
                case Short: {
                    EspressoFrame.setLocalInt(this.frame, slotInfo.getSlot(), interop.asShort(value));
                    break;
                }
                case Char: {
                    EspressoFrame.setLocalInt(this.frame, slotInfo.getSlot(), interop.asString(value).charAt(0));
                    break;
                }
                case Int: {
                    EspressoFrame.setLocalInt(this.frame, slotInfo.getSlot(), interop.asInt(value));
                    break;
                }
                case Float: {
                    EspressoFrame.setLocalFloat(this.frame, slotInfo.getSlot(), interop.asFloat(value));
                    break;
                }
                case Long: {
                    EspressoFrame.setLocalLong(this.frame, slotInfo.getSlot(), interop.asLong(value));
                    break;
                }
                case Double: {
                    EspressoFrame.setLocalDouble(this.frame, slotInfo.getSlot(), interop.asDouble(value));
                    break;
                }
                case Object: {
                    EspressoFrame.setLocalObject(this.frame, slotInfo.getSlot(), (StaticObject)value);
                    break;
                }
                default: {
                    CompilerAsserts.neverPartOfCompilation();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariableNamesObject
    implements TruffleObject {
        final List<String> names;

        VariableNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.names.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.names.get((int)index);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.names.size();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class NullValue
    implements TruffleObject {
        private static final NullValue INSTANCE = new NullValue();

        NullValue() {
        }

        @ExportMessage
        boolean isNull() {
            return true;
        }
    }
}

