/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.frame;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.analysis.frame.FrameAnalysis;
import com.oracle.truffle.espresso.analysis.frame.FrameType;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.verifier.StackMapFrameParser;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public class EspressoFrameDescriptor {
    private static final long INT_MASK = 0xFFFFFFFFL;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final FrameType[] slotTypes;
    private final int top;

    public EspressoFrameDescriptor(FrameType[] stackTypes, FrameType[] localsTypes, int top) {
        int stack = stackTypes.length;
        int locals = localsTypes.length;
        this.slotTypes = new FrameType[1 + locals + stack];
        this.slotTypes[0] = FrameType.INT;
        System.arraycopy(localsTypes, 0, this.slotTypes, 1, locals);
        System.arraycopy(stackTypes, 0, this.slotTypes, 1 + locals, stack);
        this.top = top;
    }

    private EspressoFrameDescriptor(FrameType[] slotTypes, int top) {
        this.slotTypes = (FrameType[])slotTypes.clone();
        this.top = top;
    }

    public static long zeroExtend(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int narrow(long value) {
        return (int)value;
    }

    @ExplodeLoop
    public void importFromFrame(VirtualFrame frame, StaticObject[] objects, long[] primitives) {
        assert (this.slotTypes.length == frame.getFrameDescriptor().getNumberOfSlots());
        assert (this.verifyConsistent((Frame)frame));
        assert (objects != null && primitives != null);
        assert (this.slotTypes.length == objects.length && this.slotTypes.length == primitives.length);
        Arrays.fill(objects, StaticObject.NULL);
        Arrays.fill(primitives, 0L);
        for (int slot = 0; slot < this.slotTypes.length; ++slot) {
            this.importSlot((Frame)frame, slot, objects, primitives);
        }
    }

    @ExplodeLoop
    public void exportToFrame(VirtualFrame frame, StaticObject[] objects, long[] primitives) {
        assert (this.slotTypes.length == frame.getFrameDescriptor().getNumberOfSlots());
        assert (objects != null && objects.length == this.slotTypes.length);
        assert (primitives != null && primitives.length == this.slotTypes.length);
        for (int slot = 0; slot < this.slotTypes.length; ++slot) {
            this.exportSlot((Frame)frame, slot, objects, primitives);
        }
    }

    public int size() {
        return this.slotTypes.length;
    }

    public int top() {
        return this.top;
    }

    private void importSlot(Frame frame, int slot, StaticObject[] objects, long[] primitives) {
        switch (this.slotTypes[slot].kind()) {
            case Int: {
                primitives[slot] = EspressoFrameDescriptor.zeroExtend(frame.getIntStatic(slot));
                break;
            }
            case Float: {
                primitives[slot] = EspressoFrameDescriptor.zeroExtend(Float.floatToRawIntBits(frame.getFloatStatic(slot)));
                break;
            }
            case Long: {
                primitives[slot] = frame.getLongStatic(slot);
                break;
            }
            case Double: {
                primitives[slot] = Double.doubleToRawLongBits(frame.getDoubleStatic(slot));
                break;
            }
            case Object: {
                objects[slot] = (StaticObject)frame.getObjectStatic(slot);
                break;
            }
            case Illegal: {
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
    }

    private void exportSlot(Frame frame, int slot, StaticObject[] objects, long[] primitives) {
        switch (this.slotTypes[slot].kind()) {
            case Int: {
                frame.setIntStatic(slot, EspressoFrameDescriptor.narrow(primitives[slot]));
                break;
            }
            case Float: {
                frame.setFloatStatic(slot, Float.intBitsToFloat(EspressoFrameDescriptor.narrow(primitives[slot])));
                break;
            }
            case Long: {
                frame.setLongStatic(slot, primitives[slot]);
                break;
            }
            case Double: {
                frame.setDoubleStatic(slot, Double.longBitsToDouble(primitives[slot]));
                break;
            }
            case Object: {
                frame.setObjectStatic(slot, (Object)objects[slot]);
                break;
            }
            case Illegal: {
                frame.clearStatic(slot);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
    }

    private boolean verifyConsistent(Frame frame) {
        for (int slot = 0; slot < this.slotTypes.length; ++slot) {
            assert (this.verifyConsistentSlot(frame, slot));
        }
        return true;
    }

    private boolean verifyConsistentSlot(Frame frame, int slot) {
        switch (this.slotTypes[slot].kind()) {
            case Int: {
                frame.getIntStatic(slot);
                break;
            }
            case Float: {
                frame.getFloatStatic(slot);
                break;
            }
            case Long: {
                frame.getLongStatic(slot);
                break;
            }
            case Double: {
                frame.getDoubleStatic(slot);
                break;
            }
            case Object: {
                frame.getObjectStatic(slot);
                break;
            }
            case Illegal: {
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
        return true;
    }

    public void validateImport(StaticObject[] pointers, long[] primitives, ObjectKlass accessingKlass, Meta meta) {
        EspressoFrameDescriptor.guarantee(pointers.length == this.slotTypes.length, EspressoError.cat("Invalid pointers array length: ", pointers.length), meta);
        EspressoFrameDescriptor.guarantee(primitives.length == this.slotTypes.length, EspressoError.cat("Invalid primitives array length: ", pointers.length), meta);
        for (int i = 0; i < this.slotTypes.length; ++i) {
            Klass targetKlass;
            FrameType ft = this.slotTypes[i];
            boolean checkNullObject = ft.isPrimitive();
            boolean checkZeroPrim = ft.isReference();
            if (checkNullObject) {
                EspressoFrameDescriptor.guarantee(StaticObject.isNull(pointers[i]), EspressoError.cat("Non-null object in pointers array at slot: ", i, ", but expected a ", ft.toString()), meta);
            }
            if (checkZeroPrim) {
                EspressoFrameDescriptor.guarantee(primitives[i] == 0L, EspressoError.cat("Non-zero primitive in primitives array at slot: ", i, ", but expected a ", ft.toString()), meta);
            }
            if (!ft.isReference() || StaticObject.isNull(pointers[i])) continue;
            Klass objKlass = pointers[i].getKlass();
            if (ft.type() == accessingKlass.getType()) {
                targetKlass = accessingKlass;
            } else {
                if (ft.type() == objKlass.getType() && accessingKlass.getDefiningClassLoader() == objKlass.getDefiningClassLoader()) continue;
                targetKlass = meta.resolveSymbolOrFail(ft.type(), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
            }
            if (targetKlass.isInterface()) continue;
            EspressoFrameDescriptor.guarantee(targetKlass.isAssignableFrom(objKlass), EspressoError.cat("Failed guarantee: Attempting to resume a continuation with invalid object class.\n", "Expected: ", targetKlass.getExternalName(), "\n", "But got: ", objKlass.getExternalName()), meta);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EspressoFrameDescriptor) {
            EspressoFrameDescriptor that = (EspressoFrameDescriptor)obj;
            if (this.top() == that.top() && this.size() == that.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.slotTypes[i].equals(that.slotTypes[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.top(), Arrays.hashCode(this.slotTypes));
    }

    public static void guarantee(boolean condition, String message, Meta meta) {
        if (!condition) {
            throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalMaterializedRecordException, message);
        }
    }

    public static FrameType fromTypeInfo(VerificationTypeInfo vfi, FrameAnalysis analysis) {
        FrameType k = vfi.isIllegal() ? FrameType.ILLEGAL : (vfi.isNull() ? FrameType.NULL : FrameType.forType(vfi.getType(analysis.pool(), analysis.targetKlass(), analysis.stream())));
        return k;
    }

    public static class Builder
    implements StackMapFrameParser.FrameState {
        int bci = -1;
        final FrameType[] types;
        final int maxLocals;
        int top = 0;

        public Builder(int maxLocals, int maxStack) {
            this.types = new FrameType[1 + maxLocals + maxStack];
            Arrays.fill(this.types, FrameType.ILLEGAL);
            this.types[0] = FrameType.INT;
            this.maxLocals = maxLocals;
        }

        private Builder(FrameType[] types, int maxLocals, int top) {
            this.types = types;
            this.maxLocals = maxLocals;
            this.top = top;
        }

        public void push(FrameType ft) {
            this.push(ft, true);
        }

        public void push(FrameType ft, boolean handle2Slots) {
            JavaKind k = ft.kind();
            assert (k != JavaKind.Illegal || !handle2Slots);
            if (k == JavaKind.Void) {
                return;
            }
            JavaKind stackKind = k.getStackKind();
            if (handle2Slots && stackKind.needsTwoSlots()) {
                this.types[this.stackIdx((int)this.top)] = FrameType.ILLEGAL;
                ++this.top;
            }
            this.types[this.stackIdx((int)this.top)] = ft;
            ++this.top;
        }

        public FrameType pop(FrameType k) {
            return this.pop(k.kind());
        }

        public FrameType pop(JavaKind k) {
            FrameType popped = this.pop();
            assert (popped.kind() == k);
            if (k.needsTwoSlots()) {
                FrameType dummy = this.pop();
                assert (dummy == FrameType.ILLEGAL);
            }
            return popped;
        }

        public FrameType pop() {
            int head = this.stackIdx(this.top - 1);
            FrameType k = this.types[head];
            this.types[head] = FrameType.ILLEGAL;
            --this.top;
            return k;
        }

        public void pop2() {
            this.pop();
            this.pop();
        }

        public void setBci(int bci) {
            this.bci = bci;
        }

        public void putLocal(int slot, FrameType k) {
            int idx = Builder.localIdx(slot);
            this.types[idx] = k;
            if (k.kind().needsTwoSlots()) {
                this.types[idx + 1] = FrameType.ILLEGAL;
            }
        }

        public void clear(int slot) {
            this.putLocal(slot, FrameType.ILLEGAL);
        }

        public FrameType getLocal(int slot) {
            return this.types[Builder.localIdx(slot)];
        }

        public boolean isWorking() {
            return this.bci < 0;
        }

        public boolean isRecord() {
            return this.bci >= 0;
        }

        public Builder copy() {
            return new Builder((FrameType[])this.types.clone(), this.maxLocals, this.top);
        }

        public EspressoFrameDescriptor build() {
            return new EspressoFrameDescriptor(this.types, this.top);
        }

        public int top() {
            return this.top;
        }

        public EspressoFrameDescriptor build(int topOverride) {
            return new EspressoFrameDescriptor(this.types, topOverride);
        }

        public Builder clearStack() {
            Arrays.fill(this.types, this.stackIdx(0), this.stackIdx(this.top), FrameType.ILLEGAL);
            this.top = 0;
            return this;
        }

        public boolean sameTop(Builder that) {
            return this.types.length == that.types.length && this.top == that.top;
        }

        public Builder mergeInto(Builder that, int mergeBci, boolean trustThat, Function<Symbol<Symbol.Type>, Klass> klassResolver) {
            assert (mergeBci == that.bci);
            assert (this.sameTop(that));
            Builder merged = null;
            for (int i = 0; i < this.types.length; ++i) {
                FrameType thisFT = this.types[i];
                FrameType thatFT = that.types[i];
                if (thatFT == FrameType.ILLEGAL) continue;
                if (thisFT == FrameType.ILLEGAL) {
                    that.types[i] = FrameType.ILLEGAL;
                    continue;
                }
                if (thisFT.isPrimitive() || thatFT.isPrimitive()) {
                    if (thisFT == thatFT) continue;
                    merged = Builder.updateMerged(merged, i, FrameType.ILLEGAL, that);
                    continue;
                }
                if (trustThat || thisFT.isNull() || thisFT.type() == thatFT.type()) continue;
                Klass thisKlass = klassResolver.apply(thisFT.type());
                Klass thatKlass = klassResolver.apply(thatFT.type());
                Klass lca = thisKlass.findLeastCommonAncestor(thatKlass);
                assert (lca != null);
                if (lca.getType() == thatFT.type()) continue;
                FrameType ft = FrameType.forType(lca.getType());
                merged = Builder.updateMerged(merged, i, ft, that);
            }
            return merged == null ? that : merged;
        }

        private static Builder updateMerged(Builder merged, int idx, FrameType ft, Builder that) {
            Builder result = merged;
            if (result == null) {
                result = that.copy();
            }
            result.types[idx] = ft;
            return result;
        }

        private int stackIdx(int slot) {
            assert (slot >= 0);
            return 1 + this.maxLocals + slot;
        }

        private static int localIdx(int slot) {
            return 1 + slot;
        }

        @Override
        public Builder sameNoStack() {
            return this.copy().clearStack();
        }

        @Override
        public Builder sameLocalsWith1Stack(VerificationTypeInfo vfi, StackMapFrameParser.FrameBuilder<?> builder) {
            if (builder instanceof FrameAnalysis) {
                FrameAnalysis analysis = (FrameAnalysis)builder;
                Builder newFrame = this.copy().clearStack();
                newFrame.clearStack();
                FrameType k = EspressoFrameDescriptor.fromTypeInfo(vfi, analysis);
                newFrame.push(k);
                return newFrame;
            }
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public StackMapFrameParser.FrameAndLocalEffect chop(int chop, int lastLocal) {
            Builder newFrame = this.copy().clearStack();
            int pos = lastLocal;
            for (int i = 0; i < chop; ++i) {
                newFrame.clear(pos);
                if (--pos < 0 || !newFrame.getLocal(pos).kind().needsTwoSlots()) continue;
                newFrame.clear(pos);
                --pos;
            }
            return new StackMapFrameParser.FrameAndLocalEffect(newFrame, pos - lastLocal);
        }

        @Override
        public StackMapFrameParser.FrameAndLocalEffect append(VerificationTypeInfo[] vtis, StackMapFrameParser.FrameBuilder<?> builder, int lastLocal) {
            if (builder instanceof FrameAnalysis) {
                FrameAnalysis analysis = (FrameAnalysis)builder;
                Builder newFrame = this.copy().clearStack();
                int pos = lastLocal;
                for (VerificationTypeInfo vti : vtis) {
                    FrameType k = EspressoFrameDescriptor.fromTypeInfo(vti, analysis);
                    newFrame.putLocal(++pos, k);
                    if (!k.kind().needsTwoSlots()) continue;
                    ++pos;
                }
                return new StackMapFrameParser.FrameAndLocalEffect(newFrame, pos - lastLocal);
            }
            throw EspressoError.shouldNotReachHere();
        }
    }
}

