/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.frame;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.analysis.frame.FrameType;
import com.oracle.truffle.espresso.analysis.liveness.LivenessAnalysis;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.BytecodeSwitch;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.verifier.StackMapFrameParser;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.function.Function;

public final class FrameAnalysis
implements StackMapFrameParser.FrameBuilder<EspressoFrameDescriptor.Builder> {
    private final EspressoLanguage lang;
    private final Method.MethodVersion m;
    private final Function<Symbol<Symbol.Type>, Klass> klassResolver;
    private final LivenessAnalysis la;
    private final BytecodeStream bs;
    private final RuntimeConstantPool pool;
    private final int targetBci;
    private final EspressoFrameDescriptor.Builder[] states;
    private final BitSet branchTargets;
    private final BitSet processStatus;
    private final ArrayDeque<Integer> queue = new ArrayDeque(2);
    boolean withStackMaps;

    @CompilerDirectives.TruffleBoundary
    public static EspressoFrameDescriptor apply(Method.MethodVersion m, int bci) {
        try {
            return new FrameAnalysis(bci, m).apply();
        }
        catch (Exception e) {
            throw EspressoError.shouldNotReachHere(String.format("Failed suspension during frame analysis of method '%s'", m), e);
        }
    }

    public ConstantPool pool() {
        return this.pool;
    }

    public ObjectKlass targetKlass() {
        return this.m.getDeclaringKlass();
    }

    public BytecodeStream stream() {
        return this.bs;
    }

    private FrameAnalysis(int targetBci, Method.MethodVersion m) {
        this.lang = m.getMethod().getLanguage();
        this.la = m.getLivenessAnalysis();
        this.bs = new BytecodeStream(m.getOriginalCode());
        this.targetBci = targetBci;
        this.states = new EspressoFrameDescriptor.Builder[this.bs.endBCI()];
        this.pool = m.getPool();
        this.m = m;
        this.branchTargets = new BitSet(this.bs.endBCI());
        this.processStatus = new BitSet(this.bs.endBCI());
        ObjectKlass declaringKlass = m.getDeclaringKlass();
        this.klassResolver = type -> declaringKlass.getMeta().resolveSymbolOrFail((Symbol<Symbol.Type>)type, declaringKlass.getDefiningClassLoader(), declaringKlass.protectionDomain());
    }

    private static void popSignature(Symbol<Symbol.Type>[] sig, boolean isStatic, EspressoFrameDescriptor.Builder frame) {
        for (Symbol<Symbol.Type> t : Signatures.iterable(sig, true, false)) {
            JavaKind k = Types.getJavaKind(t).getStackKind();
            frame.pop(k);
        }
        if (!isStatic) {
            frame.pop(JavaKind.Object);
        }
    }

    private EspressoFrameDescriptor apply() {
        this.markBranchTargets();
        this.buildInitialFrames();
        int startBci = 0;
        this.push(startBci);
        while (!this.queue.isEmpty()) {
            startBci = this.pop();
            this.buildStates(startBci);
        }
        EspressoFrameDescriptor.Builder state = this.states[this.targetBci];
        int opcode = this.bs.opcode(this.targetBci);
        assert (Bytecodes.isInvoke(opcode));
        int top = state.top();
        this.handleInvoke(state, this.targetBci, opcode, false, opcode == 186 ? ConstantPool.Tag.INVOKEDYNAMIC : ConstantPool.Tag.METHOD_REF);
        return state.build(EspressoFrame.startingStackOffset(this.m.getMaxLocals()) + top);
    }

    private void markBranchTargets() {
        ExceptionHandler[] handlers;
        int bci = 0;
        boolean validTarget = false;
        while (bci < this.bs.endBCI()) {
            int opcode = this.bs.opcode(bci);
            if (Bytecodes.isBranch(opcode)) {
                this.branchTargets.set(this.bs.readBranchDest(bci));
            } else if (opcode == 170 || opcode == 171) {
                BytecodeSwitch helper = BytecodeSwitch.get(opcode);
                for (int i = 0; i < helper.numberOfCases(this.bs, bci); ++i) {
                    this.branchTargets.set(helper.targetAt(this.bs, bci, i));
                }
                this.branchTargets.set(helper.defaultTarget(this.bs, bci));
            }
            if (bci == this.targetBci && Bytecodes.isInvoke(opcode)) {
                validTarget = true;
            }
            bci = this.bs.nextBCI(bci);
        }
        EspressoFrameDescriptor.guarantee(validTarget, "Target bci is not a valid bytecode.", this.m.getDeclaringKlass().getMeta());
        for (ExceptionHandler handler : handlers = this.m.getExceptionHandlers()) {
            this.branchTargets.set(handler.getHandlerBCI());
        }
    }

    private void buildInitialFrames() {
        EspressoFrameDescriptor.Builder frame = new EspressoFrameDescriptor.Builder(this.m.getMaxLocals(), this.m.getMaxStackSize());
        Symbol<Symbol.Type>[] sig = this.m.getMethod().getParsedSignature();
        int receiverShift = 0;
        if (!this.m.isStatic()) {
            frame.putLocal(0, FrameType.forType(this.m.getDeclaringKlass().getType()));
            receiverShift = 1;
        }
        int localPos = 0;
        for (int sigPos = 0; sigPos < Signatures.parameterCount(sig); ++sigPos) {
            Symbol<Symbol.Type> type = Signatures.parameterType(sig, sigPos);
            FrameType ft = FrameType.forType(type);
            frame.putLocal(receiverShift + localPos, ft);
            if (ft.kind().needsTwoSlots()) {
                frame.putLocal(receiverShift + ++localPos, FrameType.ILLEGAL);
            }
            ++localPos;
        }
        this.la.onStart(frame);
        frame.setBci(0);
        assert (frame.isRecord());
        this.states[0] = frame;
        StackMapTableAttribute stackMapFrame = this.m.getCodeAttribute().getStackMapFrame();
        if (this.m.getCodeAttribute().getMajorVersion() == 50 || stackMapFrame == null || stackMapFrame == StackMapTableAttribute.EMPTY) {
            return;
        }
        this.withStackMaps = true;
        int lastLocal = receiverShift + localPos - 1;
        StackMapFrameParser.parse(this, stackMapFrame, frame, lastLocal);
    }

    private void buildStates(int startBci) {
        EspressoFrameDescriptor.Builder frame = this.states[startBci].copy();
        int bci = startBci;
        while (bci < this.bs.endBCI()) {
            if (this.branchTargets.get(bci)) {
                EspressoFrameDescriptor.Builder registered = this.states[bci];
                assert (registered == null || frame.sameTop(registered));
                if (this.merge(bci, frame) && this.processStatus.get(bci)) {
                    return;
                }
                this.processStatus.set(bci);
                EspressoFrameDescriptor.Builder builder = frame = registered == null ? frame : this.states[bci].copy();
            }
            if (bci == this.targetBci) {
                this.registerState(bci, frame);
                if (!this.la.isEmpty()) {
                    this.queue.clear();
                    return;
                }
            }
            assert (frame.isWorking());
            int opcode = this.bs.currentBC(bci);
            switch (opcode) {
                case 0: 
                case 132: {
                    break;
                }
                case 192: {
                    frame.pop();
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.CLASS);
                    frame.push(FrameType.forType(type));
                    break;
                }
                case 1: {
                    frame.push(FrameType.NULL);
                    break;
                }
                case 25: {
                    FrameType ft = frame.getLocal(this.bs.readLocalIndex(bci));
                    frame.push(ft);
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    FrameType ft = frame.getLocal(opcode - 42);
                    frame.push(ft);
                    break;
                }
                case 187: {
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.CLASS);
                    frame.push(FrameType.forType(type));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    frame.push(FrameType.INT);
                    break;
                }
                case 9: 
                case 10: 
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    frame.push(FrameType.LONG);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    frame.push(FrameType.FLOAT);
                    break;
                }
                case 14: 
                case 15: 
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    frame.push(FrameType.DOUBLE);
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    this.ldc(bci, frame);
                    break;
                }
                case 46: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: 
                case 149: 
                case 150: {
                    frame.pop();
                    frame.pop();
                    frame.push(FrameType.INT);
                    break;
                }
                case 47: {
                    frame.pop();
                    frame.pop();
                    frame.push(FrameType.LONG);
                    break;
                }
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: {
                    frame.pop();
                    frame.pop();
                    frame.push(FrameType.FLOAT);
                    break;
                }
                case 49: {
                    frame.pop();
                    frame.pop();
                    frame.push(FrameType.DOUBLE);
                    break;
                }
                case 50: {
                    frame.pop();
                    FrameType array = frame.pop();
                    FrameType ft = FrameType.forType(this.lang.getTypes().getComponentType(array.type()));
                    frame.push(ft);
                    break;
                }
                case 54: {
                    frame.pop();
                    frame.putLocal(this.bs.readLocalIndex(bci), FrameType.INT);
                    break;
                }
                case 55: {
                    frame.pop2();
                    frame.putLocal(this.bs.readLocalIndex(bci), FrameType.LONG);
                    break;
                }
                case 56: {
                    frame.pop();
                    frame.putLocal(this.bs.readLocalIndex(bci), FrameType.FLOAT);
                    break;
                }
                case 57: {
                    frame.pop2();
                    frame.putLocal(this.bs.readLocalIndex(bci), FrameType.DOUBLE);
                    break;
                }
                case 58: {
                    FrameType ft = frame.pop();
                    frame.putLocal(this.bs.readLocalIndex(bci), ft);
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    frame.pop();
                    frame.putLocal(opcode - 59, FrameType.INT);
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    frame.pop2();
                    frame.putLocal(opcode - 63, FrameType.LONG);
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    frame.pop();
                    frame.putLocal(opcode - 67, FrameType.FLOAT);
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    frame.pop2();
                    frame.putLocal(opcode - 71, FrameType.DOUBLE);
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    FrameType ft = frame.pop();
                    frame.putLocal(opcode - 75, ft);
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    frame.pop();
                    frame.pop();
                    frame.pop();
                    break;
                }
                case 80: 
                case 82: {
                    frame.pop2();
                    frame.pop();
                    frame.pop();
                    break;
                }
                case 87: 
                case 194: 
                case 195: {
                    frame.pop();
                    break;
                }
                case 88: {
                    frame.pop();
                    frame.pop();
                    break;
                }
                case 89: {
                    FrameType k = frame.pop();
                    frame.push(k, false);
                    frame.push(k, false);
                    break;
                }
                case 90: {
                    FrameType v1 = frame.pop();
                    FrameType v2 = frame.pop();
                    frame.push(v1, false);
                    frame.push(v2, false);
                    frame.push(v1, false);
                    break;
                }
                case 91: {
                    FrameType v1 = frame.pop();
                    FrameType v2 = frame.pop();
                    FrameType v3 = frame.pop();
                    frame.push(v1, false);
                    frame.push(v3, false);
                    frame.push(v2, false);
                    frame.push(v1, false);
                    break;
                }
                case 92: {
                    FrameType v1 = frame.pop();
                    FrameType v2 = frame.pop();
                    frame.push(v2, false);
                    frame.push(v1, false);
                    frame.push(v2, false);
                    frame.push(v1, false);
                    break;
                }
                case 93: {
                    FrameType v1 = frame.pop();
                    FrameType v2 = frame.pop();
                    FrameType v3 = frame.pop();
                    frame.push(v2, false);
                    frame.push(v1, false);
                    frame.push(v3, false);
                    frame.push(v2, false);
                    frame.push(v1, false);
                    break;
                }
                case 94: {
                    FrameType v1 = frame.pop();
                    FrameType v2 = frame.pop();
                    FrameType v3 = frame.pop();
                    FrameType v4 = frame.pop();
                    frame.push(v2, false);
                    frame.push(v1, false);
                    frame.push(v4, false);
                    frame.push(v3, false);
                    frame.push(v2, false);
                    frame.push(v1, false);
                    break;
                }
                case 95: {
                    FrameType k1 = frame.pop();
                    FrameType k2 = frame.pop();
                    frame.push(k1, false);
                    frame.push(k2, false);
                    break;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 127: 
                case 129: 
                case 131: {
                    frame.pop2();
                    frame.pop2();
                    frame.push(FrameType.LONG);
                    break;
                }
                case 121: 
                case 123: 
                case 125: {
                    frame.pop();
                    frame.pop2();
                    frame.push(FrameType.LONG);
                    break;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    frame.pop2();
                    frame.pop2();
                    frame.push(FrameType.DOUBLE);
                    break;
                }
                case 116: 
                case 139: 
                case 145: 
                case 146: 
                case 147: 
                case 190: 
                case 193: {
                    frame.pop();
                    frame.push(FrameType.INT);
                    break;
                }
                case 117: 
                case 143: {
                    frame.pop2();
                    frame.push(FrameType.LONG);
                    break;
                }
                case 118: 
                case 134: {
                    frame.pop();
                    frame.push(FrameType.FLOAT);
                    break;
                }
                case 119: 
                case 138: {
                    frame.pop2();
                    frame.push(FrameType.DOUBLE);
                    break;
                }
                case 133: 
                case 140: {
                    frame.pop();
                    frame.push(FrameType.LONG);
                    break;
                }
                case 135: 
                case 141: {
                    frame.pop();
                    frame.push(FrameType.DOUBLE);
                    break;
                }
                case 136: 
                case 142: {
                    frame.pop2();
                    frame.push(FrameType.INT);
                    break;
                }
                case 137: 
                case 144: {
                    frame.pop2();
                    frame.push(FrameType.FLOAT);
                    break;
                }
                case 148: 
                case 151: 
                case 152: {
                    frame.pop2();
                    frame.pop2();
                    frame.push(FrameType.INT);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    frame.pop();
                    this.branch(bci, this.bs.readBranchDest(bci), frame);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    frame.pop();
                    frame.pop();
                    this.branch(bci, this.bs.readBranchDest(bci), frame);
                    break;
                }
                case 167: 
                case 200: {
                    this.branch(bci, this.bs.readBranchDest(bci), frame);
                    return;
                }
                case 168: 
                case 169: 
                case 201: {
                    throw EspressoError.shouldNotReachHere("Should have prevented jsr/ret");
                }
                case 170: 
                case 171: {
                    frame.pop();
                    BytecodeSwitch bytecodeSwitch = BytecodeSwitch.get(opcode);
                    for (int i = 0; i < bytecodeSwitch.numberOfCases(this.bs, bci); ++i) {
                        this.branch(bci, bytecodeSwitch.targetAt(this.bs, bci, i), frame);
                    }
                    this.branch(bci, bytecodeSwitch.defaultTarget(this.bs, bci), frame);
                    return;
                }
                case 172: 
                case 174: 
                case 176: 
                case 191: {
                    frame.pop();
                    return;
                }
                case 173: 
                case 175: {
                    frame.pop2();
                    return;
                }
                case 177: {
                    return;
                }
                case 178: 
                case 180: {
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.FIELD_REF);
                    if (opcode == 180) {
                        frame.pop();
                    }
                    frame.push(FrameType.forType(type));
                    break;
                }
                case 179: 
                case 181: {
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.FIELD_REF);
                    if (Types.getJavaKind(type).needsTwoSlots()) {
                        frame.pop2();
                    } else {
                        frame.pop();
                    }
                    if (opcode != 181) break;
                    frame.pop();
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    this.handleInvoke(frame, bci, opcode, true, ConstantPool.Tag.METHOD_REF);
                    break;
                }
                case 188: {
                    frame.pop();
                    frame.push(FrameAnalysis.newPrimitiveArray(this.bs.readByte(bci)));
                    break;
                }
                case 189: {
                    frame.pop();
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.CLASS);
                    frame.push(FrameType.forType(this.lang.getTypes().arrayOf(type)));
                    break;
                }
                case 197: {
                    int dim = this.bs.readUByte(bci + 3);
                    for (int i = 0; i < dim; ++i) {
                        frame.pop();
                    }
                    Symbol<Symbol.Type> type = this.queryPoolType(this.bs.readCPI(bci), ConstantPool.Tag.CLASS);
                    frame.push(FrameType.forType(type));
                    break;
                }
                case 186: {
                    this.handleInvoke(frame, bci, opcode, true, ConstantPool.Tag.INVOKEDYNAMIC);
                    break;
                }
                default: {
                    throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(opcode));
                }
            }
            this.la.performPostBCI(frame, bci);
            if (Bytecodes.canTrap(opcode)) {
                ExceptionHandler[] handlers;
                for (ExceptionHandler handler : handlers = this.m.getExceptionHandlers()) {
                    if (!handler.covers(bci)) continue;
                    EspressoFrameDescriptor.Builder copy = frame.copy();
                    copy.clearStack();
                    Symbol<Symbol.Type> catchType = handler.getCatchType();
                    copy.push(catchType == null ? FrameType.THROWABLE : FrameType.forType(handler.getCatchType()));
                    this.branch(bci, handler.getHandlerBCI(), copy);
                }
            }
            int next = this.bs.nextBCI(bci);
            this.la.performOnEdge(frame, bci, next);
            bci = next;
        }
    }

    private static FrameType newPrimitiveArray(byte b) {
        switch (b) {
            case 4: {
                return FrameType.forType(Symbol.Type._boolean_array);
            }
            case 5: {
                return FrameType.forType(Symbol.Type._char_array);
            }
            case 6: {
                return FrameType.forType(Symbol.Type._float_array);
            }
            case 7: {
                return FrameType.forType(Symbol.Type._double_array);
            }
            case 8: {
                return FrameType.forType(Symbol.Type._byte_array);
            }
            case 9: {
                return FrameType.forType(Symbol.Type._short_array);
            }
            case 10: {
                return FrameType.forType(Symbol.Type._int_array);
            }
            case 11: {
                return FrameType.forType(Symbol.Type._long_array);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    private void handleInvoke(EspressoFrameDescriptor.Builder frame, int bci, int opcode, boolean pushResult, ConstantPool.Tag tag) {
        Symbol<Symbol.Type>[] sig = this.queryPoolSignature(this.bs.readCPI(bci), tag);
        FrameAnalysis.popSignature(sig, opcode == 184 || opcode == 186, frame);
        if (pushResult && Signatures.returnKind(sig) != JavaKind.Void) {
            frame.push(FrameType.forType(Signatures.returnType(sig)));
        }
    }

    private boolean merge(int bci, EspressoFrameDescriptor.Builder frame) {
        EspressoFrameDescriptor.Builder targetState = this.states[bci];
        if (targetState == null) {
            this.registerState(bci, frame.copy());
            return false;
        }
        EspressoFrameDescriptor.Builder merged = frame.mergeInto(targetState, bci, this.withStackMaps, this.klassResolver);
        if (merged == targetState) {
            return true;
        }
        assert (this.la.isEmpty());
        this.registerState(bci, merged);
        return false;
    }

    private void ldc(int bci, EspressoFrameDescriptor.Builder frame) {
        char cpi = this.bs.readCPI(bci);
        ConstantPool.Tag tag = this.pool.tagAt(cpi);
        switch (tag) {
            case INTEGER: {
                frame.push(FrameType.INT);
                break;
            }
            case FLOAT: {
                frame.push(FrameType.FLOAT);
                break;
            }
            case LONG: {
                frame.push(FrameType.LONG);
                break;
            }
            case DOUBLE: {
                frame.push(FrameType.DOUBLE);
                break;
            }
            case CLASS: {
                frame.push(FrameType.forType(Symbol.Type.java_lang_Class));
                break;
            }
            case STRING: {
                frame.push(FrameType.forType(Symbol.Type.java_lang_String));
                break;
            }
            case METHODHANDLE: {
                frame.push(FrameType.forType(Symbol.Type.java_lang_invoke_MethodHandle));
                break;
            }
            case METHODTYPE: {
                frame.push(FrameType.forType(Symbol.Type.java_lang_invoke_MethodType));
                break;
            }
            case DYNAMIC: {
                Symbol<Symbol.Type> t = ((DynamicConstant)this.pool.at(cpi)).getTypeSymbol(this.pool);
                frame.push(FrameType.forType(t));
                break;
            }
            default: {
                throw EspressoError.shouldNotReachHere(tag.toString());
            }
        }
    }

    private void branch(int from, int target, EspressoFrameDescriptor.Builder f) {
        assert (f.isWorking());
        EspressoFrameDescriptor.Builder targetState = this.states[target];
        if (targetState == null) {
            EspressoFrameDescriptor.Builder newState = f.copy();
            this.la.performOnEdge(newState, from, target);
            this.registerState(target, newState);
            this.push(target);
            return;
        }
        assert (targetState.isRecord());
        EspressoFrameDescriptor.Builder merged = f.mergeInto(targetState, target, this.withStackMaps, this.klassResolver);
        if (merged == targetState) {
            if (!this.processStatus.get(target)) {
                this.push(target);
            }
            return;
        }
        assert (this.la.isEmpty());
        this.registerState(target, merged);
        this.processStatus.clear(target);
        this.push(target);
    }

    private void registerState(int target, EspressoFrameDescriptor.Builder newState) {
        assert (newState.isWorking());
        assert (this.states[target] == null || newState.sameTop(this.states[target]));
        EspressoFrameDescriptor.Builder copy = newState.copy();
        copy.setBci(target);
        assert (copy.isRecord());
        this.states[target] = copy;
    }

    private void push(int bci) {
        assert (this.states[bci] != null);
        assert (this.states[bci].isRecord());
        this.queue.push(bci);
    }

    private int pop() {
        int next = this.queue.pop();
        assert (this.states[next] != null && this.states[next].isRecord());
        return next;
    }

    @Override
    public void registerStackMapFrame(int bci, EspressoFrameDescriptor.Builder frame) {
        this.registerState(bci, frame);
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect newFullFrame(VerificationTypeInfo[] stack, VerificationTypeInfo[] locals, int lastLocal) {
        EspressoFrameDescriptor.Builder fullFrame = new EspressoFrameDescriptor.Builder(this.m.getMaxLocals(), this.m.getMaxStackSize());
        for (VerificationTypeInfo vti : stack) {
            FrameType k = EspressoFrameDescriptor.fromTypeInfo(vti, this);
            fullFrame.push(k);
        }
        int pos = 0;
        for (VerificationTypeInfo vti : locals) {
            FrameType k = EspressoFrameDescriptor.fromTypeInfo(vti, this);
            fullFrame.putLocal(pos, k);
            if (k.kind().needsTwoSlots()) {
                fullFrame.clear(++pos);
            }
            ++pos;
        }
        return new StackMapFrameParser.FrameAndLocalEffect(fullFrame, pos - 1 - lastLocal);
    }

    @Override
    public String toExternalString() {
        return this.m.getDeclaringKlass().getExternalName() + "." + this.m.getMethod().getNameAsString();
    }

    private Symbol<Symbol.Type> queryPoolType(int cpi, ConstantPool.Tag tag) {
        switch (tag) {
            case CLASS: {
                if (this.pool.isResolutionSuccessAt(cpi)) {
                    return this.pool.resolvedKlassAt(this.m.getDeclaringKlass(), cpi).getType();
                }
                return this.lang.getTypes().fromName(this.pool.classAt(cpi).getName(this.pool));
            }
            case FIELD_REF: {
                if (this.pool.isResolutionSuccessAt(cpi)) {
                    return this.pool.resolvedFieldAt(this.m.getDeclaringKlass(), cpi).getType();
                }
                return this.pool.fieldAt(cpi).getType(this.pool);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    private Symbol<Symbol.Type>[] queryPoolSignature(int cpi, ConstantPool.Tag tag) {
        switch (tag) {
            case METHOD_REF: {
                if (this.pool.isResolutionSuccessAt(cpi)) {
                    return this.pool.resolvedMethodAt(this.m.getDeclaringKlass(), cpi).getParsedSignature();
                }
                return this.lang.getSignatures().parsed(this.pool.methodAt(cpi).getSignature(this.pool));
            }
            case INVOKEDYNAMIC: {
                if (this.pool.isResolutionSuccessAt(cpi)) {
                    return this.pool.peekResolvedInvokeDynamic(cpi).getParsedSignature();
                }
                return this.lang.getSignatures().parsed(this.pool.indyAt(cpi).getSignature(this.pool));
            }
        }
        throw EspressoError.shouldNotReachHere();
    }
}

