/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.frame;

import com.oracle.truffle.espresso.analysis.frame.IllegalFrameType;
import com.oracle.truffle.espresso.analysis.frame.NullFrameType;
import com.oracle.truffle.espresso.analysis.frame.PrimitiveFrameType;
import com.oracle.truffle.espresso.analysis.frame.TypedFrameType;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;

public abstract class FrameType {
    public static final FrameType INT = new PrimitiveFrameType(JavaKind.Int);
    public static final FrameType FLOAT = new PrimitiveFrameType(JavaKind.Float);
    public static final FrameType LONG = new PrimitiveFrameType(JavaKind.Long);
    public static final FrameType DOUBLE = new PrimitiveFrameType(JavaKind.Double);
    public static final FrameType ILLEGAL = new IllegalFrameType();
    public static final FrameType NULL = new NullFrameType();
    public static final FrameType THROWABLE = new TypedFrameType(Symbol.Type.java_lang_Throwable);
    private final JavaKind kind;

    protected FrameType(JavaKind kind) {
        this.kind = kind;
    }

    public final JavaKind kind() {
        return this.kind;
    }

    public abstract Symbol<Symbol.Type> type();

    public boolean isNull() {
        return false;
    }

    public abstract boolean isPrimitive();

    public abstract boolean isReference();

    public static FrameType forType(Symbol<Symbol.Type> type) {
        assert (type != null);
        if (Types.isPrimitive(type)) {
            return FrameType.forPrimitive(Types.getJavaKind(type).getStackKind());
        }
        return FrameType.forRefType(type);
    }

    public static FrameType forPrimitive(JavaKind javaKind) {
        switch (javaKind) {
            case Int: {
                return INT;
            }
            case Float: {
                return FLOAT;
            }
            case Long: {
                return LONG;
            }
            case Double: {
                return DOUBLE;
            }
        }
        throw EspressoError.shouldNotReachHere(javaKind.getJavaName());
    }

    private static FrameType forRefType(Symbol<Symbol.Type> type) {
        return new TypedFrameType(type);
    }

    public int hashCode() {
        return this.kind().ordinal();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.kind().toString();
        }
        return this.type().toString();
    }
}

