/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.blocking;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.blocking.GuestInterrupter;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class BlockingSupport<T> {
    public static final BlockingSupport<Object> UNINTERRUPTIBLE = BlockingSupport.create(GuestInterrupter.EMPTY);
    private final GuestInterrupter<T> guestInterrupter;

    private BlockingSupport(GuestInterrupter<T> guestInterrupter) {
        this.guestInterrupter = guestInterrupter;
    }

    public static <T> BlockingSupport<T> create(GuestInterrupter<T> guestInterrupter) {
        return new BlockingSupport<T>(guestInterrupter);
    }

    @CompilerDirectives.TruffleBoundary
    public <U> void enterBlockingRegion(TruffleSafepoint.Interruptible<U> blockingRegion, Node location, U object) throws GuestInterruptedException {
        if (this.guestInterrupter.isGuestInterrupted(Thread.currentThread(), this.guestInterrupter.getCurrentGuestThread())) {
            throw new GuestInterruptedException();
        }
        TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
        safepoint.setBlocked(location, this.guestInterrupter, blockingRegion, object, null, this.guestInterrupter::afterInterrupt);
    }

    @CompilerDirectives.TruffleBoundary
    public <U> void enterBlockingRegion(TruffleSafepoint.Interruptible<U> blockingRegion, Node location, U object, Runnable beforeSafepoint, Consumer<Throwable> afterSafepoint) throws GuestInterruptedException {
        if (this.guestInterrupter.isGuestInterrupted(Thread.currentThread(), this.guestInterrupter.getCurrentGuestThread())) {
            throw new GuestInterruptedException();
        }
        TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
        safepoint.setBlocked(location, this.guestInterrupter, blockingRegion, object, beforeSafepoint, ex -> {
            if (afterSafepoint != null) {
                afterSafepoint.accept((Throwable)ex);
            }
            this.guestInterrupter.afterInterrupt((Throwable)ex);
        });
    }

    public void sleep(long nanos, Node location) throws GuestInterruptedException {
        this.enterBlockingRegion(BlockingSupport.sleepInterruptible(), location, nanos);
    }

    public void guestInterrupt(Thread t, T guest) {
        this.guestInterrupter.guestInterrupt(t, guest);
        if (t != null) {
            t.interrupt();
        }
    }

    private static TruffleSafepoint.Interruptible<Long> sleepInterruptible() {
        return new SleepInterruptible();
    }

    private static final class SleepInterruptible
    implements TruffleSafepoint.Interruptible<Long> {
        private final long start = System.nanoTime();

        private SleepInterruptible() {
        }

        public void apply(Long time) throws InterruptedException {
            long left = time - (System.nanoTime() - this.start);
            if (left <= 0L) {
                return;
            }
            long millis = TimeUnit.NANOSECONDS.toMillis(left);
            long nanos = left - TimeUnit.MILLISECONDS.toNanos(millis);
            assert (nanos >= 0L && nanos < 1000000L);
            Thread.sleep(millis, (int)nanos);
        }
    }
}

