/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.blocking;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;

public interface GuestInterrupter<T>
extends TruffleSafepoint.Interrupter {
    public static final GuestInterrupter<Object> EMPTY = new GuestInterrupter<Object>(){

        @Override
        public void guestInterrupt(Thread t, Object guestThread) {
        }

        @Override
        public boolean isGuestInterrupted(Thread t, Object guestThread) {
            return false;
        }
    };

    public void guestInterrupt(Thread var1, T var2);

    public boolean isGuestInterrupted(Thread var1, T var2);

    default public T getCurrentGuestThread() {
        return null;
    }

    default public void afterInterrupt(Throwable ex) {
        if (ex != null) {
            throw GuestInterrupter.sneakyThrow(ex);
        }
        if (this.isGuestInterrupted(Thread.currentThread(), this.getCurrentGuestThread())) {
            throw GuestInterrupter.sneakyThrow(new GuestInterruptedException());
        }
    }

    default public void interrupt(Thread thread) {
        TruffleSafepoint.Interrupter.THREAD_INTERRUPT.interrupt(thread);
    }

    default public void resetInterrupted() {
        TruffleSafepoint.Interrupter.THREAD_INTERRUPT.resetInterrupted();
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }
}

