/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.bytecode.Bytes;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import java.io.PrintStream;
import java.util.Arrays;

public final class BytecodeStream {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] code;

    public BytecodeStream(byte[] code) {
        assert (code != null);
        this.code = code;
    }

    public int nextBCI(int curBCI) {
        return curBCI + this.lengthOf(curBCI);
    }

    public int endBCI() {
        return this.code.length;
    }

    public int currentBC(int curBCI) {
        int opcode = this.opcode(curBCI);
        if (opcode == 196) {
            return Bytes.beU1(this.code, curBCI + 1);
        }
        return opcode;
    }

    public int currentVolatileBC(int curBCI) {
        int opcode = this.volatileOpcode(curBCI);
        if (opcode == 196) {
            return Bytes.volatileBeU1(this.code, curBCI + 1);
        }
        return opcode;
    }

    public int readLocalIndex(int curBCI) {
        if (this.opcode(curBCI) == 196) {
            return Bytes.beU2(this.code, curBCI + 2);
        }
        return Bytes.beU1(this.code, curBCI + 1);
    }

    public int readLocalIndex1(int curBCI) {
        return Bytes.beU1(this.code, curBCI + 1);
    }

    public int readLocalIndex2(int curBCI) {
        return Bytes.beU2(this.code, curBCI + 2);
    }

    public int readIncrement(int curBCI) {
        if (this.opcode(curBCI) == 196) {
            return Bytes.beS2(this.code, curBCI + 4);
        }
        return Bytes.beS1(this.code, curBCI + 2);
    }

    public int readIncrement1(int curBCI) {
        return Bytes.beS1(this.code, curBCI + 2);
    }

    public int readIncrement2(int curBCI) {
        return Bytes.beS2(this.code, curBCI + 4);
    }

    public int readBranchDest(int curBCI) {
        int opcode = this.opcode(curBCI);
        if (opcode == 200 || opcode == 201) {
            return curBCI + Bytes.beS4(this.code, curBCI + 1);
        }
        return curBCI + Bytes.beS2(this.code, curBCI + 1);
    }

    public int readBranchDest4(int curBCI) {
        return curBCI + Bytes.beS4(this.code, curBCI + 1);
    }

    public int readBranchDest2(int curBCI) {
        return curBCI + Bytes.beS2(this.code, curBCI + 1);
    }

    public int readInt(int bci) {
        return Bytes.beS4(this.code, bci);
    }

    public int readUByte(int bci) {
        return Bytes.beU1(this.code, bci);
    }

    public char readCPI(int curBCI) {
        if (this.opcode(curBCI) == 18) {
            return (char)Bytes.beU1(this.code, curBCI + 1);
        }
        return (char)Bytes.beU2(this.code, curBCI + 1);
    }

    public char readCPI1(int curBCI) {
        return (char)Bytes.beU1(this.code, curBCI + 1);
    }

    public char readCPI2(int curBCI) {
        return (char)Bytes.beU2(this.code, curBCI + 1);
    }

    public static char readCPI(byte[] code, int curBCI) {
        if (BytecodeStream.opcode(code, curBCI) == 18) {
            return (char)Bytes.beU1(code, curBCI + 1);
        }
        return (char)Bytes.beU2(code, curBCI + 1);
    }

    public int readCPI4(int curBCI) {
        assert (this.opcode(curBCI) == 186);
        return Bytes.beS4(this.code, curBCI + 1);
    }

    public byte readByte(int curBCI) {
        return this.code[curBCI + 1];
    }

    public short readShort(int curBCI) {
        return (short)Bytes.beS2(this.code, curBCI + 1);
    }

    public int opcode(int curBCI) {
        return Bytes.beU1(this.code, curBCI);
    }

    private static int opcode(byte[] code, int curBCI) {
        return Bytes.beU1(code, curBCI);
    }

    public int volatileOpcode(int curBCI) {
        return Bytes.volatileBeU1(this.code, curBCI);
    }

    private int lengthOf(int curBCI) {
        int opcode = this.opcode(curBCI);
        int length = Bytecodes.lengthOf(opcode);
        if (length == 0) {
            switch (opcode) {
                case 170: {
                    return BytecodeTableSwitch.INSTANCE.size(this, curBCI);
                }
                case 171: {
                    return BytecodeLookupSwitch.INSTANCE.size(this, curBCI);
                }
                case 196: {
                    int opc = Bytes.beU1(this.code, curBCI + 1);
                    if (opc == 132) {
                        return 6;
                    }
                    return 4;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(BytecodeStream.unknownVariableLengthBytecodeMessage(opcode));
        }
        return length;
    }

    private static String unknownVariableLengthBytecodeMessage(int opcode) {
        return "unknown variable-length bytecode: " + Bytecodes.nameOf(opcode);
    }

    public void printBytecode(Klass klass, PrintStream out) {
        try {
            ConstantPool pool = klass.getConstantPool();
            int bci = 0;
            int nextBCI = 0;
            StringBuilder str = new StringBuilder();
            while (nextBCI < this.endBCI()) {
                str.setLength(0);
                bci = nextBCI;
                int opcode = this.currentBC(bci);
                str.append(bci).append(": ").append(Bytecodes.nameOf(opcode)).append(" ");
                nextBCI = this.nextBCI(bci);
                if (Bytecodes.isBranch(opcode)) {
                    str.append(this.readBranchDest(bci));
                } else if (opcode == 187) {
                    char cpi = this.readCPI(bci);
                    ClassConstant cc = (ClassConstant)pool.at(cpi);
                    str.append(cc.getName(pool));
                } else if (opcode == 186) {
                    char cpi = this.readCPI(bci);
                    InvokeDynamicConstant idc = (InvokeDynamicConstant)pool.at(cpi);
                    str.append("#").append(idc.getBootstrapMethodAttrIndex()).append(" -> ").append(idc.getName(pool)).append(":").append(idc.getSignature(pool));
                } else if (Bytecodes.isInvoke(opcode)) {
                    char cpi = this.readCPI(bci);
                    MethodRefConstant mrc = (MethodRefConstant)pool.at(cpi);
                    str.append(mrc.getHolderKlassName(pool)).append(".").append(mrc.getName(pool)).append(":").append(mrc.getDescriptor(pool));
                } else if (opcode == 170) {
                    str.append('\n');
                    BytecodeTableSwitch helper = BytecodeTableSwitch.INSTANCE;
                    int low = helper.lowKey(this, bci);
                    high = helper.highKey(this, bci);
                    for (i = low; i != high + 1; ++i) {
                        str.append('\t').append(i).append(": ").append(helper.targetAt(this, bci, i)).append('\n');
                    }
                    str.append("\tdefault: ").append(helper.defaultTarget(this, bci));
                } else if (opcode == 171) {
                    str.append('\n');
                    BytecodeLookupSwitch helper = BytecodeLookupSwitch.INSTANCE;
                    int low = 0;
                    high = helper.numberOfCases(this, bci) - 1;
                    for (i = low; i <= high; ++i) {
                        str.append('\t').append(helper.keyAt(this, bci, i)).append(": ").append(helper.targetAt(this, bci, i));
                    }
                    str.append("\tdefault: ").append(helper.defaultTarget(this, bci));
                } else if (opcode == 132) {
                    str.append(" ").append(this.readLocalIndex(bci)).append(" ").append(this.readIncrement(bci));
                } else {
                    if (nextBCI - bci == 2) {
                        str.append(this.readUByte(bci + 1));
                    }
                    if (nextBCI - bci == 3) {
                        str.append(this.readShort(bci));
                    }
                    if (nextBCI - bci == 5) {
                        str.append(this.readInt(bci + 1));
                    }
                }
                out.println(str.toString());
            }
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere("Exception thrown during bytecode printing, aborting...", e);
        }
    }

    public void printRawBytecode(PrintStream out) {
        out.println(Arrays.toString(this.code));
    }
}

