/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import com.oracle.truffle.espresso.runtime.Attribute;
import java.io.PrintStream;

public final class CodeAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.Code;
    private final int majorVersion;
    private final int maxStack;
    private final int maxLocals;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] originalCode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final ExceptionHandler[] exceptionHandlerEntries;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Attribute[] attributes;
    private static final int FLAGS_READY = 1;
    private static final int FLAGS_HAS_JSR = 2;
    private static final int FLAGS_USES_MONITORS = 4;
    @CompilerDirectives.CompilationFinal
    byte flags;

    public CodeAttribute(Symbol<Symbol.Name> name, int maxStack, int maxLocals, byte[] code, ExceptionHandler[] exceptionHandlerEntries, Attribute[] attributes, int majorVersion) {
        super(name, null);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.originalCode = code;
        this.exceptionHandlerEntries = exceptionHandlerEntries;
        this.attributes = attributes;
        this.majorVersion = majorVersion;
    }

    public CodeAttribute(CodeAttribute copy) {
        this(copy.getName(), copy.getMaxStack(), copy.getMaxLocals(), copy.getOriginalCode(), copy.getExceptionHandlers(), copy.attributes, copy.getMajorVersion());
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public byte[] getOriginalCode() {
        return this.originalCode;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlerEntries;
    }

    public StackMapTableAttribute getStackMapFrame() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != Symbol.Name.StackMapTable) continue;
            return (StackMapTableAttribute)attr;
        }
        return null;
    }

    public boolean hasJsr() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean usesMonitors() {
        return (this.getFlags() & 4) != 0;
    }

    private byte getFlags() {
        byte localFlags = this.flags;
        if (localFlags == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.flags = localFlags = CodeAttribute.computeFlags(this.originalCode);
            assert (localFlags != 0);
        }
        return localFlags;
    }

    private static byte computeFlags(byte[] code) {
        BytecodeStream bs = new BytecodeStream(code);
        int bci = 0;
        int flags = 1;
        while (bci < bs.endBCI()) {
            int opcode = bs.opcode(bci);
            switch (opcode) {
                case 168: 
                case 169: 
                case 201: {
                    flags |= 2;
                    break;
                }
                case 194: 
                case 195: {
                    flags |= 4;
                }
            }
            bci = bs.nextBCI(bci);
        }
        return (byte)flags;
    }

    public LineNumberTableAttribute getLineNumberTableAttribute() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != Symbol.Name.LineNumberTable) continue;
            return (LineNumberTableAttribute)attr;
        }
        return LineNumberTableAttribute.EMPTY;
    }

    public LocalVariableTable getLocalvariableTable() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != Symbol.Name.LocalVariableTable) continue;
            return (LocalVariableTable)attr;
        }
        return LocalVariableTable.EMPTY_LVT;
    }

    public LocalVariableTable getLocalvariableTypeTable() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != Symbol.Name.LocalVariableTypeTable) continue;
            return (LocalVariableTable)attr;
        }
        return LocalVariableTable.EMPTY_LVTT;
    }

    public int bciToLineNumber(int bci) {
        LineNumberTableAttribute lnt = this.getLineNumberTableAttribute();
        if (lnt == LineNumberTableAttribute.EMPTY) {
            return -1;
        }
        return lnt.getLineNumber(bci);
    }

    public boolean useStackMaps() {
        return this.majorVersion >= 50;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public static void print(Klass klass, byte[] code, PrintStream out) {
        try {
            new BytecodeStream(code).printBytecode(klass, out);
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere("Throw during printing. Aborting...", e);
        }
    }
}

