/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public class RecordAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.Record;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RecordComponentInfo[] components;

    public RecordAttribute(Symbol<Symbol.Name> name, RecordComponentInfo[] components) {
        super(name, null);
        this.components = components;
    }

    public RecordComponentInfo[] getComponents() {
        return this.components;
    }

    public static class RecordComponentInfo {
        final char name;
        final char descriptor;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Attribute[] attributes;

        public RecordComponentInfo(int name, int descriptor, Attribute[] attributes) {
            this.name = (char)name;
            this.descriptor = (char)descriptor;
            this.attributes = attributes;
        }

        public StaticObject toGuestComponent(Meta meta, ObjectKlass klass) {
            assert (meta.getJavaVersion().java16OrLater());
            RuntimeConstantPool pool = klass.getConstantPool();
            StaticObject component = meta.java_lang_reflect_RecordComponent.allocateInstance(meta.getContext());
            Symbol<Symbol.Name> nameSymbol = pool.symbolAt(this.name);
            Symbol<Symbol.Type> typeSymbol = pool.symbolAt(this.descriptor);
            Symbol<Symbol.Signature> signature = meta.getSignatures().makeRaw(typeSymbol, new Symbol[0]);
            meta.java_lang_reflect_RecordComponent_clazz.setObject(component, klass.mirror());
            meta.java_lang_reflect_RecordComponent_name.setObject(component, meta.toGuestString(nameSymbol));
            meta.java_lang_reflect_RecordComponent_type.setObject(component, meta.resolveSymbolAndAccessCheck(typeSymbol, klass).mirror());
            Method m = klass.lookupMethod(nameSymbol, signature);
            boolean validMethod = m != null && !m.isStatic() && !m.isConstructor();
            meta.java_lang_reflect_RecordComponent_accessor.setObject(component, validMethod ? m.makeMirror(meta) : StaticObject.NULL);
            SignatureAttribute genericSignatureAttribute = (SignatureAttribute)this.getAttribute(SignatureAttribute.NAME);
            meta.java_lang_reflect_RecordComponent_signature.setObject(component, genericSignatureAttribute != null ? meta.toGuestString(pool.symbolAt(genericSignatureAttribute.getSignatureIndex())) : StaticObject.NULL);
            this.doAnnotation(component, Symbol.Name.RuntimeVisibleAnnotations, meta.java_lang_reflect_RecordComponent_annotations, meta);
            this.doAnnotation(component, Symbol.Name.RuntimeVisibleTypeAnnotations, meta.java_lang_reflect_RecordComponent_typeAnnotations, meta);
            return component;
        }

        private void doAnnotation(StaticObject component, Symbol<Symbol.Name> attrName, Field f, Meta meta) {
            Attribute attr = this.getAttribute(attrName);
            f.setObject(component, attr == null ? StaticObject.NULL : StaticObject.wrap(attr.getData(), meta));
        }

        public Attribute getAttribute(Symbol<Symbol.Name> attributeName) {
            for (Attribute attr : this.attributes) {
                if (!attr.getName().equals(attributeName)) continue;
                return attr;
            }
            return null;
        }
    }
}

