/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Validation;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.logging.Level;

public interface ClassConstant
extends PoolConstant {
    public static final DebugCounter CLASS_RESOLVE_COUNT = DebugCounter.create("ClassConstant.resolve calls");

    public static ClassConstant create(int classNameIndex) {
        return new Index(classNameIndex);
    }

    public static ClassConstant preResolved(Klass klass) {
        return new PreResolved(klass);
    }

    public static ClassConstant withString(Symbol<Symbol.Name> name) {
        return new WithString(name);
    }

    public static Resolvable.ResolvedConstant resolved(Klass klass) {
        return new Resolved(klass);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.CLASS;
    }

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getName(pool).toString();
    }

    public static final class Index
    implements ClassConstant,
    Resolvable {
        private final char classNameIndex;

        Index(int classNameIndex) {
            this.classNameIndex = PoolConstant.u2(classNameIndex);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.symbolAt(this.classNameIndex);
        }

        /*
         * Exception decompiling
         */
        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.utf8At(this.classNameIndex).validateClassName();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.classNameIndex);
        }
    }

    public static final class PreResolved
    implements ClassConstant,
    Resolvable {
        private final Klass resolved;

        PreResolved(Klass resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            return new Resolved(this.resolved);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }

    public static final class WithString
    implements ClassConstant,
    Resolvable {
        private final Symbol<Symbol.Name> name;

        WithString(Symbol<Symbol.Name> name) {
            this.name = name;
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.name;
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            CLASS_RESOLVE_COUNT.inc();
            assert (accessingKlass != null);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Symbol<Symbol.Name> klassName = this.getName(pool);
            EspressoContext context = pool.getContext();
            Meta meta = context.getMeta();
            Klass klass = meta.resolveSymbolOrFail(context.getTypes().fromName(klassName), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
            if (!Klass.checkAccess(klass.getElementalType(), accessingKlass, false)) {
                context.getLogger().log(Level.FINE, "Access check of: " + String.valueOf(klass.getType()) + " from " + String.valueOf(accessingKlass.getType()) + " throws IllegalAccessError");
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(klassName));
            }
            return new Resolved(klass);
        }

        @Override
        public void validate(ConstantPool pool) {
            if (!Validation.validModifiedUTF8(this.name) || !Validation.validClassNameEntry(this.name)) {
                throw ConstantPool.classFormatError("Invalid class name entry: " + String.valueOf(this.name));
            }
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }

    public static final class Resolved
    implements ClassConstant,
    Resolvable.ResolvedConstant {
        private final Klass resolved;

        Resolved(Klass resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Klass value() {
            return this.resolved;
        }
    }
}

