/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.BootstrapMethodConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.nio.ByteBuffer;
import java.util.Arrays;

public interface InvokeDynamicConstant
extends BootstrapMethodConstant {
    public static InvokeDynamicConstant create(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
        return new Indexes(bootstrapMethodAttrIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.INVOKEDYNAMIC;
    }

    public Symbol<Symbol.Signature> getSignature(ConstantPool var1);

    default public Symbol<Symbol.Type>[] getParsedSignature() {
        throw EspressoError.shouldNotReachHere("Not resolved yet");
    }

    default public boolean isResolved() {
        return false;
    }

    public CallSiteLink link(RuntimeConstantPool var1, ObjectKlass var2, int var3, Method var4, int var5);

    public static final class Indexes
    extends BootstrapMethodConstant.Indexes
    implements InvokeDynamicConstant,
    Resolvable {
        Indexes(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
            super(bootstrapMethodAttrIndex, nameAndTypeIndex);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.bootstrapMethodAttrIndex);
            buf.putChar(this.nameAndTypeIndex);
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateMethod(pool, false);
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            return Signatures.check(pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool));
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            CompilerAsserts.neverPartOfCompilation();
            BootstrapMethodsAttribute bms = (BootstrapMethodsAttribute)accessingKlass.getAttribute(BootstrapMethodsAttribute.NAME);
            BootstrapMethodsAttribute.Entry bsEntry = bms.at(this.getBootstrapMethodAttrIndex());
            Meta meta = accessingKlass.getMeta();
            Symbol<Symbol.Signature> invokeSignature = this.getSignature(pool);
            Symbol<Symbol.Type>[] parsedInvokeSignature = meta.getSignatures().parsed(invokeSignature);
            return new Resolved(bsEntry, parsedInvokeSignature, this.getName(pool));
        }

        @Override
        public String toString(ConstantPool pool) {
            return "bsmIndex:" + this.getBootstrapMethodAttrIndex() + " " + String.valueOf(this.getSignature(pool));
        }

        @Override
        public CallSiteLink link(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
            throw EspressoError.shouldNotReachHere("Not resolved yet");
        }
    }

    public static final class Fail
    implements InvokeDynamicConstant,
    Resolvable.ResolvedConstant {
        private final EspressoException failure;

        public Fail(EspressoException failure) {
            this.failure = failure;
        }

        @Override
        public CallSiteLink link(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
            throw this.failure;
        }

        @Override
        public Object value() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Use indy.link() rather than Resolved.value()");
        }

        @Override
        public int getBootstrapMethodAttrIndex() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Invoke dynamic already resolved.");
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Invoke dynamic already resolved.");
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Invoke dynamic already resolved.");
        }

        @Override
        public NameAndTypeConstant getNameAndType(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Invoke dynamic already resolved.");
        }

        @Override
        public void dump(ByteBuffer buf) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Invoke dynamic already resolved.");
        }

        @Override
        public boolean isSuccess() {
            return false;
        }
    }

    public static final class CallSiteLinkingFailure
    extends RuntimeException {
        private static final long serialVersionUID = 2567495832103023693L;
        public EspressoException cause;

        public CallSiteLinkingFailure(EspressoException cause) {
            this.cause = cause;
        }

        public Fail failConstant() {
            return new Fail(this.cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class CallSiteLink {
        private final Method method;
        private final int bci;
        final StaticObject memberName;
        final StaticObject unboxedAppendix;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Symbol<Symbol.Type>[] parsedSignature;

        public CallSiteLink(Method method, int bci, StaticObject memberName, StaticObject unboxedAppendix, Symbol<Symbol.Type>[] parsedSignature) {
            this.method = method;
            this.bci = bci;
            this.memberName = memberName;
            this.unboxedAppendix = unboxedAppendix;
            this.parsedSignature = parsedSignature;
        }

        public StaticObject getMemberName() {
            return this.memberName;
        }

        public StaticObject getUnboxedAppendix() {
            return this.unboxedAppendix;
        }

        public Symbol<Symbol.Type>[] getParsedSignature() {
            return this.parsedSignature;
        }

        public boolean matchesCallSite(Method siteMethod, int siteBci) {
            return this.bci == siteBci && this.method == siteMethod;
        }
    }

    public static final class Resolved
    implements InvokeDynamicConstant,
    Resolvable.ResolvedConstant {
        private final BootstrapMethodsAttribute.Entry bootstrapMethod;
        private final Symbol<Symbol.Type>[] parsedInvokeSignature;
        private final Symbol<Symbol.Name> nameSymbol;
        private volatile CallSiteLink[] callSiteLinks;

        public Resolved(BootstrapMethodsAttribute.Entry bootstrapMethod, Symbol<Symbol.Type>[] parsedInvokeSignature, Symbol<Symbol.Name> name) {
            this.bootstrapMethod = bootstrapMethod;
            this.parsedInvokeSignature = parsedInvokeSignature;
            this.nameSymbol = name;
        }

        @Override
        public Object value() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Use indy.link() rather than Resolved.value()");
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CallSiteLink link(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
            int existingIndex = this.findCallSiteLinkIndex(method, bci);
            if (existingIndex >= 0) {
                return this.getCallSiteLink(existingIndex);
            }
            CallSiteLink newLink = this.createCallSiteLink(pool, accessingKlass, thisIndex, method, bci);
            Resolved resolved = this;
            synchronized (resolved) {
                CallSiteLink[] existingLinks = this.callSiteLinks;
                if (existingLinks == null) {
                    CallSiteLink[] newLinks = new CallSiteLink[]{newLink};
                    this.callSiteLinks = newLinks;
                    return newLink;
                }
                for (int i = 0; i < existingLinks.length; ++i) {
                    CallSiteLink link = existingLinks[i];
                    if (link == null) {
                        existingLinks[i] = newLink;
                        return existingLinks[i];
                    }
                    if (!link.matchesCallSite(method, bci)) continue;
                    return link;
                }
                CallSiteLink[] newLinks = Arrays.copyOf(existingLinks, existingLinks.length * 2);
                newLinks[i] = newLink;
                this.callSiteLinks = newLinks;
                return newLink;
            }
        }

        private CallSiteLink createCallSiteLink(RuntimeConstantPool pool, ObjectKlass accessingKlass, int thisIndex, Method method, int bci) {
            CompilerAsserts.neverPartOfCompilation();
            Meta meta = accessingKlass.getMeta();
            try {
                StaticObject bootstrapmethodMethodHandle = this.bootstrapMethod.getMethodHandle(accessingKlass, pool);
                StaticObject[] args = this.bootstrapMethod.getStaticArguments(accessingKlass, pool);
                StaticObject name = meta.toGuestString(this.nameSymbol);
                StaticObject methodType = MethodTypeConstant.signatureToMethodType(this.parsedInvokeSignature, accessingKlass, meta.getContext().getJavaVersion().java8OrEarlier(), meta);
                StaticObject appendix = StaticObject.createArray(meta.java_lang_Object_array, new StaticObject[1], meta.getContext());
                StaticObject memberName = meta.getJavaVersion().varHandlesEnabled() && !meta.getJavaVersion().java19OrLater() ? (StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkCallSite.invokeDirect(null, accessingKlass.mirror(), thisIndex, bootstrapmethodMethodHandle, name, methodType, StaticObject.createArray(meta.java_lang_Object_array, args.clone(), meta.getContext()), appendix) : (StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkCallSite.invokeDirect(null, accessingKlass.mirror(), bootstrapmethodMethodHandle, name, methodType, StaticObject.createArray(meta.java_lang_Object_array, args.clone(), meta.getContext()), appendix);
                StaticObject unboxedAppendix = (StaticObject)appendix.get(meta.getLanguage(), 0);
                return new CallSiteLink(method, bci, memberName, unboxedAppendix, this.parsedInvokeSignature);
            }
            catch (EspressoException e) {
                throw new CallSiteLinkingFailure(e);
            }
        }

        public int findCallSiteLinkIndex(Method method, int bci) {
            CallSiteLink link;
            CallSiteLink[] existingLinks = this.callSiteLinks;
            if (existingLinks == null) {
                return -1;
            }
            for (int i = 0; i < existingLinks.length && (link = existingLinks[i]) != null; ++i) {
                if (!link.matchesCallSite(method, bci)) continue;
                return i;
            }
            return -1;
        }

        public CallSiteLink getCallSiteLink(int index) {
            return this.callSiteLinks[index];
        }

        @Override
        public int getBootstrapMethodAttrIndex() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("String already resolved");
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("String already resolved");
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("String already resolved");
        }

        @Override
        public NameAndTypeConstant getNameAndType(ConstantPool pool) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("String already resolved");
        }

        @Override
        public Symbol<Symbol.Type>[] getParsedSignature() {
            return this.parsedInvokeSignature;
        }
    }
}

