/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistries;
import com.oracle.truffle.espresso.impl.ContextDescription;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LinkedKlass;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCloseable;
import com.oracle.truffle.espresso.perf.DebugTimer;
import com.oracle.truffle.espresso.redefinition.DefineKlassListener;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ClassRegistry {
    private final DynamicModuleWrapper dynamicModuleWrapper = new DynamicModuleWrapper();
    private static final DebugTimer KLASS_PROBE = DebugTimer.create("klass probe");
    private static final DebugTimer KLASS_DEFINE = DebugTimer.create("klass define");
    private static final DebugTimer KLASS_PARSE = DebugTimer.create("klass parse");
    private DefineKlassListener defineKlassListener;
    private final long loaderID;
    private ModuleTable.ModuleEntry unnamed;
    private final PackageTable packages;
    private final ModuleTable modules;
    protected final ConcurrentHashMap<Symbol<Symbol.Type>, ClassRegistries.RegistryEntry> classes = new ConcurrentHashMap();
    private volatile Collection<Klass> strongHiddenKlasses = null;

    public void registerOnLoadListener(DefineKlassListener listener) {
        this.defineKlassListener = listener;
    }

    public ModuleTable.ModuleEntry getUnnamedModule() {
        return this.unnamed;
    }

    public final long getLoaderID() {
        return this.loaderID;
    }

    public ModuleTable modules() {
        return this.modules;
    }

    public PackageTable packages() {
        return this.packages;
    }

    private Object getStrongHiddenClassRegistrationLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerStrongHiddenClass(Klass klass) {
        Object object = this.getStrongHiddenClassRegistrationLock();
        synchronized (object) {
            if (this.strongHiddenKlasses == null) {
                this.strongHiddenKlasses = new ArrayList<Klass>();
            }
            this.strongHiddenKlasses.add(klass);
        }
    }

    protected ClassRegistry(long loaderID) {
        this.loaderID = loaderID;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.packages = new PackageTable(rwLock);
        this.modules = new ModuleTable(rwLock);
    }

    public void initUnnamedModule(StaticObject unnamedModule) {
        this.unnamed = ModuleTable.ModuleEntry.createUnnamedModuleEntry(unnamedModule, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Klass loadKlass(EspressoContext context, Symbol<Symbol.Type> type, StaticObject protectionDomain) throws EspressoClassLoadingException {
        ClassRegistries.RegistryEntry entry;
        ClassLoadingEnv env = context.getClassLoadingEnv();
        if (Types.isArray(type)) {
            Klass elemental = this.loadKlass(context, env.getTypes().getElementalType(type), protectionDomain);
            if (elemental == null) {
                return null;
            }
            return elemental.getArrayClass(Types.getArrayDimensions(type));
        }
        this.loadKlassCountInc();
        try (Object probe = KLASS_PROBE.scope(env.getTimers());){
            entry = this.classes.get(type);
        }
        if (entry == null) {
            probe = type;
            synchronized (probe) {
                entry = this.classes.get(type);
                if (entry == null) {
                    if (this.loadKlassImpl(context, type) == null) {
                        return null;
                    }
                    entry = this.classes.get(type);
                }
            }
        } else {
            this.loadKlassCacheHitsInc();
        }
        assert (entry != null);
        StaticObject classLoader = this.getClassLoader();
        if (!StaticObject.isNull(classLoader)) {
            entry.checkPackageAccess(env.getMeta(), classLoader, protectionDomain);
        }
        return entry.klass();
    }

    protected abstract Klass loadKlassImpl(EspressoContext var1, Symbol<Symbol.Type> var2) throws EspressoClassLoadingException;

    protected abstract void loadKlassCountInc();

    protected abstract void loadKlassCacheHitsInc();

    public abstract @JavaType(value=ClassLoader.class) StaticObject getClassLoader();

    public List<Klass> getLoadedKlasses() {
        ArrayList<Klass> klasses = new ArrayList<Klass>(this.classes.size());
        for (ClassRegistries.RegistryEntry entry : this.classes.values()) {
            klasses.add(entry.klass());
        }
        return klasses;
    }

    public Klass findLoadedKlass(ClassLoadingEnv env, Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            Symbol<Symbol.Type> elemental = env.getTypes().getElementalType(type);
            Klass elementalKlass = this.findLoadedKlass(env, elemental);
            if (elementalKlass == null) {
                return null;
            }
            return elementalKlass.getArrayClass(Types.getArrayDimensions(type));
        }
        ClassRegistries.RegistryEntry entry = this.classes.get(type);
        if (entry == null) {
            return null;
        }
        return entry.klass();
    }

    public final ObjectKlass defineKlass(EspressoContext context, Symbol<Symbol.Type> typeOrNull, byte[] bytes) throws EspressoClassLoadingException {
        return this.defineKlass(context, typeOrNull, bytes, ClassDefinitionInfo.EMPTY);
    }

    public ObjectKlass defineKlass(EspressoContext context, Symbol<Symbol.Type> typeOrNull, byte[] bytes, ClassDefinitionInfo info) throws EspressoClassLoadingException {
        Klass maybeLoaded;
        Symbol<Symbol.Type> type;
        ParserKlass parserKlass;
        ClassLoadingEnv env = context.getClassLoadingEnv();
        try (DebugCloseable parse = KLASS_PARSE.scope(env.getTimers());){
            parserKlass = this.parseKlass(env, bytes, typeOrNull, info);
        }
        Symbol<Symbol.Type> symbol = type = typeOrNull == null ? parserKlass.getType() : typeOrNull;
        if (info.addedToRegistry() && (maybeLoaded = this.findLoadedKlass(env, type)) != null) {
            throw EspressoClassLoadingException.linkageError("Class " + String.valueOf(type) + " already defined");
        }
        Symbol<Symbol.Type> superKlassType = parserKlass.getSuperKlass();
        ObjectKlass klass = this.createKlass(context, parserKlass, type, superKlassType, info);
        if (info.addedToRegistry()) {
            this.registerKlass(klass, type);
        } else if (info.isStrongHidden()) {
            this.registerStrongHiddenClass(klass);
        }
        return klass;
    }

    private ParserKlass parseKlass(ClassLoadingEnv env, byte[] bytes, Symbol<Symbol.Type> typeOrNull, ClassDefinitionInfo info) throws EspressoClassLoadingException.SecurityException {
        ParserKlass parserKlass = env.getLanguage().getLanguageCache().getOrCreateParserKlass(env, this.getClassLoader(), typeOrNull, bytes, info);
        if (!env.loaderIsBootOrPlatform(this.getClassLoader()) && parserKlass.getName().toString().startsWith("java/")) {
            throw EspressoClassLoadingException.securityException("Define class in prohibited package name: " + String.valueOf(parserKlass.getName()));
        }
        return parserKlass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectKlass createKlass(EspressoContext context, ParserKlass parserKlass, Symbol<Symbol.Type> type, Symbol<Symbol.Type> superKlassType, ClassDefinitionInfo info) throws EspressoClassLoadingException {
        ObjectKlass klass;
        ClassLoadingEnv env = context.getClassLoadingEnv();
        EspressoThreadLocalState threadLocalState = env.getLanguage().getThreadLocalState();
        TypeStack chain = threadLocalState.getTypeStack();
        ObjectKlass superKlass = null;
        ObjectKlass[] superInterfaces = null;
        LinkedKlass[] linkedInterfaces = null;
        chain.push(type);
        try {
            Symbol<Symbol.Type>[] superInterfacesTypes;
            if (superKlassType != null) {
                if (chain.contains(superKlassType)) {
                    throw EspressoClassLoadingException.classCircularityError();
                }
                superKlass = this.loadKlassRecursively(context, superKlassType, true);
            }
            linkedInterfaces = (superInterfacesTypes = parserKlass.getSuperInterfaces()).length == 0 ? LinkedKlass.EMPTY_ARRAY : new LinkedKlass[superInterfacesTypes.length];
            superInterfaces = superInterfacesTypes.length == 0 ? ObjectKlass.EMPTY_ARRAY : new ObjectKlass[superInterfacesTypes.length];
            for (int i = 0; i < superInterfacesTypes.length; ++i) {
                ObjectKlass interf;
                if (chain.contains(superInterfacesTypes[i])) {
                    throw EspressoClassLoadingException.classCircularityError();
                }
                superInterfaces[i] = interf = this.loadKlassRecursively(context, superInterfacesTypes[i], false);
                linkedInterfaces[i] = interf.getLinkedKlass();
            }
        }
        finally {
            chain.pop();
        }
        if (env.getJavaVersion().java16OrLater() && superKlass != null && superKlass.isFinalFlagSet()) {
            throw EspressoClassLoadingException.incompatibleClassChangeError("class " + String.valueOf(type) + " is a subclass of final class " + String.valueOf(superKlassType));
        }
        try (DebugCloseable define = KLASS_DEFINE.scope(env.getTimers());){
            ContextDescription description = new ContextDescription(env.getLanguage(), env.getJavaVersion());
            LinkedKlass linkedSuperKlass = superKlass == null ? null : superKlass.getLinkedKlass();
            LinkedKlass linkedKlass = env.getLanguage().getLanguageCache().getOrCreateLinkedKlass(env, description, this.getClassLoader(), parserKlass, linkedSuperKlass, linkedInterfaces, info);
            klass = new ObjectKlass(context, linkedKlass, superKlass, superInterfaces, this.getClassLoader(), info);
        }
        if (superKlass != null) {
            if (!Klass.checkAccess(superKlass, klass, true)) {
                StringBuilder sb = new StringBuilder().append("class ").append(klass.getExternalName()).append(" cannot access its superclass ").append(superKlass.getExternalName());
                ClassRegistry.superTypeAccessMessage(klass, superKlass, sb, context);
                throw EspressoClassLoadingException.illegalAccessError(sb.toString());
            }
            if (!superKlass.permittedSubclassCheck(klass)) {
                throw EspressoClassLoadingException.incompatibleClassChangeError("class " + klass.getExternalName() + " is not a permitted subclass of class " + superKlass.getExternalName());
            }
        }
        for (ObjectKlass interf : superInterfaces) {
            if (interf == null) continue;
            if (!Klass.checkAccess(interf, klass, true)) {
                StringBuilder sb = new StringBuilder().append("class ").append(klass.getExternalName()).append(" cannot access its superinterface ").append(interf.getExternalName());
                ClassRegistry.superTypeAccessMessage(klass, interf, sb, context);
                throw EspressoClassLoadingException.illegalAccessError(sb.toString());
            }
            if (interf.permittedSubclassCheck(klass)) continue;
            throw EspressoClassLoadingException.incompatibleClassChangeError("class " + klass.getExternalName() + " is not a permitted subclass of interface " + interf.getExternalName());
        }
        return klass;
    }

    private static void superTypeAccessMessage(ObjectKlass sub, ObjectKlass sup, StringBuilder sb, EspressoContext context) {
        if (context.getJavaVersion().modulesEnabled()) {
            sb.append(" (");
            Meta meta = context.getMeta();
            if (sup.module() == sub.module()) {
                sb.append(sub.getExternalName());
                sb.append(" and ");
                ClassRegistry.classInModuleOfLoader(sup, true, sb, meta);
            } else {
                ClassRegistry.classInModuleOfLoader(sub, false, sb, meta);
                sb.append("; ");
                ClassRegistry.classInModuleOfLoader(sup, false, sb, meta);
            }
            sb.append(")");
        }
    }

    public static void classInModuleOfLoader(ObjectKlass klass, boolean plural, StringBuilder sb, Meta meta) {
        assert (meta.getJavaVersion().modulesEnabled() && meta.java_lang_ClassLoader_nameAndId != null);
        sb.append(klass.getExternalName());
        if (plural) {
            sb.append(" are in ");
        } else {
            sb.append(" is in ");
        }
        ModuleTable.ModuleEntry module = klass.module();
        if (module.isNamed()) {
            sb.append("module ").append(module.getNameAsString());
        } else {
            sb.append("unnamed module");
        }
        sb.append(" of loader ");
        StaticObject loader = klass.getDefiningClassLoader();
        if (StaticObject.isNull(loader)) {
            sb.append("bootstrap");
        } else {
            StaticObject nameAndId = meta.java_lang_ClassLoader_nameAndId.getObject(loader);
            if (StaticObject.isNull(nameAndId)) {
                sb.append(loader.getKlass().getExternalName());
            } else {
                sb.append(meta.toHostString(nameAndId));
            }
        }
    }

    private void registerKlass(ObjectKlass klass, Symbol<Symbol.Type> type) {
        ClassRegistries.RegistryEntry entry = new ClassRegistries.RegistryEntry(klass);
        ClassRegistries.RegistryEntry previous = this.classes.putIfAbsent(type, entry);
        EspressoError.guarantee(previous == null, "Class already defined", type);
        klass.getRegistries().recordConstraint(type, klass, this.getClassLoader());
        klass.getRegistries().onKlassDefined(klass);
        if (this.defineKlassListener != null) {
            this.defineKlassListener.onKlassDefined(klass);
        }
    }

    private ObjectKlass loadKlassRecursively(EspressoContext context, Symbol<Symbol.Type> type, boolean notInterface) throws EspressoClassLoadingException {
        Klass klass;
        ClassLoadingEnv env = context.getClassLoadingEnv();
        try {
            klass = this.loadKlass(context, type, StaticObject.NULL);
        }
        catch (EspressoException e) {
            throw EspressoClassLoadingException.wrapClassNotFoundGuestException(env, e);
        }
        if (notInterface == klass.isInterface()) {
            throw EspressoClassLoadingException.incompatibleClassChangeError("Super interface of " + String.valueOf(type) + " is in fact not an interface.");
        }
        return (ObjectKlass)klass;
    }

    public void onClassRenamed(ObjectKlass renamedKlass) {
        ClassLoadingEnv env = renamedKlass.getContext().getClassLoadingEnv();
        Klass loadedKlass = this.findLoadedKlass(env, renamedKlass.getType());
        if (loadedKlass != null) {
            loadedKlass.getRegistries().removeUnloadedKlassConstraint(loadedKlass, renamedKlass.getType());
        }
        this.classes.put(renamedKlass.getType(), new ClassRegistries.RegistryEntry(renamedKlass));
        renamedKlass.getRegistries().recordConstraint(renamedKlass.getType(), renamedKlass, renamedKlass.getDefiningClassLoader());
    }

    public void onInnerClassRemoved(Symbol<Symbol.Type> type) {
        ClassRegistries.RegistryEntry removed = this.classes.remove(type);
        if (removed != null && removed.klass() != null) {
            removed.klass().getRegistries().removeUnloadedKlassConstraint(removed.klass(), type);
        }
    }

    public final DynamicModuleWrapper getProxyDynamicModuleWrapper() {
        return this.dynamicModuleWrapper;
    }

    public final class DynamicModuleWrapper {
        private ModuleTable.ModuleEntry dynamicProxyModule;

        public ModuleTable.ModuleEntry getDynamicProxyModule() {
            return this.dynamicProxyModule;
        }

        public void setDynamicProxyModule(ModuleTable.ModuleEntry module) {
            this.dynamicProxyModule = module;
        }
    }

    public static final class ClassDefinitionInfo {
        public static final ClassDefinitionInfo EMPTY = new ClassDefinitionInfo(null, null, null, null, null, false, false);
        public final StaticObject protectionDomain;
        public final ObjectKlass hostKlass;
        public final StaticObject[] patches;
        public final ObjectKlass dynamicNest;
        public final StaticObject classData;
        public final boolean isHidden;
        public final boolean isStrongHidden;
        public long klassID = -1L;

        public ClassDefinitionInfo(StaticObject protectionDomain) {
            this(protectionDomain, null, null, null, null, false, false);
        }

        public ClassDefinitionInfo(StaticObject protectionDomain, ObjectKlass hostKlass, StaticObject[] patches) {
            this(protectionDomain, hostKlass, patches, null, null, false, false);
        }

        public ClassDefinitionInfo(StaticObject protectionDomain, ObjectKlass dynamicNest, StaticObject classData, boolean isStrongHidden) {
            this(protectionDomain, null, null, dynamicNest, classData, true, isStrongHidden);
        }

        private ClassDefinitionInfo(StaticObject protectionDomain, ObjectKlass hostKlass, StaticObject[] patches, ObjectKlass dynamicNest, StaticObject classData, boolean isHidden, boolean isStrongHidden) {
            assert (!isStrongHidden || isHidden);
            this.protectionDomain = protectionDomain;
            this.hostKlass = hostKlass;
            this.patches = patches;
            this.dynamicNest = dynamicNest;
            this.classData = classData;
            this.isHidden = isHidden;
            this.isStrongHidden = isStrongHidden;
            assert (this.isAnonymousClass() || patches == null);
        }

        public boolean addedToRegistry() {
            return !this.isAnonymousClass() && !this.isHidden();
        }

        public boolean isAnonymousClass() {
            return this.hostKlass != null;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public boolean isStrongHidden() {
            return this.isStrongHidden;
        }

        public int patchFlags(int classFlags) {
            int flags = classFlags;
            if (this.isHidden()) {
                flags |= 0x4000000;
            }
            return flags;
        }

        public void initKlassID(long futureKlassID) {
            this.klassID = futureKlassID;
        }
    }

    public static final class TypeStack {
        Node head;

        boolean isEmpty() {
            return this.head == null;
        }

        boolean contains(Symbol<Symbol.Type> type) {
            Node curr = this.head;
            while (curr != null) {
                if (curr.entry == type) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }

        Symbol<Symbol.Type> pop() {
            if (this.isEmpty()) {
                CompilerAsserts.neverPartOfCompilation();
                throw EspressoError.shouldNotReachHere();
            }
            Symbol<Symbol.Type> res = this.head.entry;
            this.head = this.head.next;
            return res;
        }

        void push(Symbol<Symbol.Type> type) {
            this.head = new Node(type, this.head);
        }

        static final class Node {
            Symbol<Symbol.Type> entry;
            Node next;

            Node(Symbol<Symbol.Type> entry, Node next) {
                this.entry = entry;
                this.next = next;
            }
        }
    }
}

