/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.redefinition.InnerClassRedefiner;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class ConstantPoolPatcher {
    public static void getDirectInnerAnonymousClassNames(Symbol<Symbol.Name> fileSystemName, byte[] bytes, Set<Symbol<Symbol.Name>> innerNames, EspressoContext context) throws ClassFormatError {
        ClassfileStream stream = new ClassfileStream(bytes, null);
        stream.skip(8);
        int length = stream.readU2();
        block10: for (int i = 1; i < length; ++i) {
            int tagByte = stream.readU1();
            ConstantPool.Tag tag = ConstantPool.Tag.fromValue(tagByte);
            switch (tag) {
                case UTF8: {
                    ByteSequence byteSequence = stream.readByteSequenceUTF();
                    if (!ConstantPoolPatcher.isDirectAnonymousInnerClass(fileSystemName, byteSequence)) continue block10;
                    assert (InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(byteSequence.toString()).matches());
                    innerNames.add(context.getNames().getOrCreate(byteSequence));
                    continue block10;
                }
                case CLASS: 
                case STRING: 
                case METHODTYPE: {
                    stream.readU2();
                    continue block10;
                }
                case FIELD_REF: 
                case METHOD_REF: 
                case INTERFACE_METHOD_REF: 
                case NAME_AND_TYPE: 
                case DYNAMIC: 
                case INVOKEDYNAMIC: {
                    stream.readU2();
                    stream.readU2();
                    continue block10;
                }
                case INTEGER: {
                    stream.readS4();
                    continue block10;
                }
                case FLOAT: {
                    stream.readFloat();
                    continue block10;
                }
                case LONG: {
                    stream.readS8();
                    ++i;
                    continue block10;
                }
                case DOUBLE: {
                    stream.readDouble();
                    ++i;
                    continue block10;
                }
                case METHODHANDLE: {
                    stream.readU1();
                    stream.readU2();
                    continue block10;
                }
                default: {
                    throw new ClassFormatError();
                }
            }
        }
    }

    private static boolean isDirectAnonymousInnerClass(ByteSequence outer, ByteSequence inner) {
        if (!inner.contentStartsWith(outer) || inner.length() < outer.length() + 2) {
            return false;
        }
        int i = outer.length();
        if (inner.byteAt(i++) != 36) {
            return false;
        }
        do {
            if (ConstantPoolPatcher.isDecimalDigit(inner.byteAt(i++))) continue;
            return false;
        } while (i < inner.length());
        return true;
    }

    private static boolean isDecimalDigit(byte c) {
        return 48 <= c && c <= 57;
    }

    public static byte[] patchConstantPool(byte[] bytes, Map<Symbol<Symbol.Name>, Symbol<Symbol.Name>> rules, EspressoContext context) throws ClassFormatError {
        byte[] result = Arrays.copyOf(bytes, bytes.length);
        ClassfileStream stream = new ClassfileStream(bytes, null);
        stream.skip(8);
        int length = stream.readU2();
        int byteArrayGrowth = 0;
        block10: for (int i = 1; i < length; ++i) {
            int tagByte = stream.readU1();
            ConstantPool.Tag tag = ConstantPool.Tag.fromValue(tagByte);
            switch (tag) {
                case UTF8: {
                    Symbol<Symbol.Name> replacedSymbol;
                    int position = stream.getPosition() + 2;
                    ByteSequence byteSequence = stream.readByteSequenceUTF();
                    Symbol<Symbol.Name> asSymbol = context.getNames().getOrCreate(byteSequence);
                    if (!rules.containsKey(asSymbol)) continue block10;
                    int originalLength = byteSequence.length();
                    if (originalLength == (replacedSymbol = rules.get(asSymbol)).length()) {
                        replacedSymbol.writeTo(result, position + byteArrayGrowth);
                        continue block10;
                    }
                    int diff = replacedSymbol.length() - originalLength;
                    result = Arrays.copyOf(result, result.length + diff);
                    int currentPosition = stream.getPosition();
                    System.arraycopy(bytes, currentPosition, result, currentPosition + (byteArrayGrowth += diff), bytes.length - currentPosition);
                    char utfLength = (char)replacedSymbol.length();
                    int utfLengthPosition = position - 2 + byteArrayGrowth - diff;
                    result[utfLengthPosition] = (byte)(utfLength >> 8);
                    result[utfLengthPosition + 1] = (byte)utfLength;
                    replacedSymbol.writeTo(result, utfLengthPosition + 2);
                    continue block10;
                }
                case CLASS: 
                case STRING: 
                case METHODTYPE: {
                    stream.readU2();
                    continue block10;
                }
                case FIELD_REF: 
                case METHOD_REF: 
                case INTERFACE_METHOD_REF: 
                case NAME_AND_TYPE: 
                case DYNAMIC: 
                case INVOKEDYNAMIC: {
                    stream.readU2();
                    stream.readU2();
                    continue block10;
                }
                case INTEGER: {
                    stream.readS4();
                    continue block10;
                }
                case FLOAT: {
                    stream.readFloat();
                    continue block10;
                }
                case LONG: {
                    stream.readS8();
                    ++i;
                    continue block10;
                }
                case DOUBLE: {
                    stream.readDouble();
                    ++i;
                    continue block10;
                }
                case METHODHANDLE: {
                    stream.readU1();
                    stream.readU2();
                    continue block10;
                }
                default: {
                    throw new ClassFormatError();
                }
            }
        }
        return result;
    }
}

