/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.KeysArray;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.jdwp.api.JDWPConstantPool;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.ModuleRef;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.InteropKlassesDispatch;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethod;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethodNodeGen;
import com.oracle.truffle.espresso.nodes.interop.LookupFieldNode;
import com.oracle.truffle.espresso.nodes.interop.LookupFieldNodeGen;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNodeFactory;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitive;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitiveFactory;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoFunction;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.InteropUtils;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.InteropLookupAndInvoke;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.InteropLookupAndInvokeFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.VM;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.function.IntFunction;
import org.graalvm.collections.EconomicSet;

@ExportLibrary(value=InteropLibrary.class)
public abstract class Klass
extends ContextAccessImpl
implements ModifiersProvider,
KlassRef,
TruffleObject {
    public static final String STATIC_TO_CLASS = "class";
    private static final String ARRAY = "array";
    private static final String COMPONENT = "component";
    private static final String SUPER = "super";
    public static final byte UN_INITIALIZED = -1;
    public static final byte NOT_MAPPED = 0;
    public static final byte TYPE_MAPPED = 1;
    public static final byte INTERNAL_MAPPED = 2;
    public static final byte INTERFACE_MAPPED = 3;
    public static final byte INTERNAL_COLLECTION_MAPPED = 4;
    @CompilerDirectives.CompilationFinal
    public byte typeConversionState = (byte)-1;
    private static final int LINEAR_SEARCH_THRESHOLD = 8;
    static final Comparator<Klass> KLASS_ID_COMPARATOR = new Comparator<Klass>(){

        @Override
        public int compare(Klass k1, Klass k2) {
            return Long.compare(k1.id, k2.id);
        }
    };
    static final Comparator<ObjectKlass.KlassVersion> KLASS_VERSION_ID_COMPARATOR = new Comparator<ObjectKlass.KlassVersion>(){

        @Override
        public int compare(ObjectKlass.KlassVersion k1, ObjectKlass.KlassVersion k2) {
            return Long.compare(k1.getKlass().getId(), k2.getKlass().getId());
        }
    };
    public static final Klass[] EMPTY_ARRAY = new Klass[0];
    static final DebugCounter KLASS_LOOKUP_METHOD_COUNT = DebugCounter.create("Klass.lookupMethod call count");
    static final DebugCounter KLASS_LOOKUP_FIELD_COUNT = DebugCounter.create("Klass.lookupField call count");
    static final DebugCounter KLASS_LOOKUP_DECLARED_METHOD_COUNT = DebugCounter.create("Klass.lookupDeclaredMethod call count");
    static final DebugCounter KLASS_LOOKUP_DECLARED_FIELD_COUNT = DebugCounter.create("Klass.lookupDeclaredField call count");
    protected Symbol<Symbol.Name> name;
    protected Symbol<Symbol.Type> type;
    private final long id;
    @CompilerDirectives.CompilationFinal
    private ArrayKlass arrayKlass;
    @CompilerDirectives.CompilationFinal
    private StaticObject espressoClass;
    @CompilerDirectives.CompilationFinal
    private Class<?> dispatch;
    @CompilerDirectives.CompilationFinal
    private int dispatchId = -1;
    @CompilerDirectives.CompilationFinal
    private StaticObject typeName;
    protected Object prepareThread;
    private final int modifiers;
    @CompilerDirectives.CompilationFinal
    private Symbol<Symbol.Name> runtimePackage;

    @NonIdempotent
    static EspressoLanguage getLang(Node node) {
        return EspressoLanguage.get(node);
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    final boolean hasMembers() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    final Object getMembers(boolean includeInternal) {
        EconomicSet members = EconomicSet.create();
        members.add((Object)STATIC_TO_CLASS);
        members.add((Object)"static");
        for (Method method : this.getDeclaredMethods()) {
            if (!method.isStatic() || !method.isPublic()) continue;
            members.add((Object)method.getInteropString());
        }
        if (this.getMeta()._void != this) {
            members.add((Object)ARRAY);
        }
        if (this.isArray()) {
            members.add((Object)COMPONENT);
        }
        if (this.getSuperKlass() != null) {
            members.add((Object)SUPER);
        }
        for (Member member : this.getDeclaredFields()) {
            if (!member.isPublic() || !member.isStatic()) continue;
            members.add((Object)((Field)member).getNameAsString());
        }
        return new KeysArray<String>((String[])members.toArray((Object[])new String[members.size()]));
    }

    protected static boolean isObjectKlass(Klass receiver) {
        return receiver instanceof ObjectKlass;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage
    public Object getMetaQualifiedName() {
        assert (this.isMetaObject());
        return this.getTypeName();
    }

    @ExportMessage
    Object getMetaSimpleName() {
        assert (this.isMetaObject());
        assert (this.getContext().isInitialized());
        return this.getMeta().java_lang_Class_getSimpleName.invokeDirect(this.mirror(), new Object[0]);
    }

    @ExportMessage
    boolean isMetaInstance(Object instance) {
        return instance instanceof StaticObject && InterpreterToVM.instanceOf((StaticObject)instance, this);
    }

    @ExportMessage
    boolean hasMetaParents() {
        if (this.isPrimitive()) {
            return false;
        }
        if (this.isInterface()) {
            return this.getSuperInterfaces().length > 0;
        }
        return this != this.getMeta().java_lang_Object;
    }

    @ExportMessage
    Object getMetaParents() throws UnsupportedMessageException {
        if (this.hasMetaParents()) {
            Klass[] result;
            if (this.isInterface()) {
                ObjectKlass[] superInterfaces = this.getSuperInterfaces();
                result = new Klass[superInterfaces.length];
                for (int i = 0; i < superInterfaces.length; ++i) {
                    result[i] = superInterfaces[i];
                }
            } else {
                ObjectKlass superKlass = this.getSuperKlass();
                ObjectKlass[] superInterfaces = this.getSuperInterfaces();
                result = new Klass[superInterfaces.length + 1];
                result[0] = superKlass;
                for (int i = 0; i < superInterfaces.length; ++i) {
                    result[i + 1] = superInterfaces[i];
                }
            }
            return new KeysArray<Klass>(result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    int identityHashCode() {
        return VM.JVM_IHashCode(this.mirror(), null);
    }

    public Class<?> getDispatch() {
        Class<?> result = this.dispatch;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (this.getMeta().getContext().metaInitialized()) {
                this.dispatch = result = this.getMeta().resolveDispatch(this);
                this.dispatchId = InteropKlassesDispatch.dispatchToId(result);
            } else {
                if (this.isPrimitive()) {
                    return BaseInterop.class;
                }
                return EspressoInterop.class;
            }
        }
        return result;
    }

    public int getDispatchId() {
        int result = this.dispatchId;
        if (result == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (this.getMeta().getContext().metaInitialized()) {
                this.dispatch = this.getMeta().resolveDispatch(this);
                result = this.dispatchId = InteropKlassesDispatch.dispatchToId(this.dispatch);
            } else {
                if (this.isPrimitive()) {
                    return 0;
                }
                return 1;
            }
        }
        return result;
    }

    protected static boolean hasFinalInstanceField(Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (java.lang.reflect.Field f : clazz.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAccess(Klass klass, ObjectKlass accessingKlass, boolean ignoreMagicAccessor) {
        if (accessingKlass == null) {
            return true;
        }
        if (klass == accessingKlass) {
            return true;
        }
        if (klass.isPrimitive()) {
            return true;
        }
        EspressoContext context = accessingKlass.getContext();
        if (context.getJavaVersion().modulesEnabled()) {
            if (klass.sameRuntimePackage(accessingKlass)) {
                return true;
            }
            if (klass.isPublic() && Klass.doModuleAccessChecks(klass, accessingKlass, context)) {
                return true;
            }
        } else if (klass.isPublic() || klass.sameRuntimePackage(accessingKlass)) {
            return true;
        }
        if (ignoreMagicAccessor) {
            ObjectKlass magicAccessorImpl = context.getMeta().sun_reflect_MagicAccessorImpl;
            return !StaticObject.isNull(accessingKlass.getDefiningClassLoader()) && context.getMeta().sun_reflect_DelegatingClassLoader.equals(accessingKlass.getDefiningClassLoader().getKlass()) && magicAccessorImpl.getRuntimePackage().equals(accessingKlass.getRuntimePackage()) && magicAccessorImpl.isAssignableFrom(accessingKlass);
        }
        return context.getMeta().sun_reflect_MagicAccessorImpl.isAssignableFrom(accessingKlass);
    }

    public static boolean doModuleAccessChecks(Klass klass, ObjectKlass accessingKlass, EspressoContext context) {
        ModuleTable.ModuleEntry moduleTo;
        ModuleTable.ModuleEntry moduleFrom = accessingKlass.module();
        if (moduleFrom == (moduleTo = klass.module())) {
            return true;
        }
        if (!moduleTo.isNamed() && (moduleFrom.canReadAllUnnamed() || moduleFrom.canRead(moduleTo, context))) {
            return true;
        }
        if (!moduleFrom.canRead(moduleTo, context)) {
            return false;
        }
        if (moduleTo.isOpen()) {
            return true;
        }
        PackageTable.PackageEntry packageTo = klass.packageEntry();
        if (packageTo.isUnqualifiedExported()) {
            return true;
        }
        return packageTo.isQualifiedExportTo(moduleFrom);
    }

    public ObjectKlass[] getSuperInterfaces() {
        return ObjectKlass.EMPTY_ARRAY;
    }

    Klass(EspressoContext context, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, int modifiers) {
        this(context, name, type, modifiers, -1L);
    }

    Klass(EspressoContext context, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, int modifiers, long possibleID) {
        super(context);
        this.name = name;
        this.type = type;
        this.id = possibleID >= 0L ? possibleID : context.getClassLoadingEnv().getNewKlassId();
        this.modifiers = modifiers;
        this.runtimePackage = this.initRuntimePackage();
    }

    @Override
    public abstract @JavaType(value=ClassLoader.class) StaticObject getDefiningClassLoader();

    public abstract ConstantPool getConstantPool();

    public final JavaKind getJavaKind() {
        return this instanceof PrimitiveKlass ? ((PrimitiveKlass)this).getPrimitiveJavaKind() : JavaKind.Object;
    }

    @Override
    public final boolean isArray() {
        return this instanceof ArrayKlass;
    }

    @Override
    @Idempotent
    public final boolean isInterface() {
        return ModifiersProvider.super.isInterface();
    }

    public final @JavaType(value=Class.class) StaticObject mirror() {
        StaticObject result = this.espressoClass;
        assert (result != null);
        assert (this.getMeta().java_lang_Class != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="espressoClass is deliberately non-volatile since it uses \"Unsafe Local DCL + Safe Singleton\" as described in https://shipilev.net/blog/2014/safe-public-construction\nA static hasFinalInstanceField(StaticObject.class) assertion ensures correctness.")
    public final StaticObject initializeEspressoClass() {
        CompilerAsserts.neverPartOfCompilation();
        StaticObject result = this.espressoClass;
        if (result == null) {
            Klass klass = this;
            synchronized (klass) {
                result = this.espressoClass;
                if (result == null) {
                    this.espressoClass = result = this.getAllocator().createClass(this);
                }
            }
        }
        return result;
    }

    private @JavaType(value=String.class) StaticObject computeTypeName() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.isArray()) {
            return this.getVM().JVM_GetClassName(this.mirror());
        }
        StaticObject elementalName = this.getVM().JVM_GetClassName(this.getElementalType().mirror());
        int dimensions = ((ArrayKlass)this).getDimension();
        String result = Meta.toHostStringStatic(elementalName) + "[]".repeat(dimensions);
        return this.getMeta().toGuestString(result);
    }

    public final @JavaType(value=String.class) StaticObject getTypeName() {
        if (this.typeName == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.typeName = this.computeTypeName();
        }
        assert (this.checkTypeName(this.typeName));
        return this.typeName;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean checkTypeName(@JavaType(value=String.class) StaticObject computedTypeName) {
        if (!this.getContext().isInitialized()) {
            return true;
        }
        StaticObject expected = (StaticObject)this.getMeta().java_lang_Class_getTypeName.invokeDirect(this.mirror(), new Object[0]);
        return this.getMeta().toHostString(computedTypeName).equals(this.getMeta().toHostString(expected));
    }

    public final ArrayKlass array() {
        return this.getArrayClass();
    }

    public final ArrayKlass getArrayClass() {
        ArrayKlass result = this.arrayKlass;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            result = this.createArrayKlass();
        }
        return result;
    }

    private synchronized ArrayKlass createArrayKlass() {
        CompilerAsserts.neverPartOfCompilation();
        ArrayKlass result = this.arrayKlass;
        if (result == null && Symbol.Type._void != this.getType()) {
            this.arrayKlass = result = new ArrayKlass(this);
        }
        return result;
    }

    @Override
    public ArrayKlass getArrayClass(int dimensions) {
        assert (dimensions > 0);
        ArrayKlass array = this.array();
        if (array == null) {
            return null;
        }
        for (int i = 1; i < dimensions; ++i) {
            array = array.getArrayClass();
        }
        return array;
    }

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return this.getType().hashCode();
    }

    @HostCompilerDirectives.InliningCutoff
    public final StaticObject tryInitializeAndGetStatics() {
        this.safeInitialize();
        return this.getStatics();
    }

    public final StaticObject getStatics() {
        if (this instanceof ObjectKlass) {
            return ((ObjectKlass)this).getStaticsImpl();
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Primitives/arrays do not have static fields");
    }

    public final boolean isInstanceClass() {
        return this instanceof ObjectKlass && !this.isInterface();
    }

    @Override
    public final boolean isPrimitive() {
        return this instanceof PrimitiveKlass;
    }

    public boolean hasNoSubtypes() {
        return this.getElementalType().isFinalFlagSet();
    }

    @Override
    public final boolean isFinalFlagSet() {
        return ModifiersProvider.super.isFinalFlagSet();
    }

    public final boolean isInitialized() {
        return !(this instanceof ObjectKlass) || ((ObjectKlass)this).isInitializedImpl();
    }

    public final boolean isInitializedOrInitializing() {
        if (!(this instanceof ObjectKlass)) {
            return true;
        }
        return ((ObjectKlass)this).isInitializingOrInitializedImpl();
    }

    public final void initialize() {
        if (this instanceof ObjectKlass) {
            ((ObjectKlass)this).initializeImpl();
        }
    }

    public void ensureLinked() {
    }

    public final boolean isAssignableFrom(Klass other) {
        if (this == other) {
            return true;
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            assert (this.getContext() == other.getContext());
            assert (this != other);
            return false;
        }
        if (this.isArray()) {
            if (other.isArray()) {
                return ((ArrayKlass)this).arrayTypeChecks((ArrayKlass)other);
            }
        } else if (this.isFinalFlagSet()) {
            assert (this != other);
            return false;
        }
        if (Modifier.isInterface(this.getModifiers())) {
            return this.checkInterfaceSubclassing(other);
        }
        return this.checkOrdinaryClassSubclassing(other);
    }

    public boolean checkOrdinaryClassSubclassing(Klass other) {
        int depth = this.getHierarchyDepth();
        return other.getHierarchyDepth() >= depth && other.getSuperTypes()[depth] == this;
    }

    public boolean checkInterfaceSubclassing(Klass other) {
        ObjectKlass.KlassVersion[] interfaces = other.getTransitiveInterfacesList();
        return Klass.fastLookup(this, interfaces) >= 0;
    }

    public final long getId() {
        return this.id;
    }

    public final Klass findLeastCommonAncestor(Klass other) {
        if (this.isPrimitive() || other.isPrimitive()) {
            if (this == other) {
                return this;
            }
            return null;
        }
        Klass[] thisHierarchy = this.getSuperTypes();
        Klass[] otherHierarchy = other.getSuperTypes();
        for (int i = Math.min(this.getHierarchyDepth(), other.getHierarchyDepth()); i >= 0; --i) {
            if (thisHierarchy[i] != otherHierarchy[i]) continue;
            return thisHierarchy[i];
        }
        throw EspressoError.shouldNotReachHere("Klasses should be either primitives, or have j.l.Object as common supertype.");
    }

    public final ObjectKlass getHostClass() {
        return this instanceof ObjectKlass ? ((ObjectKlass)this).getHostClassImpl() : null;
    }

    public final boolean isAnonymous() {
        return this.getHostClass() != null;
    }

    public final boolean isHidden() {
        return (this.getModifiers() & 0x4000000) != 0;
    }

    public boolean isJavaLangObject() {
        return this.getSuperKlass() == null && !this.isInterface() && this.getJavaKind() == JavaKind.Object;
    }

    public ObjectKlass getSuperKlass() {
        return null;
    }

    public Klass[] getImplementedInterfaces() {
        return this.getSuperInterfaces();
    }

    public abstract Klass getElementalType();

    public abstract boolean isLocal();

    public abstract boolean isMember();

    public abstract Klass getEnclosingType();

    public abstract Method[] getDeclaredConstructors();

    public abstract Method[] getDeclaredMethods();

    public abstract Method.MethodVersion[] getDeclaredMethodVersions();

    @Override
    public abstract MethodRef[] getDeclaredMethodRefs();

    public abstract Field[] getDeclaredFields();

    public Method getClassInitializer() {
        Method clinit = this.lookupDeclaredMethod(Symbol.Name._clinit_, Symbol.Signature._void);
        if (clinit != null && clinit.isStatic()) {
            return clinit;
        }
        return null;
    }

    public final Symbol<Symbol.Type> getType() {
        return this.type;
    }

    public String toString() {
        return "Klass<" + String.valueOf(this.getType()) + ">";
    }

    public void safeInitialize() {
        try {
            this.initialize();
        }
        catch (EspressoException e) {
            throw this.initializationFailed(e);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    protected final RuntimeException initializationFailed(EspressoException e) {
        StaticObject cause = e.getGuestException();
        Meta meta = this.getMeta();
        if (InterpreterToVM.instanceOf(cause, meta.java_lang_Error)) {
            throw e;
        }
        throw Klass.throwExceptionInInitializerError(meta, cause);
    }

    @CompilerDirectives.TruffleBoundary
    private static EspressoException throwExceptionInInitializerError(Meta meta, StaticObject cause) {
        throw meta.throwExceptionWithCause(meta.java_lang_ExceptionInInitializerError, cause);
    }

    public final Klass getSupertype() {
        if (this.isPrimitive()) {
            return null;
        }
        if (this.isArray()) {
            Klass component = ((ArrayKlass)this).getComponentType();
            if (this == this.getMeta().java_lang_Object.array() || component.isPrimitive()) {
                return this.getMeta().java_lang_Object;
            }
            return component.getSupertype().array();
        }
        if (this.isInterface()) {
            return this.getMeta().java_lang_Object;
        }
        return this.getSuperKlass();
    }

    public final boolean isPrimaryType() {
        assert (!this.isPrimitive());
        if (this.isArray()) {
            return this.getElementalType().isPrimaryType();
        }
        return !this.isInterface();
    }

    protected abstract Klass[] getSuperTypes();

    protected abstract int getHierarchyDepth();

    protected abstract ObjectKlass.KlassVersion[] getTransitiveInterfacesList();

    @CompilerDirectives.TruffleBoundary
    public StaticObject allocateReferenceArray(int length) {
        Meta meta = this.getMeta();
        GuestAllocator.AllocationChecks.checkCanAllocateArray(meta, length);
        return meta.getAllocator().createNewReferenceArray(this, length);
    }

    @CompilerDirectives.TruffleBoundary
    public StaticObject allocateReferenceArray(int length, IntFunction<StaticObject> generator) {
        Meta meta = this.getMeta();
        StaticObject[] array = new StaticObject[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.apply(i);
        }
        return meta.getAllocator().wrapArrayAs(this.getArrayClass(), array);
    }

    public final Field requireDeclaredField(Symbol<Symbol.Name> fieldName, Symbol<Symbol.Type> fieldType) {
        Field obj = this.lookupDeclaredField(fieldName, fieldType);
        if (obj == null) {
            throw EspressoError.shouldNotReachHere("Missing field: " + String.valueOf(fieldName) + ": " + String.valueOf(fieldType) + " in " + String.valueOf(this));
        }
        return obj;
    }

    @ExplodeLoop
    public final Field lookupDeclaredField(Symbol<Symbol.Name> fieldName, Symbol<Symbol.Type> fieldType) {
        KLASS_LOOKUP_DECLARED_FIELD_COUNT.inc();
        for (Field field : this.getDeclaredFields()) {
            if (!fieldName.equals(field.getName()) || !fieldType.equals(field.getType())) continue;
            return field;
        }
        return null;
    }

    public final Field lookupField(Symbol<Symbol.Name> fieldName, Symbol<Symbol.Type> fieldType) {
        return this.lookupField(fieldName, fieldType, LookupMode.ALL);
    }

    public final Field lookupField(Symbol<Symbol.Name> fieldName, Symbol<Symbol.Type> fieldType, LookupMode mode) {
        KLASS_LOOKUP_FIELD_COUNT.inc();
        Field field = this.lookupDeclaredField(fieldName, fieldType);
        if (mode.include(field)) {
            return field;
        }
        for (ObjectKlass superI : this.getSuperInterfaces()) {
            field = superI.lookupField(fieldName, fieldType, mode);
            if (!mode.include(field)) continue;
            return field;
        }
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.getSuperKlass() != null) {
            return this.getSuperKlass().lookupField(fieldName, fieldType, mode);
        }
        return null;
    }

    public final Field lookupFieldTable(int slot) {
        if (this instanceof ObjectKlass) {
            return ((ObjectKlass)this).lookupFieldTableImpl(slot);
        }
        return null;
    }

    public final Field lookupStaticFieldTable(int slot) {
        if (this instanceof ObjectKlass) {
            return ((ObjectKlass)this).lookupStaticFieldTableImpl(slot);
        }
        return null;
    }

    public final Method requireMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        Method obj = this.lookupMethod(methodName, signature);
        if (obj == null) {
            throw EspressoError.shouldNotReachHere("Missing method: " + String.valueOf(methodName) + ": " + String.valueOf(signature) + " starting at " + String.valueOf(this));
        }
        return obj;
    }

    public final Method requireDeclaredMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        Method obj = this.lookupDeclaredMethod(methodName, signature);
        if (obj == null) {
            throw EspressoError.shouldNotReachHere("Missing method: " + String.valueOf(methodName) + ": " + String.valueOf(signature) + " in " + String.valueOf(this));
        }
        return obj;
    }

    public final Method lookupDeclaredMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        return this.lookupDeclaredMethod(methodName, signature, LookupMode.ALL);
    }

    @ExplodeLoop
    public final Method lookupDeclaredMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, LookupMode lookupMode) {
        KLASS_LOOKUP_DECLARED_METHOD_COUNT.inc();
        for (Method method : this.getDeclaredMethods()) {
            if (!lookupMode.include(method) || !methodName.equals(method.getName()) || !signature.equals(method.getRawSignature())) continue;
            return method;
        }
        return null;
    }

    private static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        for (int i = 1; i < array.length; ++i) {
            if (comparator.compare(array[i - 1], array[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static int fastLookupBoundary(Klass target, ObjectKlass.KlassVersion[] klasses) {
        return Klass.fastLookupImpl(target, klasses);
    }

    protected static int fastLookup(Klass target, ObjectKlass.KlassVersion[] klasses) {
        if (!CompilerDirectives.isPartialEvaluationConstant((Object)klasses)) {
            return Klass.fastLookupBoundary(target, klasses);
        }
        CompilerAsserts.partialEvaluationConstant((Object)klasses);
        return Klass.fastLookupImpl(target, klasses);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected static int fastLookupImpl(Klass target, ObjectKlass.KlassVersion[] klasses) {
        assert (Klass.isSorted(klasses, KLASS_VERSION_ID_COMPARATOR));
        if (klasses.length <= 8) {
            for (int i = 0; i < klasses.length; ++i) {
                if (klasses[i].getKlass() != target) continue;
                return i;
            }
        } else {
            int lo = 0;
            int hi = klasses.length - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int cmp = KLASS_ID_COMPARATOR.compare(target, klasses[mid].getKlass());
                if (cmp < 0) {
                    hi = mid - 1;
                    continue;
                }
                if (cmp > 0) {
                    lo = mid + 1;
                    continue;
                }
                return mid;
            }
        }
        return -1;
    }

    public abstract Method lookupMethod(Symbol<Symbol.Name> var1, Symbol<Symbol.Signature> var2, LookupMode var3);

    public final Method lookupMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        return this.lookupMethod(methodName, signature, LookupMode.ALL);
    }

    public final Method vtableLookup(int vtableIndex) {
        if (this instanceof ObjectKlass) {
            return ((ObjectKlass)this).vtableLookupImpl(vtableIndex);
        }
        if (this instanceof ArrayKlass) {
            assert (this.getMeta().java_lang_Object == this.getSuperClass());
            return this.getMeta().java_lang_Object.vtableLookup(vtableIndex);
        }
        assert (this instanceof PrimitiveKlass);
        return null;
    }

    public Method lookupPolysigMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, LookupMode lookupMode) {
        Method m = this.lookupPolysignatureDeclaredMethod(methodName, lookupMode);
        if (m != null) {
            return this.findMethodHandleIntrinsic(m, signature);
        }
        return null;
    }

    public Method lookupPolysignatureDeclaredMethod(Symbol<Symbol.Name> methodName, LookupMode lookupMode) {
        for (Method m : this.getDeclaredMethods()) {
            if (!lookupMode.include(m) || m.getName() != methodName || !m.isSignaturePolymorphicDeclared()) continue;
            return m;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private Method findMethodHandleIntrinsic(Method m, Symbol<Symbol.Signature> signature) {
        assert (m.isSignaturePolymorphicDeclared());
        MethodHandleIntrinsics.PolySigIntrinsics iid = MethodHandleIntrinsics.getId(m);
        Symbol<Symbol.Signature> sig = signature;
        if (iid.isStaticPolymorphicSignature()) {
            sig = this.getSignatures().toBasic(signature, true);
        }
        return m.findIntrinsic(sig);
    }

    @Override
    public final int getModifiers() {
        return this.getModifiers(this.getContext());
    }

    public final int getModifiers(EspressoContext context) {
        if (this instanceof ObjectKlass && context.advancedRedefinitionEnabled()) {
            return this.getRedefinitionAwareModifiers();
        }
        return this.modifiers;
    }

    public int getRedefinitionAwareModifiers() {
        return this.getModifiers();
    }

    public abstract int getClassModifiers();

    @CompilerDirectives.TruffleBoundary
    public final StaticObject allocateInstance() {
        return this.allocateInstance(this.getContext());
    }

    public final StaticObject allocateInstance(EspressoContext ctx) {
        assert (this instanceof ObjectKlass);
        GuestAllocator.AllocationChecks.checkCanAllocateNewReference(ctx.getMeta(), this, false);
        return ctx.getAllocator().createNew((ObjectKlass)this);
    }

    private Symbol<Symbol.Name> initRuntimePackage() {
        ByteSequence hostPkgName = Types.getRuntimePackage(this.type);
        return this.getNames().getOrCreate(hostPkgName);
    }

    public Symbol<Symbol.Name> getRuntimePackage() {
        return this.runtimePackage;
    }

    public abstract ModuleTable.ModuleEntry module();

    public abstract PackageTable.PackageEntry packageEntry();

    public final boolean inUnnamedPackage() {
        return this.packageEntry() == null;
    }

    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    public String getExternalName() {
        String externalName = MetaUtil.internalNameToJava(this.type.toString(), true, true);
        if (this.isAnonymous()) {
            externalName = this.appendID(externalName);
        }
        if (this.isHidden()) {
            externalName = this.convertHidden(externalName);
        }
        return externalName;
    }

    @CompilerDirectives.TruffleBoundary
    private String appendID(String externalName) {
        return externalName + "/" + this.getId();
    }

    @CompilerDirectives.TruffleBoundary
    protected String convertHidden(String externalName) {
        int idx = externalName.lastIndexOf(43);
        char[] chars = externalName.toCharArray();
        chars[idx] = 47;
        return new String(chars);
    }

    public boolean sameRuntimePackage(Klass other) {
        if (this.getDefiningClassLoader() != other.getDefiningClassLoader()) {
            return false;
        }
        if (this.getJavaVersion().modulesEnabled()) {
            return this.packageEntry() == other.packageEntry();
        }
        return this.getRuntimePackage().equals(other.getRuntimePackage());
    }

    public final boolean isTypeMapped() {
        if (this.typeConversionState == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.computeTypeConversionState();
        }
        return this.typeConversionState == 1;
    }

    private void computeTypeConversionState() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.typeConversionState == -1);
        this.typeConversionState = this.getContext().getPolyglotTypeMappings().mapTypeConversion(this) != null ? (byte)1 : (this.getContext().getPolyglotTypeMappings().mapInternalTypeConversion(this) != null ? (byte)2 : (this.getContext().getPolyglotTypeMappings().mapEspressoForeignCollection(this) != null ? (byte)4 : (byte)0));
    }

    public final boolean isInternalTypeMapped() {
        if (this.typeConversionState == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.computeTypeConversionState();
        }
        return this.typeConversionState == 2;
    }

    public final boolean isInternalCollectionTypeMapped() {
        if (this.typeConversionState == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.computeTypeConversionState();
        }
        return this.typeConversionState == 4;
    }

    @Override
    public String getNameAsString() {
        return this.name.toString();
    }

    @Override
    public String getTypeAsString() {
        return this.type.toString();
    }

    @Override
    public String getGenericTypeAsString() {
        return "";
    }

    @Override
    public Object getPrepareThread() {
        if (this.prepareThread == null) {
            this.prepareThread = this.getContext().getMainThread();
        }
        return this.prepareThread;
    }

    @Override
    public int getStatus() {
        if (this instanceof ObjectKlass) {
            ObjectKlass objectKlass = (ObjectKlass)this;
            int status = 0;
            if (objectKlass.isErroneous()) {
                return 8;
            }
            if (objectKlass.isPrepared()) {
                status |= 2;
            }
            if (objectKlass.isVerified()) {
                status |= 1;
            }
            if (objectKlass.isInitializedImpl()) {
                status |= 4;
            }
            return status;
        }
        return 7;
    }

    @Override
    public KlassRef getSuperClass() {
        return this.getSuperKlass();
    }

    @Override
    public byte getTagConstant() {
        return this.getJavaKind().toTagConstant();
    }

    @Override
    public boolean isAssignable(KlassRef klass) {
        return this.isAssignableFrom((Klass)klass);
    }

    @Override
    public Object getKlassObject() {
        return this.mirror();
    }

    public Klass nest() {
        return this;
    }

    public boolean nestMembersCheck(Klass k) {
        return false;
    }

    public StaticObject protectionDomain() {
        return (StaticObject)this.getMeta().HIDDEN_PROTECTION_DOMAIN.getHiddenObject(this.mirror());
    }

    public Klass[] getNestMembers() {
        return EMPTY_ARRAY;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public JDWPConstantPool getJDWPConstantPool() {
        ConstantPool pool = this.getConstantPool();
        return new JDWPConstantPool(pool.length(), pool.getRawBytes());
    }

    @Override
    public String getSourceDebugExtension() {
        return null;
    }

    @Override
    public final ModuleRef getModule() {
        return this.module();
    }

    public Assumption getRedefineAssumption() {
        return Assumption.ALWAYS_VALID;
    }

    static {
        assert (Klass.hasFinalInstanceField(ArrayKlass.class));
    }

    public static enum LookupMode {
        ALL(true, true),
        INSTANCE_ONLY(true, false),
        STATIC_ONLY(false, true);

        private final boolean instances;
        private final boolean statics;

        private LookupMode(boolean instances, boolean statics) {
            this.instances = instances;
            this.statics = statics;
        }

        public boolean include(Member<?> m) {
            if (m == null) {
                return false;
            }
            if (this.statics && m.isStatic()) {
                return true;
            }
            return this.instances && !m.isStatic();
        }
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doKlass(Klass receiver, Klass other) {
            return receiver == other ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(Klass receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static abstract class Instantiate {
        static final String INIT_NAME = Symbol.Name._init_.toString();

        Instantiate() {
        }

        @Specialization(guards={"language.isShared()"})
        static Object doShared(Klass receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary receiverInterop, @Bind(value="$node") Node node, @Bind(value="getLang(receiverInterop)") EspressoLanguage language) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            if (receiver.isPrimitive()) {
                return Instantiate.doPrimitive(receiver, args);
            }
            if (Instantiate.isPrimitiveArray(receiver)) {
                return Instantiate.doPrimitiveArray(receiver, args, ToPrimitiveFactory.ToIntNodeGen.getUncached());
            }
            if (Instantiate.isReferenceArray(receiver)) {
                return Instantiate.doReferenceArray(receiver, args, ToPrimitiveFactory.ToIntNodeGen.getUncached());
            }
            if (Instantiate.isMultidimensionalArray(receiver)) {
                return Instantiate.doMultidimensionalArray(receiver, args, node, InlinedBranchProfile.getUncached(), ToPrimitiveFactory.ToIntNodeGen.getUncached());
            }
            if (Klass.isObjectKlass(receiver)) {
                return Instantiate.doObject(receiver, args, node, InlinedBranchProfile.getUncached(), receiverInterop, InteropLookupAndInvokeFactory.NonVirtualNodeGen.getUncached());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }

        @Specialization(guards={"receiver.isPrimitive()"})
        static Object doPrimitive(Klass receiver, Object[] arguments) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        private static int convertLength(Object argument, ToPrimitive.ToInt toInt) throws UnsupportedTypeException {
            int length = 0;
            try {
                length = (Integer)toInt.execute(argument);
            }
            catch (UnsupportedTypeException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{argument}, (String)"Expected a single int");
            }
            if (length < 0) {
                throw UnsupportedTypeException.create((Object[])new Object[]{argument}, (String)"Expected a non-negative length");
            }
            return length;
        }

        private static int getLength(Object[] arguments, ToPrimitive.ToInt toInt) throws UnsupportedTypeException, ArityException {
            if (arguments.length != 1) {
                throw ArityException.create((int)1, (int)1, (int)arguments.length);
            }
            return Instantiate.convertLength(arguments[0], toInt);
        }

        protected static boolean isPrimitiveArray(Klass receiver) {
            return receiver instanceof ArrayKlass && ((ArrayKlass)receiver).getComponentType().isPrimitive();
        }

        protected static boolean isReferenceArray(Klass receiver) {
            return receiver instanceof ArrayKlass && ((ArrayKlass)receiver).getComponentType() instanceof ObjectKlass;
        }

        protected static boolean isMultidimensionalArray(Klass receiver) {
            return receiver instanceof ArrayKlass && ((ArrayKlass)receiver).getComponentType().isArray();
        }

        @Specialization(guards={"isPrimitiveArray(receiver)"})
        static StaticObject doPrimitiveArray(Klass receiver, Object[] arguments, @Cached ToPrimitive.ToInt toInt) throws ArityException, UnsupportedTypeException {
            ArrayKlass arrayKlass = (ArrayKlass)receiver;
            assert (arrayKlass.getComponentType().getJavaKind() != JavaKind.Void);
            EspressoContext context = EspressoContext.get(toInt);
            int length = Instantiate.getLength(arguments, toInt);
            GuestAllocator.AllocationChecks.checkCanAllocateArray(context.getMeta(), length);
            return context.getAllocator().createNewPrimitiveArray(arrayKlass.getComponentType(), length);
        }

        @Specialization(guards={"isReferenceArray(receiver)"})
        static StaticObject doReferenceArray(Klass receiver, Object[] arguments, @Cached ToPrimitive.ToInt toInt) throws UnsupportedTypeException, ArityException {
            ArrayKlass arrayKlass = (ArrayKlass)receiver;
            EspressoContext context = EspressoContext.get(toInt);
            int length = Instantiate.getLength(arguments, toInt);
            GuestAllocator.AllocationChecks.checkCanAllocateArray(context.getMeta(), length);
            return context.getAllocator().createNewReferenceArray(arrayKlass.getComponentType(), length);
        }

        @Specialization(guards={"isMultidimensionalArray(receiver)"})
        static StaticObject doMultidimensionalArray(Klass receiver, Object[] arguments, @Bind(value="$node") Node node, @Cached InlinedBranchProfile error, @Cached ToPrimitive.ToInt toInt) throws ArityException, UnsupportedTypeException {
            ArrayKlass arrayKlass = (ArrayKlass)receiver;
            assert (arrayKlass.getElementalType().getJavaKind() != JavaKind.Void);
            if (arrayKlass.getDimension() != arguments.length) {
                error.enter(node);
                throw ArityException.create((int)arrayKlass.getDimension(), (int)arrayKlass.getDimension(), (int)arguments.length);
            }
            EspressoContext context = EspressoContext.get(toInt);
            int[] dimensions = new int[arguments.length];
            for (int i = 0; i < dimensions.length; ++i) {
                dimensions[i] = Instantiate.convertLength(arguments[i], toInt);
            }
            GuestAllocator.AllocationChecks.checkCanAllocateMultiArray(context.getMeta(), arrayKlass.getComponentType(), dimensions);
            return context.getAllocator().createNewMultiArray(arrayKlass.getComponentType(), dimensions);
        }

        @Specialization(guards={"isObjectKlass(receiver)"})
        static Object doObject(Klass receiver, Object[] arguments, @Bind(value="$node") Node node, @Cached InlinedBranchProfile error, @CachedLibrary(value="receiver") InteropLibrary receiverInterop, @Cached InteropLookupAndInvoke.NonVirtual lookupAndInvoke) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            if (!receiverInterop.isInstantiable((Object)receiver)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            ObjectKlass objectKlass = (ObjectKlass)receiver;
            StaticObject instance = Instantiate.allocateNewInstance(EspressoContext.get(lookupAndInvoke), objectKlass);
            lookupAndInvoke.execute(instance, objectKlass, arguments, INIT_NAME);
            return instance;
        }

        private static StaticObject allocateNewInstance(EspressoContext context, ObjectKlass objectKlass) {
            GuestAllocator.AllocationChecks.checkCanAllocateNewReference(context.getMeta(), objectKlass, false);
            return context.getAllocator().createNew(objectKlass);
        }
    }

    @ExportMessage
    static abstract class IsInstantiable {
        IsInstantiable() {
        }

        @Specialization(guards={"receiver.isPrimitive()"})
        static boolean doPrimitive(Klass receiver) {
            return false;
        }

        @Specialization(guards={"isObjectKlass(receiver)"})
        static boolean doObject(Klass receiver) {
            if (receiver.isAbstract()) {
                return false;
            }
            for (Method m : receiver.getDeclaredMethods()) {
                if (!m.isPublic() || m.isStatic() || !m.getName().equals(Symbol.Name._init_)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"receiver.isArray()"})
        static boolean doArray(Klass receiver) {
            assert (receiver.getElementalType().getJavaKind() != JavaKind.Void);
            return true;
        }
    }

    @ExportMessage
    static abstract class InvokeMember {
        InvokeMember() {
        }

        @Specialization(guards={"language.isShared()"})
        static Object doShared(Klass receiver, String member, Object[] arguments, @Bind(value="$node") Node node, @Cached @Cached.Shared InlinedBranchProfile error, @CachedLibrary(value="receiver") InteropLibrary receiverInterop, @Bind(value="getLang(receiverInterop)") EspressoLanguage language) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
            return InvokeMember.invokeMember(receiver, member, arguments, node, receiverInterop, error, InteropLookupAndInvokeFactory.NonVirtualNodeGen.getUncached());
        }

        @Specialization
        static Object invokeMember(Klass receiver, String member, Object[] arguments, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverInterop, @Cached InlinedBranchProfile error, @Cached InteropLookupAndInvoke.NonVirtual lookupAndInvoke) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
            if (!receiverInterop.isMemberInvocable((Object)receiver, member)) {
                error.enter(node);
                throw UnknownIdentifierException.create((String)member);
            }
            return lookupAndInvoke.execute(null, receiver, arguments, member);
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"language.isShared()"})
        static boolean doShared(Klass receiver, String member, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="getLang(lib)") EspressoLanguage language) {
            return IsMemberInvocable.isMemberInvocable(receiver, member, LookupDeclaredMethodNodeGen.getUncached());
        }

        @Specialization
        static boolean isMemberInvocable(Klass receiver, String member, @Cached.Shared(value="lookupMethod") @Cached LookupDeclaredMethod lookupMethod) {
            return lookupMethod.isInvocable(receiver, member, true);
        }
    }

    @ExportMessage
    static abstract class WriteMember {
        WriteMember() {
        }

        @Specialization(guards={"language.isShared()"})
        static void doShared(Klass receiver, String member, Object value, @Bind(value="$node") Node node, @Cached @Cached.Shared InlinedBranchProfile error, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="getLang(lib)") EspressoLanguage language) throws UnknownIdentifierException, UnsupportedTypeException {
            WriteMember.writeMember(receiver, member, value, LookupFieldNodeGen.getUncached(), ToEspressoNodeFactory.DynamicToEspressoNodeGen.getUncached(), node, error);
        }

        @Specialization
        static void writeMember(Klass receiver, String member, Object value, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupFieldNode, @Cached.Exclusive @Cached ToEspressoNode.DynamicToEspresso toEspressoNode, @Bind(value="$node") Node node, @Cached @Cached.Shared InlinedBranchProfile error) throws UnknownIdentifierException, UnsupportedTypeException {
            Field field = lookupFieldNode.execute(receiver, member, true);
            if (field == null || field.isFinalFlagSet()) {
                error.enter(node);
                throw UnknownIdentifierException.create((String)member);
            }
            Object espressoValue = toEspressoNode.execute(value, field.resolveTypeKlass());
            field.set(receiver.tryInitializeAndGetStatics(), espressoValue);
        }
    }

    @ExportMessage
    static abstract class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"language.isShared()"})
        static boolean doShared(Klass receiver, String member, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="getLang(lib)") EspressoLanguage language) {
            return IsMemberModifiable.isMemberModifiable(receiver, member, LookupFieldNodeGen.getUncached());
        }

        @Specialization
        static boolean isMemberModifiable(Klass receiver, String member, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField) {
            Field field = lookupField.execute(receiver, member, true);
            return field != null && !field.isFinalFlagSet();
        }
    }

    @ExportMessage
    static abstract class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"language.isShared()"})
        static Object doShared(Klass receiver, String member, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="$node") Node node, @Cached @Cached.Shared InlinedBranchProfile error, @Bind(value="getLang(lib)") EspressoLanguage language) throws UnknownIdentifierException {
            return ReadMember.readMember(receiver, member, LookupFieldNodeGen.getUncached(), LookupDeclaredMethodNodeGen.getUncached(), node, error, lib, language);
        }

        @Specialization
        static Object readMember(Klass receiver, String member, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupFieldNode, @Cached.Shared(value="lookupMethod") @Cached LookupDeclaredMethod lookupMethod, @Bind(value="$node") Node node, @Cached @Cached.Shared InlinedBranchProfile error, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="getLang(lib)") EspressoLanguage language) throws UnknownIdentifierException {
            EspressoContext ctx = EspressoContext.get((Node)lib);
            Meta meta = ctx.getMeta();
            Field field = lookupFieldNode.execute(receiver, member, true);
            if (field != null) {
                Object result = field.get(receiver.tryInitializeAndGetStatics());
                if (result instanceof StaticObject) {
                    result = InteropUtils.unwrap(language, (StaticObject)result, meta);
                }
                return result;
            }
            try {
                Method[] candidates = lookupMethod.execute(receiver, member, true, true, -1);
                if (candidates != null && candidates.length == 1) {
                    return EspressoFunction.createStaticInvocable(candidates[0]);
                }
            }
            catch (ArityException arityException) {
                // empty catch block
            }
            if (Klass.STATIC_TO_CLASS.equals(member)) {
                return receiver.mirror();
            }
            if ("static".equals(member)) {
                return receiver;
            }
            if (meta._void != receiver && Klass.ARRAY.equals(member)) {
                return receiver.array();
            }
            if (receiver.isArray() && Klass.COMPONENT.equals(member)) {
                return ((ArrayKlass)receiver).getComponentType();
            }
            if (receiver.getSuperKlass() != null && Klass.SUPER.equals(member)) {
                return receiver.getSuperKlass();
            }
            error.enter(node);
            throw UnknownIdentifierException.create((String)member);
        }
    }

    @ExportMessage
    static abstract class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"language.isShared()"})
        static boolean doShared(Klass receiver, String member, @CachedLibrary(value="receiver") InteropLibrary lib, @Bind(value="getLang(lib)") EspressoLanguage language) {
            return IsMemberReadable.isMemberReadable(receiver, member, LookupFieldNodeGen.getUncached(), lib);
        }

        @Specialization
        static boolean isMemberReadable(Klass receiver, String member, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @CachedLibrary(value="receiver") InteropLibrary lib) {
            EspressoContext ctx = EspressoContext.get((Node)lib);
            Field field = lookupField.execute(receiver, member, true);
            if (field != null) {
                return true;
            }
            if (lib.isMemberInvocable((Object)receiver, member)) {
                return true;
            }
            if (Klass.STATIC_TO_CLASS.equals(member)) {
                return true;
            }
            if ("static".equals(member)) {
                return true;
            }
            if (ctx.getMeta()._void != receiver && Klass.ARRAY.equals(member)) {
                return true;
            }
            if (receiver.isArray() && Klass.COMPONENT.equals(member)) {
                return true;
            }
            return receiver.getSuperKlass() != null && Klass.SUPER.equals(member);
        }
    }
}

