/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCloseable;
import com.oracle.truffle.espresso.perf.DebugTimer;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

final class LoadingConstraints
extends ContextAccessImpl {
    private static DebugTimer CONSTRAINTS = DebugTimer.create("constraints");
    private static final long NULL_KLASS_ID = -1L;
    static final long INVALID_LOADER_ID = -1L;
    private final PurgeInfo info = new PurgeInfo();
    private final ConcurrentHashMap<Symbol<Symbol.Type>, ConstraintBucket> pairings = new ConcurrentHashMap();

    LoadingConstraints(EspressoContext context) {
        super(context);
    }

    void checkConstraint(Symbol<Symbol.Type> type, StaticObject loader1, StaticObject loader2) {
        try (DebugCloseable constraints = CONSTRAINTS.scope(this.getContext().getTimers());){
            Klass k1 = this.getContext().getRegistries().findLoadedClass(type, loader1);
            Klass k2 = this.getContext().getRegistries().findLoadedClass(type, loader2);
            this.checkOrAdd(type, LoadingConstraints.getKlassID(k1), LoadingConstraints.getKlassID(k2), LoadingConstraints.getLoaderID(loader1, this.getMeta()), LoadingConstraints.getLoaderID(loader2, this.getMeta()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordConstraint(Symbol<Symbol.Type> type, Klass k, StaticObject loader) {
        long loaderID = LoadingConstraints.getLoaderID(loader, this.getMeta());
        long klass = LoadingConstraints.getKlassID(k);
        ConstraintBucket bucket = this.lookup(type);
        if (bucket == null) {
            bucket = new ConstraintBucket();
            Constraint newConstraint = Constraint.create(klass, loaderID);
            bucket.add(newConstraint);
            ConstraintBucket previous = this.pairings.putIfAbsent(type, bucket);
            if (previous != null) {
                bucket = this.lookup(type);
            }
        }
        ConstraintBucket constraintBucket = bucket;
        synchronized (constraintBucket) {
            Constraint constraint = bucket.lookupLoader(loaderID);
            if (constraint == null) {
                constraint = bucket.lookupKlass(klass);
                if (constraint == null) {
                    bucket.add(Constraint.create(klass, loaderID));
                } else {
                    constraint.add(loaderID);
                }
            } else {
                this.checkConstraint(klass, constraint);
            }
        }
    }

    void removeUnloadedKlassConstraint(Klass klass, Symbol<Symbol.Type> type) {
        long loaderId = LoadingConstraints.getLoaderID(klass.getDefiningClassLoader(), this.getMeta());
        long klassId = LoadingConstraints.getKlassID(klass);
        ConstraintBucket bucket = this.lookup(type);
        Constraint toRemove = bucket.lookupLoader(loaderId);
        bucket.remove(toRemove);
        toRemove = bucket.lookupKlass(klassId);
        if (toRemove != null) {
            bucket.remove(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge() {
        long[] alive = this.getContext().getRegistries().aliveLoaders();
        this.info.emptyBuckets = 0;
        Iterator<ConstraintBucket> iterator = this.pairings.values().iterator();
        while (iterator.hasNext()) {
            ConstraintBucket bucket;
            ConstraintBucket constraintBucket = bucket = iterator.next();
            synchronized (constraintBucket) {
                bucket.purge(alive, this.info);
                if (bucket.constraint == null) {
                    ++this.info.emptyBuckets;
                }
            }
        }
        this.getContext().getLogger().log(Level.FINE, "purging constraints stats:\nreclaimed slots: " + this.info.reclaimedSlots + "\nreclaimed constraints: " + this.info.reclaimedConstraints + "\nempty buckets: " + this.info.emptyBuckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOrAdd(Symbol<Symbol.Type> type, long k1, long k2, long loader1, long loader2) {
        if (LoadingConstraints.exists(k1) && LoadingConstraints.exists(k2) && k1 != k2) {
            throw this.linkageError("Loading constraint violated !");
        }
        long klass = !LoadingConstraints.exists(k1) ? k2 : k1;
        ConstraintBucket bucket = this.lookup(type);
        if (bucket == null) {
            bucket = new ConstraintBucket();
            bucket.add(Constraint.create(klass, loader1, loader2));
            ConstraintBucket previous = this.pairings.putIfAbsent(type, bucket);
            if (previous != null) {
                bucket = this.lookup(type);
            }
        }
        ConstraintBucket constraintBucket = bucket;
        synchronized (constraintBucket) {
            Constraint c1 = bucket.lookupLoader(loader1);
            klass = this.checkConstraint(klass, c1);
            Constraint c2 = bucket.lookupLoader(loader2);
            klass = this.checkConstraint(klass, c2);
            if (c1 == null && c2 == null) {
                bucket.add(Constraint.create(klass, loader1, loader2));
            } else if (c1 != c2) {
                if (c1 == null) {
                    c2.add(loader1);
                    if (!LoadingConstraints.exists(c2.klass)) {
                        c2.klass = klass;
                    }
                } else if (c2 == null) {
                    c1.add(loader2);
                    if (!LoadingConstraints.exists(c1.klass)) {
                        c1.klass = klass;
                    }
                } else {
                    LoadingConstraints.mergeConstraints(bucket, c1, c2);
                }
            }
        }
    }

    private ConstraintBucket lookup(Symbol<Symbol.Type> type) {
        return this.pairings.get(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long checkConstraint(long klass, Constraint c1) {
        if (c1 == null) return klass;
        if (LoadingConstraints.exists(c1.klass)) {
            if (!LoadingConstraints.exists(klass)) return c1.klass;
            if (klass == c1.klass) return klass;
            throw this.linkageError("New loading constraint violates an older one!");
        }
        c1.klass = klass;
        return klass;
    }

    private static void mergeConstraints(ConstraintBucket bucket, Constraint c1, Constraint c2) {
        Constraint delete;
        Constraint merge;
        if (c1.loaders.length < c2.loaders.length) {
            merge = c2;
            delete = c1;
        } else {
            merge = c1;
            delete = c2;
        }
        merge.merge(delete);
        bucket.remove(delete);
    }

    private LinkageError linkageError(String message) {
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_LinkageError, message);
    }

    private static long getLoaderID(StaticObject loader, Meta meta) {
        if (StaticObject.isNull(loader)) {
            return meta.getContext().getBootClassLoaderID();
        }
        ClassRegistry classRegistry = (ClassRegistry)meta.HIDDEN_CLASS_LOADER_REGISTRY.getHiddenObject(loader, true);
        if (classRegistry == null) {
            throw EspressoError.shouldNotReachHere();
        }
        return classRegistry.getLoaderID();
    }

    private static long getKlassID(Klass k) {
        return k == null ? -1L : k.getId();
    }

    private static boolean exists(long klass) {
        return klass != -1L;
    }

    private static class PurgeInfo {
        int reclaimedSlots = 0;
        int reclaimedConstraints = 0;
        int emptyBuckets = 0;

        private PurgeInfo() {
        }
    }

    private static final class ConstraintBucket {
        private Constraint constraint;

        private ConstraintBucket() {
        }

        Constraint lookupLoader(long loader) {
            Constraint curr = this.constraint;
            while (curr != null) {
                if (curr.contains(loader)) {
                    return curr;
                }
                curr = curr.next;
            }
            return null;
        }

        Constraint lookupKlass(long klass) {
            Constraint curr = this.constraint;
            while (curr != null) {
                if (curr.klass == klass) {
                    return curr;
                }
                curr = curr.next;
            }
            return null;
        }

        void add(Constraint newConstraint) {
            newConstraint.next = this.constraint;
            newConstraint.prev = null;
            if (this.constraint != null) {
                this.constraint.prev = newConstraint;
            }
            this.constraint = newConstraint;
        }

        void remove(Constraint toRemove) {
            Constraint prev = toRemove.prev;
            Constraint next = toRemove.next;
            if (prev != null) {
                prev.next = next;
            }
            if (next != null) {
                next.prev = prev;
            }
            if (toRemove == this.constraint) {
                this.constraint = next;
            }
        }

        void purge(long[] alive, PurgeInfo info) {
            assert (Thread.holdsLock(this));
            Constraint curr = this.constraint;
            while (curr != null) {
                curr.purge(alive, info);
                if (curr.size == 0) {
                    this.remove(curr);
                    ++info.reclaimedConstraints;
                }
                curr = curr.next;
            }
        }
    }

    private static final class Constraint {
        private long klass;
        private static final int DEFAULT_INITIAL_SIZE = 2;
        private long[] loaders = new long[2];
        private int size = 0;
        private int capacity = 2;
        Constraint prev;
        Constraint next;

        boolean contains(long loader) {
            for (int i = 0; i < this.size; ++i) {
                if (this.loaders[i] != loader) continue;
                return true;
            }
            return false;
        }

        void merge(Constraint other) {
            for (long loader : other.loaders) {
                if (this.contains(loader)) continue;
                this.add(loader);
            }
        }

        Constraint(long k) {
            this.klass = k;
        }

        void add(long loader) {
            assert (!this.contains(loader));
            if (this.size >= this.capacity) {
                this.loaders = Arrays.copyOf(this.loaders, this.capacity <<= 1);
            }
            this.loaders[this.size++] = loader;
        }

        public void purge(long[] alive, PurgeInfo info) {
            int i = 0;
            while (i < this.size) {
                if (!Constraint.isAlive(this.loaders[i], alive)) {
                    Constraint.swap(i, --this.size, this.loaders);
                    ++info.reclaimedSlots;
                    continue;
                }
                ++i;
            }
            if (this.size > 0 && this.size < this.capacity >> 1 && this.capacity > 2) {
                int shift = 1;
                while (this.size < this.capacity >> shift + 1) {
                    ++shift;
                }
                this.capacity = Math.max(2, this.capacity >> shift);
                long[] newLoaders = new long[this.capacity];
                System.arraycopy(this.loaders, 0, newLoaders, 0, this.size);
                this.loaders = newLoaders;
            }
        }

        static void swap(int i, int j, long[] loaders) {
            long a = loaders[i];
            loaders[i] = loaders[j];
            loaders[j] = a;
        }

        static boolean isAlive(long loader, long[] alive) {
            for (int i = 0; i < alive.length; ++i) {
                long live = alive[i];
                if (live == -1L) {
                    return false;
                }
                if (live != loader) continue;
                return true;
            }
            return false;
        }

        static Constraint create(long klass, long loader1, long loader2) {
            if (loader1 == loader2) {
                return Constraint.create(klass, loader1);
            }
            Constraint constraint = new Constraint(klass);
            constraint.add(loader1);
            constraint.add(loader2);
            return constraint;
        }

        static Constraint create(long klass, long loader) {
            Constraint constraint = new Constraint(klass);
            constraint.add(loader);
            return constraint;
        }
    }
}

