/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import java.util.Arrays;

public abstract class AbstractBreakpointInfo
implements BreakpointInfo {
    private final RequestFilter filter;
    private Breakpoint[] breakpoints = new Breakpoint[0];
    private byte suspendPolicy;

    public AbstractBreakpointInfo(RequestFilter filter) {
        this.filter = filter;
    }

    @Override
    public void addBreakpoint(Breakpoint bp) {
        this.breakpoints = Arrays.copyOf(this.breakpoints, this.breakpoints.length + 1);
        this.breakpoints[this.breakpoints.length - 1] = bp;
    }

    @Override
    public Breakpoint[] getBreakpoints() {
        return this.breakpoints;
    }

    @Override
    public RequestFilter getFilter() {
        return this.filter;
    }

    @Override
    public int getRequestId() {
        return this.filter.getRequestId();
    }

    @Override
    public byte getEventKind() {
        return this.filter.getEventKind();
    }

    @Override
    public void addSuspendPolicy(byte policy) {
        this.suspendPolicy = policy;
    }

    @Override
    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    @Override
    public KlassRef getKlass() {
        return null;
    }

    @Override
    public boolean isCaught() {
        return false;
    }

    @Override
    public boolean isUnCaught() {
        return false;
    }

    @Override
    public Object getThread() {
        return null;
    }

    @Override
    public long getClassId() {
        return 0L;
    }

    @Override
    public long getMethodId() {
        return 0L;
    }

    @Override
    public byte getTypeTag() {
        return 0;
    }

    @Override
    public long getBci() {
        return 0L;
    }

    @Override
    public boolean isExceptionBreakpoint() {
        return false;
    }
}

