/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.api.FieldRef;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.VMEventListener;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.ClassPrepareRequest;
import com.oracle.truffle.espresso.jdwp.impl.CommandResult;
import com.oracle.truffle.espresso.jdwp.impl.Commands;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.ExceptionBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.FieldBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.LineBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.MethodBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.Packet;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.StepInfo;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class RequestedJDWPEvents {
    public static final byte SINGLE_STEP = 1;
    public static final byte BREAKPOINT = 2;
    public static final byte FRAME_POP = 3;
    public static final byte EXCEPTION = 4;
    public static final byte USER_DEFINED = 5;
    public static final byte THREAD_START = 6;
    public static final byte THREAD_DEATH = 7;
    public static final byte CLASS_PREPARE = 8;
    public static final byte CLASS_UNLOAD = 9;
    public static final byte CLASS_LOAD = 10;
    public static final byte FIELD_ACCESS = 20;
    public static final byte FIELD_MODIFICATION = 21;
    public static final byte EXCEPTION_CATCH = 30;
    public static final byte METHOD_ENTRY = 40;
    public static final byte METHOD_EXIT = 41;
    public static final byte METHOD_EXIT_WITH_RETURN_VALUE = 42;
    public static final byte MONITOR_CONTENDED_ENTER = 43;
    public static final byte MONITOR_CONTENDED_ENTERED = 44;
    public static final byte MONITOR_WAIT = 45;
    public static final byte MONITOR_WAITED = 46;
    public static final byte VM_START = 90;
    public static final byte VM_DEATH = 99;
    public static final byte VM_DISCONNECTED = 100;
    private final VMEventListener eventListener;
    private final DebuggerController controller;
    private final Ids<Object> ids;

    RequestedJDWPEvents(DebuggerController controller) {
        this.controller = controller;
        this.eventListener = controller.getEventListener();
        this.ids = controller.getContext().getIds();
    }

    public CommandResult registerEvent(Packet packet, Commands callback) {
        ArrayList<Callable<Void>> preFutures = new ArrayList<Callable<Void>>();
        ArrayList<Callable<Void>> postFutures = new ArrayList<Callable<Void>>();
        PacketStream input = new PacketStream(packet);
        JDWPContext context = this.controller.getContext();
        byte eventKind = input.readByte();
        byte suspendPolicy = input.readByte();
        int modifiers = input.readInt();
        RequestFilter filter = new RequestFilter(packet.id, eventKind, suspendPolicy);
        this.controller.fine(() -> "New event request with ID: " + packet.id + " with kind: " + eventKind + " and modifiers: " + modifiers);
        for (int i = 0; i < modifiers; ++i) {
            byte modKind = input.readByte();
            this.controller.fine(() -> "Handling modKind: " + modKind);
            this.handleModKind(filter, input, modKind, context);
        }
        switch (eventKind) {
            case 1: {
                StepInfo stepInfo = filter.getStepInfo();
                Object thread = stepInfo.getGuestThread();
                switch (stepInfo.getDepth()) {
                    case 0: {
                        callback.stepInto(thread, filter);
                        break;
                    }
                    case 1: {
                        callback.stepOver(thread, filter);
                        break;
                    }
                    case 2: {
                        callback.stepOut(thread, filter);
                    }
                }
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                MethodBreakpointInfo methodInfo = new MethodBreakpointInfo(filter);
                methodInfo.addSuspendPolicy(suspendPolicy);
                this.eventListener.addBreakpointRequest(filter.getRequestId(), methodInfo);
                for (KlassRef klass : filter.getKlassRefPatterns()) {
                    for (MethodRef method : klass.getDeclaredMethodRefs()) {
                        method.addMethodHook(methodInfo);
                        methodInfo.addMethod(method);
                    }
                }
                filter.addBreakpointInfo(methodInfo);
                break;
            }
            case 2: {
                BreakpointInfo info = filter.getBreakpointInfo();
                info.addSuspendPolicy(suspendPolicy);
                this.eventListener.addBreakpointRequest(filter.getRequestId(), info);
                postFutures.add(callback.createLineBreakpointCommand(info));
                break;
            }
            case 4: {
                BreakpointInfo info = filter.getBreakpointInfo();
                if (info == null) {
                    info = new ExceptionBreakpointInfo(filter, null, true, true);
                }
                info.addSuspendPolicy(suspendPolicy);
                this.eventListener.addBreakpointRequest(filter.getRequestId(), info);
                preFutures.add(callback.createExceptionBreakpoint(info));
                this.controller.fine(() -> "Submitting new exception breakpoint");
                break;
            }
            case 8: {
                this.eventListener.addClassPrepareRequest(new ClassPrepareRequest(filter));
                this.controller.fine(() -> "Class prepare request received");
                break;
            }
            case 20: {
                FieldBreakpointInfo fieldBreakpointInfo = (FieldBreakpointInfo)filter.getBreakpointInfo();
                fieldBreakpointInfo.addSuspendPolicy(suspendPolicy);
                fieldBreakpointInfo.setAccessBreakpoint();
                fieldBreakpointInfo.getField().addFieldBreakpointInfo(fieldBreakpointInfo);
                String location = fieldBreakpointInfo.getKlass().getNameAsString() + "." + fieldBreakpointInfo.getField().getNameAsString();
                this.controller.fine(() -> "Submitting field access breakpoint: " + location);
                break;
            }
            case 21: {
                FieldBreakpointInfo fieldBreakpointInfo = (FieldBreakpointInfo)filter.getBreakpointInfo();
                fieldBreakpointInfo.addSuspendPolicy(suspendPolicy);
                fieldBreakpointInfo.setModificationBreakpoint();
                fieldBreakpointInfo.getField().addFieldBreakpointInfo(fieldBreakpointInfo);
                String location = fieldBreakpointInfo.getKlass().getNameAsString() + "." + fieldBreakpointInfo.getField().getNameAsString();
                this.controller.fine(() -> "Submitting field modification breakpoint: " + location);
                break;
            }
            case 6: {
                this.eventListener.addThreadStartedRequestId(packet.id, suspendPolicy);
                break;
            }
            case 7: {
                this.eventListener.addThreadDiedRequestId(packet.id, suspendPolicy);
                break;
            }
            case 9: {
                this.eventListener.addClassUnloadRequestId(packet.id);
                break;
            }
            case 90: {
                this.eventListener.addVMStartRequest(packet.id);
                break;
            }
            case 99: {
                this.eventListener.addVMDeathRequest(packet.id, suspendPolicy);
                break;
            }
            case 43: {
                this.eventListener.addMonitorContendedEnterRequest(packet.id, filter);
                break;
            }
            case 44: {
                this.eventListener.addMonitorContendedEnteredRequest(packet.id, filter);
                break;
            }
            case 45: {
                this.eventListener.addMonitorWaitRequest(packet.id, filter);
                break;
            }
            case 46: {
                this.eventListener.addMonitorWaitedRequest(packet.id, filter);
                break;
            }
            default: {
                this.controller.fine(() -> "unhandled event kind " + eventKind);
            }
        }
        this.controller.getEventFilters().addFilter(filter);
        return new CommandResult(RequestedJDWPEvents.toReply(packet), preFutures, postFutures);
    }

    private static PacketStream toReply(Packet packet) {
        PacketStream reply = new PacketStream().replyPacket().id(packet.id);
        reply.writeInt(packet.id);
        return reply;
    }

    private void handleModKind(RequestFilter filter, PacketStream input, byte modKind, JDWPContext context) {
        switch (modKind) {
            case 1: {
                int count = input.readInt();
                this.controller.fine(() -> "adding count limit: " + count + " to filter");
                filter.addEventCount(count);
                break;
            }
            case 2: {
                this.controller.fine(() -> "unhandled modKind 2");
                break;
            }
            case 3: {
                long threadId = input.readLong();
                Object thread = this.ids.fromId((int)threadId);
                filter.addThread(thread);
                this.controller.fine(() -> "limiting to thread: " + context.getThreadName(thread));
                break;
            }
            case 4: {
                long refTypeId = input.readLong();
                KlassRef finalKlass = (KlassRef)this.ids.fromId((int)refTypeId);
                filter.addRefTypeLimit(finalKlass);
                this.controller.fine(() -> "RefType limit: " + String.valueOf(finalKlass));
                break;
            }
            case 5: {
                String classPattern = Pattern.quote(input.readString()).replace("*", "\\E.*\\Q");
                try {
                    Pattern pattern = Pattern.compile(classPattern);
                    filter.addPositivePattern(pattern);
                    this.controller.fine(() -> "adding positive refType pattern: " + pattern.pattern());
                    break;
                }
                catch (PatternSyntaxException ex) {
                    throw new RuntimeException("should not reach here");
                }
            }
            case 6: {
                String classPattern = Pattern.quote(input.readString()).replace("*", "\\E.*\\Q");
                try {
                    Pattern pattern = Pattern.compile(classPattern);
                    filter.addExcludePattern(pattern);
                    this.controller.fine(() -> "adding negative refType pattern: " + pattern.pattern());
                    break;
                }
                catch (PatternSyntaxException ex) {
                    throw new RuntimeException("should not reach here");
                }
            }
            case 7: {
                byte typeTag = input.readByte();
                long classId = input.readLong();
                long methodId = input.readLong();
                long bci = input.readLong();
                KlassRef finalKlass2 = (KlassRef)this.ids.fromId((int)classId);
                String slashName = finalKlass2.getTypeAsString();
                MethodRef method = (MethodRef)this.ids.fromId((int)methodId);
                int line = method.bciToLineNumber((int)bci);
                LineBreakpointInfo info = new LineBreakpointInfo(filter, typeTag, classId, methodId, bci, slashName, line);
                filter.addBreakpointInfo(info);
                this.controller.fine(() -> "Adding breakpoint info for location: " + finalKlass2.getNameAsString() + "." + method.getNameAsString() + "." + line);
                break;
            }
            case 8: {
                long refTypeId = input.readLong();
                KlassRef klass = null;
                if (refTypeId != 0L) {
                    klass = (KlassRef)this.ids.fromId((int)refTypeId);
                }
                boolean caught = input.readBoolean();
                boolean unCaught = input.readBoolean();
                ExceptionBreakpointInfo exceptionBreakpointInfo = new ExceptionBreakpointInfo(filter, klass, caught, unCaught);
                filter.addBreakpointInfo(exceptionBreakpointInfo);
                this.controller.fine(() -> "adding exception filter: caught=" + caught + ", uncaught=" + unCaught);
                break;
            }
            case 9: {
                long refTypeId = input.readLong();
                long fieldId = input.readLong();
                KlassRef klass = (KlassRef)this.ids.fromId((int)refTypeId);
                FieldRef field = (FieldRef)this.ids.fromId((int)fieldId);
                FieldBreakpointInfo fieldBreakpointInfo = new FieldBreakpointInfo(filter, klass, field);
                filter.addBreakpointInfo(fieldBreakpointInfo);
                this.controller.fine(() -> "limiting to field: " + field.getNameAsString());
                break;
            }
            case 10: {
                long threadId = input.readLong();
                Object thread = this.ids.fromId((int)threadId);
                int size = input.readInt();
                int depth = input.readInt();
                StepInfo stepInfo = new StepInfo(size, depth, thread);
                filter.setStepInfo(stepInfo);
                this.controller.fine(() -> "Step command: size= " + size + ", depth=" + depth);
                break;
            }
            case 11: {
                long thisId = input.readLong();
                this.controller.fine(() -> "adding instance filter for object ID: " + thisId);
                filter.addThisFilterId(thisId);
                break;
            }
            case 12: {
                this.controller.fine(() -> "unhandled modKind 12");
                break;
            }
        }
    }

    public CommandResult clearRequest(Packet packet) {
        PacketStream reply;
        block17: {
            block15: {
                block16: {
                    reply = new PacketStream().id(packet.id).replyPacket();
                    PacketStream input = new PacketStream(packet);
                    byte eventKind = input.readByte();
                    int requestId = input.readInt();
                    RequestFilter requestFilter = this.controller.getEventFilters().getRequestFilter(requestId);
                    if (requestFilter == null) break block15;
                    byte kind = requestFilter.getEventKind();
                    if (kind != eventKind) break block16;
                    switch (eventKind) {
                        case 1: {
                            this.controller.fine(() -> "Clearing step command: " + requestId);
                            this.controller.clearStepCommand(requestFilter.getStepInfo());
                            break;
                        }
                        case 41: 
                        case 42: {
                            MethodBreakpointInfo methodInfo = (MethodBreakpointInfo)requestFilter.getBreakpointInfo();
                            for (MethodRef method : methodInfo.getMethods()) {
                                method.removedMethodHook(requestFilter.getRequestId());
                            }
                            break block17;
                        }
                        case 2: 
                        case 4: 
                        case 40: {
                            this.eventListener.removeBreakpointRequest(requestFilter.getRequestId());
                            break;
                        }
                        case 20: 
                        case 21: {
                            FieldBreakpointInfo info = (FieldBreakpointInfo)requestFilter.getBreakpointInfo();
                            info.getField().removeFieldBreakpointInfo(requestFilter.getRequestId());
                            break;
                        }
                        case 8: {
                            this.eventListener.removeClassPrepareRequest(requestFilter.getRequestId());
                            break;
                        }
                        case 6: {
                            this.eventListener.removeThreadStartedRequestId();
                            break;
                        }
                        case 7: {
                            this.eventListener.removeThreadDiedRequestId();
                            break;
                        }
                        case 9: {
                            this.eventListener.addClassUnloadRequestId(packet.id);
                            break;
                        }
                        case 43: {
                            this.eventListener.removeMonitorContendedEnterRequest(requestId);
                            break;
                        }
                        case 44: {
                            this.eventListener.removeMonitorContendedEnteredRequest(requestId);
                            break;
                        }
                        case 45: {
                            this.eventListener.removeMonitorWaitRequest(requestId);
                            break;
                        }
                        case 46: {
                            this.eventListener.removeMonitorWaitedRequest(requestId);
                            break;
                        }
                        default: {
                            this.controller.fine(() -> "unhandled event clear kind " + eventKind);
                            break;
                        }
                    }
                    break block17;
                }
                reply.errorCode(102);
                break block17;
            }
            reply.errorCode(102);
        }
        return new CommandResult(reply);
    }

    public CommandResult clearAllRequests(Packet packet) {
        PacketStream reply = new PacketStream().id(packet.id).replyPacket();
        this.eventListener.clearAllBreakpointRequests();
        this.controller.clearBreakpoints();
        return new CommandResult(reply);
    }
}

