/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import java.util.concurrent.Callable;

public final class ThreadJob<T> {
    private final Object jobLock = new Object();
    private final Object thread;
    private final Callable<T> callable;
    private final byte suspensionStrategy;
    private boolean resultAvailable;
    private JobResult<T> result;

    public ThreadJob(Object guestThread, Callable<T> task) {
        this(guestThread, task, 1);
    }

    public ThreadJob(Object guestThread, Callable<T> task, byte suspensionStrategy) {
        this.thread = guestThread;
        this.callable = task;
        this.suspensionStrategy = suspensionStrategy;
    }

    public Object getThread() {
        return this.thread;
    }

    public byte getSuspensionStrategy() {
        return this.suspensionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        this.result = new JobResult();
        try {
            this.result.setResult(this.callable.call());
        }
        catch (Throwable e) {
            this.result.setException(e);
        }
        finally {
            this.resultAvailable = true;
            Object object = this.jobLock;
            synchronized (object) {
                this.jobLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResult<T> getResult() {
        while (!this.resultAvailable && !Thread.currentThread().isInterrupted()) {
            Object object = this.jobLock;
            synchronized (object) {
                try {
                    this.jobLock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.result;
    }

    public class JobResult<C> {
        private C result;
        private Throwable exception;

        public C getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        private void setResult(C obj) {
            this.result = obj;
        }

        private void setException(Throwable throwable) {
            this.exception = throwable;
        }
    }
}

