/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Validation;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jni.Handle;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.jni.JniImpl;
import com.oracle.truffle.espresso.jni.JniImplCollector;
import com.oracle.truffle.espresso.jni.JniVersion;
import com.oracle.truffle.espresso.jni.ModifiedUtf8;
import com.oracle.truffle.espresso.jni.NativeEnv;
import com.oracle.truffle.espresso.jni.NoSafepoint;
import com.oracle.truffle.espresso.jni.VarArgs;
import com.oracle.truffle.espresso.jni.WeakHandles;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.bytecodes.ArrayLength;
import com.oracle.truffle.espresso.nodes.bytecodes.ArrayLengthFactory;
import com.oracle.truffle.espresso.nodes.bytecodes.BooleanArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.BooleanArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.BooleanArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.BooleanArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.ByteArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.ByteArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.ByteArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.ByteArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.CharArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.CharArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.CharArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.CharArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.ShortArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.ShortArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.bytecodes.ShortArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.ShortArrayStoreNodeGen;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.GenerateNativeEnv;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Substitutions;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@GenerateNativeEnv(target=JniImpl.class)
public final class JniEnv
extends NativeEnv {
    private static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", JniEnv.class);
    public static final int JNI_OK = 0;
    public static final int JNI_ERR = -1;
    public static final int JNI_EDETACHED = -2;
    public static final int JNI_EVERSION = -3;
    public static final int JNI_COMMIT = 1;
    public static final int JNI_ABORT = 2;
    public static final int JVM_INTERFACE_VERSION_8 = 4;
    public static final int JVM_INTERFACE_VERSION_11 = 6;
    public static final int JNI_TRUE = 1;
    public static final int JNI_FALSE = 0;
    public static final int JNIInvalidRefType = 0;
    public static final int JNILocalRefType = 1;
    public static final int JNIGlobalRefType = 2;
    public static final int JNIWeakGlobalRefType = 3;
    private static final int MAX_JNI_LOCAL_CAPACITY = 65536;
    private final JNIHandles handles;
    @CompilerDirectives.CompilationFinal
    private JniVersion jniVersion;
    private @Pointer TruffleObject jniEnvPtr;
    private final TruffleObject nespressoLibrary;
    private final @Pointer TruffleObject initializeNativeContext;
    private final @Pointer TruffleObject disposeNativeContext;
    private final @Pointer TruffleObject popBoolean;
    private final @Pointer TruffleObject popByte;
    private final @Pointer TruffleObject popChar;
    private final @Pointer TruffleObject popShort;
    private final @Pointer TruffleObject popInt;
    private final @Pointer TruffleObject popFloat;
    private final @Pointer TruffleObject popDouble;
    private final @Pointer TruffleObject popLong;
    private final @Pointer TruffleObject popObject;
    private final @Pointer TruffleObject getSizeMax;
    private static final List<CallableFromNative.Factory> JNI_IMPL_FACTORIES = JniImplCollector.getInstances(CallableFromNative.Factory.class);
    private final WeakHandles<com.oracle.truffle.espresso.impl.Field> fieldIds = new WeakHandles();
    private final WeakHandles<Method> methodIds = new WeakHandles();
    private long cachedSizeMax = 0L;
    private final Map<Long, ByteBuffer> nativeBuffers = new ConcurrentHashMap<Long, ByteBuffer>();

    @Override
    protected List<CallableFromNative.Factory> getCollector() {
        return JNI_IMPL_FACTORIES;
    }

    @Override
    protected JniEnv jni() {
        return this;
    }

    public StaticObject getPendingException() {
        return this.getContext().getLanguage().getThreadLocalState().getPendingExceptionObject();
    }

    public EspressoException getPendingEspressoException() {
        return this.getContext().getLanguage().getThreadLocalState().getPendingException();
    }

    public void clearPendingException() {
        this.getContext().getLanguage().getThreadLocalState().clearPendingException();
    }

    public void setPendingException(StaticObject ex) {
        Meta meta = this.getMeta();
        assert (StaticObject.notNull(ex) && meta.java_lang_Throwable.isAssignableFrom(ex.getKlass()));
        this.setPendingException(EspressoException.wrap(ex, meta));
    }

    public void setPendingException(EspressoException ex) {
        this.getContext().getLanguage().getThreadLocalState().setPendingException(ex);
    }

    @Override
    protected TruffleLogger getLogger() {
        return LOGGER;
    }

    public Object[] popVarArgs(@Pointer TruffleObject varargsPtr, Symbol<Symbol.Type>[] signature) {
        VarArgsImpl varargs = new VarArgsImpl(varargsPtr);
        int paramCount = Signatures.parameterCount(signature);
        Object[] args = new Object[paramCount];
        block11: for (int i = 0; i < paramCount; ++i) {
            JavaKind kind = Signatures.parameterKind(signature, i);
            switch (kind) {
                case Boolean: {
                    args[i] = varargs.popBoolean();
                    continue block11;
                }
                case Byte: {
                    args[i] = varargs.popByte();
                    continue block11;
                }
                case Short: {
                    args[i] = varargs.popShort();
                    continue block11;
                }
                case Char: {
                    args[i] = Character.valueOf(varargs.popChar());
                    continue block11;
                }
                case Int: {
                    args[i] = varargs.popInt();
                    continue block11;
                }
                case Float: {
                    args[i] = Float.valueOf(varargs.popFloat());
                    continue block11;
                }
                case Long: {
                    args[i] = varargs.popLong();
                    continue block11;
                }
                case Double: {
                    args[i] = varargs.popDouble();
                    continue block11;
                }
                case Object: {
                    args[i] = varargs.popObject();
                    continue block11;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("invalid parameter kind: " + String.valueOf((Object)kind));
                }
            }
        }
        return args;
    }

    private JniEnv(EspressoContext context) {
        super(context);
        Path espressoLibraryPath = context.getEspressoLibs();
        this.nespressoLibrary = this.getNativeAccess().loadLibrary(Collections.singletonList(espressoLibraryPath), "nespresso", true);
        this.initializeNativeContext = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "initializeNativeContext", NativeSignature.create(NativeType.POINTER, NativeType.POINTER));
        this.disposeNativeContext = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "disposeNativeContext", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.POINTER));
        this.getSizeMax = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "get_SIZE_MAX", NativeSignature.create(NativeType.LONG, new NativeType[0]));
        assert (this.sizeMax() > Integer.MAX_VALUE) : "size_t must be 64-bit wide";
        this.popBoolean = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_boolean", NativeSignature.create(NativeType.BOOLEAN, NativeType.POINTER));
        this.popByte = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_byte", NativeSignature.create(NativeType.BYTE, NativeType.POINTER));
        this.popChar = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_char", NativeSignature.create(NativeType.CHAR, NativeType.POINTER));
        this.popShort = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_short", NativeSignature.create(NativeType.SHORT, NativeType.POINTER));
        this.popInt = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_int", NativeSignature.create(NativeType.INT, NativeType.POINTER));
        this.popFloat = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_float", NativeSignature.create(NativeType.FLOAT, NativeType.POINTER));
        this.popDouble = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_double", NativeSignature.create(NativeType.DOUBLE, NativeType.POINTER));
        this.popLong = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_long", NativeSignature.create(NativeType.LONG, NativeType.POINTER));
        this.popObject = this.getNativeAccess().lookupAndBindSymbol(this.nespressoLibrary, "pop_object", NativeSignature.create(NativeType.OBJECT, NativeType.POINTER));
        this.jniEnvPtr = this.initializeAndGetEnv(this.initializeNativeContext, new Object[0]);
        assert (this.getUncached().isPointer((Object)this.jniEnvPtr));
        this.handles = new JNIHandles();
        assert (this.jniEnvPtr != null && !this.getUncached().isNull((Object)this.jniEnvPtr));
    }

    @Override
    protected String getName() {
        return "JniEnv";
    }

    @Override
    public JNIHandles getHandles() {
        return this.handles;
    }

    @CompilerDirectives.TruffleBoundary
    private ByteBuffer allocateDirect(int capacity, JavaKind kind) {
        return this.allocateDirect(Math.multiplyExact(capacity, kind.getByteCount()));
    }

    @CompilerDirectives.TruffleBoundary
    private ByteBuffer allocateDirect(int capacity) {
        ByteBuffer bb = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        long address = NativeUtils.byteBufferAddress(bb);
        this.nativeBuffers.put(address, bb);
        return bb;
    }

    public static JniEnv create(EspressoContext context) {
        return new JniEnv(context);
    }

    public @Pointer TruffleObject getNativePointer() {
        return this.jniEnvPtr;
    }

    public void dispose() {
        if (this.jniEnvPtr == null || this.getUncached().isNull((Object)this.jniEnvPtr)) {
            return;
        }
        try {
            this.getUncached().execute((Object)this.disposeNativeContext, new Object[]{this.jniEnvPtr, RawPointer.nullInstance()});
            this.jniEnvPtr = null;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Cannot dispose Espresso native interface");
        }
        assert (this.jniEnvPtr == null || this.getUncached().isNull((Object)this.jniEnvPtr));
    }

    public long sizeMax() {
        long result = this.cachedSizeMax;
        if (result == 0L) {
            try {
                result = (Long)this.getUncached().execute((Object)this.getSizeMax, new Object[0]);
                if (result < 0L) {
                    result = Long.MAX_VALUE;
                }
                this.cachedSizeMax = result;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long GetFieldID(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject namePtr, @Pointer TruffleObject typePtr) {
        Symbol<Symbol.Type> fieldType;
        String name = NativeUtils.interopPointerToString(namePtr);
        String type = NativeUtils.interopPointerToString(typePtr);
        assert (name != null && type != null);
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        ModifiersProvider field = null;
        Symbol<Symbol.Name> fieldName = this.getNames().lookup(name);
        if (fieldName != null && (fieldType = this.getTypes().lookup(type)) != null) {
            klass.safeInitialize();
            field = klass.lookupField(fieldName, fieldType);
            assert (field == null || ((com.oracle.truffle.espresso.impl.Field)field).getType().equals(fieldType));
        }
        if (field == null || field.isStatic()) {
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, name);
        }
        assert (!field.isStatic());
        return this.fieldIds.handlify((com.oracle.truffle.espresso.impl.Field)field);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long GetStaticFieldID(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject namePtr, @Pointer TruffleObject typePtr) {
        Symbol<Symbol.Type> fieldType;
        String name = NativeUtils.interopPointerToString(namePtr);
        String type = NativeUtils.interopPointerToString(typePtr);
        assert (name != null && type != null);
        ModifiersProvider field = null;
        Symbol<Symbol.Name> fieldName = this.getNames().lookup(name);
        if (fieldName != null && (fieldType = this.getTypes().lookup(type)) != null) {
            Klass klass = clazz.getMirrorKlass(this.getMeta());
            klass.safeInitialize();
            field = klass.lookupField(fieldName, fieldType, Klass.LookupMode.STATIC_ONLY);
            assert (field == null || ((com.oracle.truffle.espresso.impl.Field)field).getType().equals(fieldType));
        }
        if (field == null || !field.isStatic()) {
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, name);
        }
        return this.fieldIds.handlify((com.oracle.truffle.espresso.impl.Field)field);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Handle(value=Method.class) long GetMethodID(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject namePtr, @Pointer TruffleObject signaturePtr) {
        Symbol<Symbol.Signature> methodSignature;
        String name = NativeUtils.interopPointerToString(namePtr);
        String signature = NativeUtils.interopPointerToString(signaturePtr);
        assert (name != null && signature != null);
        ModifiersProvider method = null;
        Symbol<Symbol.Name> methodName = this.getNames().lookup(name);
        if (methodName != null && (methodSignature = this.getSignatures().lookupValidSignature(signature)) != null) {
            Klass klass = clazz.getMirrorKlass(this.getMeta());
            klass.safeInitialize();
            method = klass.lookupMethod(methodName, methodSignature);
        }
        if (method == null || method.isStatic()) {
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, name);
        }
        return this.methodIds.handlify((Method)method);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Handle(value=Method.class) long GetStaticMethodID(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject namePtr, @Pointer TruffleObject signaturePtr) {
        Symbol<Symbol.Signature> methodSignature;
        String name = NativeUtils.interopPointerToString(namePtr);
        String signature = NativeUtils.interopPointerToString(signaturePtr);
        assert (name != null && signature != null);
        ModifiersProvider method = null;
        Symbol<Symbol.Name> methodName = this.getNames().lookup(name);
        if (methodName != null && (methodSignature = this.getSignatures().lookupValidSignature(signature)) != null) {
            Klass klass = clazz.getMirrorKlass(this.getMeta());
            if (klass.isPrimitive()) {
                Meta meta = this.getMeta();
                throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, name);
            }
            klass.safeInitialize();
            method = Symbol.Name._clinit_.equals(methodName) ? klass.lookupDeclaredMethod(methodName, methodSignature) : klass.lookupMethod(methodName, methodSignature);
        }
        if (method == null || !method.isStatic()) {
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, name);
        }
        return this.methodIds.handlify((Method)method);
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject GetStaticObjectField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsObject(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics());
    }

    @JniImpl
    public boolean GetStaticBooleanField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsBoolean(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public byte GetStaticByteField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsByte(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public char GetStaticCharField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsChar(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public short GetStaticShortField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsShort(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public int GetStaticIntField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsInt(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public long GetStaticLongField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsLong(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public float GetStaticFloatField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsFloat(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public double GetStaticDoubleField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        return field.getAsDouble(this.getMeta(), field.getDeclaringKlass().tryInitializeAndGetStatics(), false);
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject GetObjectField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsObject(this.getMeta(), object);
    }

    @JniImpl
    public boolean GetBooleanField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsBoolean(this.getMeta(), object, false);
    }

    @JniImpl
    public byte GetByteField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsByte(this.getMeta(), object, false);
    }

    @JniImpl
    public char GetCharField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsChar(this.getMeta(), object, false);
    }

    @JniImpl
    public short GetShortField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsShort(this.getMeta(), object, false);
    }

    @JniImpl
    public int GetIntField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsInt(this.getMeta(), object, false);
    }

    @JniImpl
    public long GetLongField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsLong(this.getMeta(), object, false);
    }

    @JniImpl
    public float GetFloatField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsFloat(this.getMeta(), object, false);
    }

    @JniImpl
    public double GetDoubleField(@JavaType(value=Object.class) StaticObject object, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        return field.getAsDouble(this.getMeta(), object, false);
    }

    @JniImpl
    public void SetStaticObjectField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, @JavaType(value=Object.class) StaticObject val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticBooleanField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, boolean val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticByteField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, byte val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticCharField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, char val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), Character.valueOf(val));
    }

    @JniImpl
    public void SetStaticShortField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, short val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticIntField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, int val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticLongField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, long val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetStaticFloatField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, float val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), Float.valueOf(val));
    }

    @JniImpl
    public void SetStaticDoubleField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, double val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.isStatic());
        field.set(field.getDeclaringKlass().tryInitializeAndGetStatics(), val);
    }

    @JniImpl
    public void SetObjectField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, @JavaType(value=Object.class) StaticObject val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetBooleanField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, boolean val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetByteField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, byte val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetCharField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, char val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, Character.valueOf(val));
    }

    @JniImpl
    public void SetShortField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, short val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetIntField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, int val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetLongField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, long val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    @JniImpl
    public void SetFloatField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, float val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, Float.valueOf(val));
    }

    @JniImpl
    public void SetDoubleField(@JavaType(value=Object.class) StaticObject obj, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, double val) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        field.set(obj, val);
    }

    private Object callVirtualMethodGeneric(StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        assert (!receiver.getKlass().isInterface());
        Method resolutionSeed = this.methodIds.getObject(methodId);
        assert (!resolutionSeed.isStatic());
        assert (resolutionSeed.getDeclaringKlass().isAssignableFrom(receiver.getKlass()));
        Object[] args = this.popVarArgs(varargsPtr, resolutionSeed.getParsedSignature());
        Method target = resolutionSeed.getDeclaringKlass().isInterface() ? (!resolutionSeed.isPrivate() && !resolutionSeed.isStatic() ? ((ObjectKlass)receiver.getKlass()).itableLookup(resolutionSeed.getDeclaringKlass(), resolutionSeed.getITableIndex()) : resolutionSeed) : (resolutionSeed.isConstructor() ? resolutionSeed : (resolutionSeed.isVirtualCall() ? receiver.getKlass().vtableLookup(resolutionSeed.getVTableIndex()) : resolutionSeed));
        assert (target != null);
        assert (target.getName() == resolutionSeed.getName() && resolutionSeed.getRawSignature() == target.getRawSignature());
        return target.invokeDirect(receiver, args);
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject CallObjectMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asObject(result);
    }

    @JniImpl
    public boolean CallBooleanMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asBoolean(result, true);
    }

    @JniImpl
    public char CallCharMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asChar(result, true);
    }

    @JniImpl
    public byte CallByteMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asByte(result, true);
    }

    @JniImpl
    public short CallShortMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asShort(result, true);
    }

    @JniImpl
    public int CallIntMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asInt(result, true);
    }

    @JniImpl
    public float CallFloatMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asFloat(result, true);
    }

    @JniImpl
    public double CallDoubleMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asDouble(result, true);
    }

    @JniImpl
    public long CallLongMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        return this.getMeta().asLong(result, true);
    }

    @JniImpl
    public void CallVoidMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Object result = this.callVirtualMethodGeneric(receiver, methodId, varargsPtr);
        assert (result instanceof StaticObject && StaticObject.isNull((StaticObject)result)) : "void methods must return StaticObject.NULL";
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject CallNonvirtualObjectMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asObject(result);
    }

    @JniImpl
    public boolean CallNonvirtualBooleanMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asBoolean(result, true);
    }

    @JniImpl
    public char CallNonvirtualCharMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asChar(result, true);
    }

    @JniImpl
    public byte CallNonvirtualByteMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asByte(result, true);
    }

    @JniImpl
    public short CallNonvirtualShortMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asShort(result, true);
    }

    @JniImpl
    public int CallNonvirtualIntMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asInt(result, true);
    }

    @JniImpl
    public float CallNonvirtualFloatMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asFloat(result, true);
    }

    @JniImpl
    public double CallNonvirtualDoubleMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asDouble(result, true);
    }

    @JniImpl
    public long CallNonvirtualLongMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asLong(result, true);
    }

    @JniImpl
    public void CallNonvirtualVoidMethodVarargs(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (!method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(receiver, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        assert (result instanceof StaticObject && StaticObject.isNull((StaticObject)result)) : "void methods must return StaticObject.NULL";
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject CallStaticObjectMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asObject(result);
    }

    @JniImpl
    public boolean CallStaticBooleanMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asBoolean(result, true);
    }

    @JniImpl
    public char CallStaticCharMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asChar(result, true);
    }

    @JniImpl
    public byte CallStaticByteMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asByte(result, true);
    }

    @JniImpl
    public short CallStaticShortMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asShort(result, true);
    }

    @JniImpl
    public int CallStaticIntMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asInt(result, true);
    }

    @JniImpl
    public float CallStaticFloatMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asFloat(result, true);
    }

    @JniImpl
    public double CallStaticDoubleMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asDouble(result, true);
    }

    @JniImpl
    public long CallStaticLongMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return this.getMeta().asLong(result, true);
    }

    @JniImpl
    public void CallStaticVoidMethodVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isStatic());
        assert (clazz.getMirrorKlass(this.getMeta()) == method.getDeclaringKlass());
        Object result = method.invokeDirect(null, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        assert (result instanceof StaticObject && StaticObject.isNull((StaticObject)result)) : "void methods must return StaticObject.NULL";
    }

    @JniImpl
    public @JavaType(value=boolean[].class) StaticObject NewBooleanArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Boolean.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=byte[].class) StaticObject NewByteArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Byte.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=char[].class) StaticObject NewCharArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Char.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=short[].class) StaticObject NewShortArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Short.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=int[].class) StaticObject NewIntArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Int.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=long[].class) StaticObject NewLongArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Long.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=float[].class) StaticObject NewFloatArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Float.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=double[].class) StaticObject NewDoubleArray(int len) {
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), (byte)JavaKind.Double.getBasicType(), len);
    }

    @JniImpl
    public @JavaType(value=Object[].class) StaticObject NewObjectArray(int length, @JavaType(value=Class.class) StaticObject elementClass, @JavaType(value=Object.class) StaticObject initialElement, @Inject EspressoLanguage language) {
        assert (!elementClass.getMirrorKlass(this.getMeta()).isPrimitive());
        StaticObject arr = elementClass.getMirrorKlass(this.getMeta()).allocateReferenceArray(length);
        if (length > 0) {
            this.getInterpreterToVM().setArrayObject(language, initialElement, 0, arr);
            Arrays.fill((Object[])arr.unwrap(language), initialElement);
        }
        return arr;
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetBooleanArrayRegion(@JavaType(value=boolean[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        if (array.isEspressoObject()) {
            byte[] contents = (byte[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            BooleanArrayLoad.WithoutNullCheck arrayLoadNode = BooleanArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put((byte)(!arrayLoadNode.execute(array, i) ? 1 : 0));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetCharArrayRegion(@JavaType(value=char[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        CharBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Char).asCharBuffer();
        if (array.isEspressoObject()) {
            char[] contents = (char[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            CharArrayLoad.WithoutNullCheck arrayLoadNode = CharArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetByteArrayRegion(@JavaType(value=byte[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        if (array.isEspressoObject()) {
            byte[] contents = (byte[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            ByteArrayLoad.WithoutNullCheck arrayLoadNode = ByteArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetShortArrayRegion(@JavaType(value=short[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ShortBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Short).asShortBuffer();
        if (array.isEspressoObject()) {
            short[] contents = (short[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            ShortArrayLoad.WithoutNullCheck arrayLoadNode = ShortArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetIntArrayRegion(@JavaType(value=int[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        IntBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Int).asIntBuffer();
        if (array.isEspressoObject()) {
            int[] contents = (int[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            IntArrayLoad.WithoutNullCheck arrayLoadNode = IntArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetFloatArrayRegion(@JavaType(value=float[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        FloatBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Float).asFloatBuffer();
        if (array.isEspressoObject()) {
            float[] contents = (float[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            FloatArrayLoad.WithoutNullCheck arrayLoadNode = FloatArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetDoubleArrayRegion(@JavaType(value=double[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        DoubleBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Double).asDoubleBuffer();
        if (array.isEspressoObject()) {
            double[] contents = (double[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            DoubleArrayLoad.WithoutNullCheck arrayLoadNode = DoubleArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetLongArrayRegion(@JavaType(value=long[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        LongBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Long).asLongBuffer();
        if (array.isEspressoObject()) {
            long[] contents = (long[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.put(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            LongArrayLoad.WithoutNullCheck arrayLoadNode = LongArrayLoadNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                buf.put(arrayLoadNode.execute(array, i));
                ++i;
            }
        }
    }

    private void boundsCheck(int start, int len, long arrayLength) {
        assert (arrayLength >= 0L);
        if (start < 0 || len < 0 || (long)start + (long)len > arrayLength) {
            Meta meta = this.getMeta();
            throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
        }
    }

    private void checkForeignBounds(StaticObject array, int start, int len) {
        ArrayLength.WithoutNullCheck arrayLength = ArrayLengthFactory.WithoutNullCheckNodeGen.getUncached();
        this.boundsCheck(start, len, arrayLength.executeAsLong(array));
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetBooleanArrayRegion(@JavaType(value=boolean[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        if (array.isEspressoObject()) {
            byte[] contents = (byte[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            BooleanArrayStore.WithoutNullCheck arrayStore = BooleanArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetCharArrayRegion(@JavaType(value=char[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        CharBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Char).asCharBuffer();
        if (array.isEspressoObject()) {
            char[] contents = (char[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            CharArrayStore.WithoutNullCheck arrayStore = CharArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetByteArrayRegion(@JavaType(value=byte[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        if (array.isEspressoObject()) {
            byte[] contents = (byte[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            ByteArrayStore.WithoutNullCheck arrayStore = ByteArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetShortArrayRegion(@JavaType(value=short[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        ShortBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Short).asShortBuffer();
        if (array.isEspressoObject()) {
            short[] contents = (short[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            ShortArrayStore.WithoutNullCheck arrayStore = ShortArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetIntArrayRegion(@JavaType(value=int[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        IntBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Int).asIntBuffer();
        if (array.isEspressoObject()) {
            int[] contents = (int[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            IntArrayStore.WithoutNullCheck arrayStore = IntArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetFloatArrayRegion(@JavaType(value=float[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        FloatBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Float).asFloatBuffer();
        if (array.isEspressoObject()) {
            float[] contents = (float[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            FloatArrayStore.WithoutNullCheck arrayStore = FloatArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetDoubleArrayRegion(@JavaType(value=double[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        DoubleBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Double).asDoubleBuffer();
        if (array.isEspressoObject()) {
            double[] contents = (double[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            DoubleArrayStore.WithoutNullCheck arrayStore = DoubleArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void SetLongArrayRegion(@JavaType(value=long[].class) StaticObject array, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        LongBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Long).asLongBuffer();
        if (array.isEspressoObject()) {
            long[] contents = (long[])array.unwrap(language);
            this.boundsCheck(start, len, contents.length);
            buf.get(contents, start, len);
        } else {
            this.checkForeignBounds(array, start, len);
            LongArrayStore.WithoutNullCheck arrayStore = LongArrayStoreNodeGen.WithoutNullCheckNodeGen.getUncached();
            int i = start;
            while (i - len < start) {
                arrayStore.execute(array, i, buf.get(i));
                ++i;
            }
        }
    }

    @JniImpl
    public int GetStringLength(@JavaType(value=String.class) StaticObject string) {
        if (StaticObject.isNull(string)) {
            return 0;
        }
        return (Integer)this.getMeta().java_lang_String_length.invokeDirect(string, new Object[0]);
    }

    @JniImpl
    public @JavaType(value=String.class) StaticObject NewStringUTF(@Pointer TruffleObject bytesPtr) {
        String hostString = NativeUtils.fromUTF8Ptr(bytesPtr);
        return this.getMeta().toGuestString(hostString);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetStringCritical(@JavaType(value=String.class) StaticObject str, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        StaticObject stringChars = this.getJavaVersion().compactStringsEnabled() ? (StaticObject)meta.java_lang_String_toCharArray.invokeDirect(str, new Object[0]) : meta.java_lang_String_value.getObject(str);
        int len = stringChars.length(language);
        ByteBuffer criticalRegion = this.allocateDirect(len, JavaKind.Char);
        @Pointer TruffleObject address = NativeUtils.byteBufferPointer(criticalRegion);
        this.GetCharArrayRegion(stringChars, 0, len, address, language);
        return address;
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetStringUTFChars(@JavaType(value=String.class) StaticObject str, @Pointer TruffleObject isCopyPtr) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        byte[] bytes = ModifiedUtf8.fromJavaString(this.getMeta().toHostString(str), true);
        ByteBuffer region = this.allocateDirect(bytes.length);
        region.put(bytes);
        return NativeUtils.byteBufferPointer(region);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetStringChars(@JavaType(value=String.class) StaticObject string, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        char[] chars;
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        if (this.getJavaVersion().compactStringsEnabled()) {
            StaticObject wrappedChars = (StaticObject)this.getMeta().java_lang_String_toCharArray.invokeDirect(string, new Object[0]);
            chars = (char[])wrappedChars.unwrap(language);
        } else {
            chars = (char[])this.getMeta().java_lang_String_value.getObject(string).unwrap(language);
        }
        ByteBuffer bb = this.allocateDirect(chars.length + 1, JavaKind.Char);
        CharBuffer region = bb.asCharBuffer();
        region.put(chars);
        region.put('\u0000');
        return NativeUtils.byteBufferPointer(bb);
    }

    @CompilerDirectives.TruffleBoundary
    public void releasePtr(@Pointer TruffleObject ptr) {
        long nativePtr = NativeUtils.interopAsPointer(ptr);
        assert (this.nativeBuffers.containsKey(nativePtr));
        this.nativeBuffers.remove(nativePtr);
    }

    @JniImpl
    public void ReleaseStringChars(@JavaType(value=String.class) StaticObject string, @Pointer TruffleObject charsPtr) {
        this.releasePtr(charsPtr);
    }

    @JniImpl
    public void ReleaseStringUTFChars(@JavaType(value=String.class) StaticObject str, @Pointer TruffleObject charsPtr) {
        this.releasePtr(charsPtr);
    }

    @JniImpl
    public void ReleaseStringCritical(@JavaType(value=String.class) StaticObject str, @Pointer TruffleObject criticalRegionPtr) {
        this.releasePtr(criticalRegionPtr);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @JavaType(value=String.class) StaticObject NewString(@Pointer TruffleObject unicodePtr, int len, @Inject EspressoLanguage language, @Inject Meta meta) {
        char[] array = new char[len];
        StaticObject value = StaticObject.wrap(array, meta);
        this.SetCharArrayRegion(value, 0, len, unicodePtr, language);
        return this.getMeta().toGuestString(new String(array));
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetStringRegion(@JavaType(value=String.class) StaticObject str, int start, int len, @Pointer TruffleObject bufPtr, @Inject EspressoLanguage language) {
        char[] chars = this.getJavaVersion().compactStringsEnabled() ? this.getMeta().toHostString(str).toCharArray() : (char[])this.getMeta().java_lang_String_value.getObject(str).unwrap(language);
        if (start < 0 || (long)start + (long)len > (long)chars.length) {
            Meta meta = this.getMeta();
            throw meta.throwException(meta.java_lang_StringIndexOutOfBoundsException);
        }
        CharBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Char).asCharBuffer();
        buf.put(chars, start, len);
    }

    @JniImpl
    public int GetStringUTFLength(@JavaType(value=String.class) StaticObject string) {
        return ModifiedUtf8.utfLength(this.getMeta().toHostString(string));
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void GetStringUTFRegion(@JavaType(value=String.class) StaticObject str, int start, int len, @Pointer TruffleObject bufPtr) {
        Meta meta = this.getMeta();
        String hostString = meta.toHostString(str);
        if (start < 0 || len < 0 || start > hostString.length() - len) {
            throw meta.throwException(meta.java_lang_StringIndexOutOfBoundsException);
        }
        byte[] bytes = ModifiedUtf8.fromJavaString(hostString, start, len, true);
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, bytes.length, JavaKind.Byte);
        buf.put(bytes);
    }

    @JniImpl
    public boolean ExceptionCheck() {
        EspressoException ex = this.getPendingEspressoException();
        assert (ex == null || StaticObject.notNull(ex.getGuestException()));
        return ex != null;
    }

    @JniImpl
    public void ExceptionClear() {
        this.clearPendingException();
    }

    @JniImpl
    public static int Throw(@JavaType(value=Throwable.class) StaticObject obj, @Inject Meta meta) {
        assert (meta.java_lang_Throwable.isAssignableFrom(obj.getKlass()));
        throw meta.throwException(obj);
    }

    @JniImpl
    public int ThrowNew(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject messagePtr, @Inject Meta meta) {
        String message = NativeUtils.interopPointerToString(messagePtr);
        throw meta.throwExceptionWithMessage((ObjectKlass)clazz.getMirrorKlass(this.getMeta()), message);
    }

    @JniImpl
    public @JavaType(value=Throwable.class) StaticObject ExceptionOccurred() {
        StaticObject ex = this.getPendingException();
        if (ex == null) {
            ex = StaticObject.NULL;
        }
        return ex;
    }

    @JniImpl
    public void ExceptionDescribe() {
        EspressoException ex = this.getPendingEspressoException();
        if (ex != null) {
            StaticObject guestException = ex.getGuestException();
            assert (InterpreterToVM.instanceOf(guestException, this.getMeta().java_lang_Throwable));
            Method printStackTrace = guestException.getKlass().lookupMethod(Symbol.Name.printStackTrace, Symbol.Signature._void);
            printStackTrace.invokeDirect(guestException, new Object[0]);
            this.setPendingException(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public void FatalError(@Pointer TruffleObject msgPtr, @Inject SubstitutionProfiler profiler) {
        String msg = NativeUtils.interopPointerToString(msgPtr);
        PrintWriter writer = new PrintWriter(this.getContext().err(), true);
        writer.println("FATAL ERROR in native method: " + msg);
        this.getContext().truffleExit(profiler, 1);
        throw EspressoError.fatal(msg);
    }

    @JniImpl
    public static int MonitorEnter(@JavaType(value=Object.class) StaticObject object, @Inject Meta meta) {
        InterpreterToVM.monitorEnter(object, meta);
        return 0;
    }

    @JniImpl
    public int MonitorExit(@JavaType(value=Object.class) StaticObject object, @Inject Meta meta) {
        try {
            InterpreterToVM.monitorExit(object, meta);
        }
        catch (EspressoException e) {
            assert (InterpreterToVM.instanceOf(e.getGuestException(), this.getMeta().java_lang_IllegalMonitorStateException));
            this.setPendingException(e);
            return -1;
        }
        return 0;
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject GetObjectArrayElement(@JavaType(value=Object[].class) StaticObject array, int index, @Inject EspressoLanguage language) {
        return this.getInterpreterToVM().getArrayObject(language, index, array);
    }

    @JniImpl
    public void SetObjectArrayElement(@JavaType(value=Object[].class) StaticObject array, int index, @JavaType(value=Object.class) StaticObject value, @Inject EspressoLanguage language) {
        this.getInterpreterToVM().setArrayObject(language, value, index, array);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetBooleanArrayElements(@JavaType(value=boolean[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        ByteBuffer bytes;
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        byte[] data = (byte[])array.unwrap(language);
        ByteBuffer elements = bytes = this.allocateDirect(data.length, JavaKind.Boolean);
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetCharArrayElements(@JavaType(value=char[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        char[] data = (char[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Char);
        CharBuffer elements = bytes.asCharBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetByteArrayElements(@JavaType(value=byte[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        ByteBuffer bytes;
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        byte[] data = (byte[])array.unwrap(language);
        ByteBuffer elements = bytes = this.allocateDirect(data.length, JavaKind.Byte);
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetShortArrayElements(@JavaType(value=short[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        short[] data = (short[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Short);
        ShortBuffer elements = bytes.asShortBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetIntArrayElements(@JavaType(value=int[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        int[] data = (int[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Int);
        IntBuffer elements = bytes.asIntBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetFloatArrayElements(@JavaType(value=float[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        float[] data = (float[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Float);
        FloatBuffer elements = bytes.asFloatBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetDoubleArrayElements(@JavaType(value=double[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        double[] data = (double[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Double);
        DoubleBuffer elements = bytes.asDoubleBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @Pointer TruffleObject GetLongArrayElements(@JavaType(value=long[].class) StaticObject array, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        long[] data = (long[])array.unwrap(language);
        ByteBuffer bytes = this.allocateDirect(data.length, JavaKind.Long);
        LongBuffer elements = bytes.asLongBuffer();
        elements.put(data);
        return NativeUtils.byteBufferPointer(bytes);
    }

    private void ReleasePrimitiveArrayElements(StaticObject object, @Pointer TruffleObject bufPtr, int mode, EspressoLanguage language) {
        if (mode == 0 || mode == 1) {
            StaticObject array = object;
            StaticObject clazz = JniEnv.GetObjectClass(array);
            JavaKind componentKind = ((ArrayKlass)clazz.getMirrorKlass(this.getMeta())).getComponentType().getJavaKind();
            assert (componentKind.isPrimitive());
            int length = JniEnv.GetArrayLength(array);
            switch (componentKind) {
                case Boolean: {
                    this.SetBooleanArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Byte: {
                    this.SetByteArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Short: {
                    this.SetShortArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Char: {
                    this.SetCharArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Int: {
                    this.SetIntArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Float: {
                    this.SetFloatArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Long: {
                    this.SetLongArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                case Double: {
                    this.SetDoubleArrayRegion(array, 0, length, bufPtr, language);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        }
        if (mode == 0 || mode == 2) {
            this.releasePtr(bufPtr);
        }
    }

    @JniImpl
    public void ReleaseBooleanArrayElements(@JavaType(value=boolean[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Boolean);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseByteArrayElements(@JavaType(value=byte[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Byte);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseCharArrayElements(@JavaType(value=char[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Char);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseShortArrayElements(@JavaType(value=short[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Short);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseIntArrayElements(@JavaType(value=int[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Int);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseLongArrayElements(@JavaType(value=long[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Long);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseFloatArrayElements(@JavaType(value=float[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Float);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public void ReleaseDoubleArrayElements(@JavaType(value=double[].class) StaticObject object, @Pointer TruffleObject bufPtr, int mode, @Inject EspressoLanguage language) {
        assert (((ArrayKlass)object.getKlass()).getComponentType().getJavaKind() == JavaKind.Double);
        this.ReleasePrimitiveArrayElements(object, bufPtr, mode, language);
    }

    @JniImpl
    public @JavaType(internalName="Ljava/nio/DirectByteBuffer;") StaticObject NewDirectByteBuffer(@Pointer TruffleObject addressPtr, long capacity) {
        Meta meta = this.getMeta();
        StaticObject instance = meta.java_nio_DirectByteBuffer.allocateInstance(this.getContext());
        long address = NativeUtils.interopAsPointer(addressPtr);
        if (meta.getJavaVersion().java21OrLater()) {
            meta.java_nio_DirectByteBuffer_init_long_int.invokeDirect(instance, address, capacity);
        } else {
            meta.java_nio_DirectByteBuffer_init_long_int.invokeDirect(instance, address, (int)capacity);
        }
        return instance;
    }

    @JniImpl
    public @Pointer TruffleObject GetDirectBufferAddress(@JavaType(value=Buffer.class) StaticObject buf) {
        assert (StaticObject.notNull(buf));
        assert (StaticObject.notNull(buf));
        if (!InterpreterToVM.instanceOf(buf, this.getMeta().sun_nio_ch_DirectBuffer)) {
            return RawPointer.nullInstance();
        }
        if (StaticObject.notNull(buf) && !InterpreterToVM.instanceOf(buf, this.getMeta().java_nio_Buffer)) {
            return RawPointer.nullInstance();
        }
        return RawPointer.create((Long)this.getMeta().java_nio_Buffer_address.get(buf));
    }

    @JniImpl
    public long GetDirectBufferCapacity(@JavaType(value=Buffer.class) StaticObject buf) {
        assert (StaticObject.notNull(buf));
        assert (StaticObject.notNull(buf));
        if (!InterpreterToVM.instanceOf(buf, this.getMeta().sun_nio_ch_DirectBuffer)) {
            return -1L;
        }
        if (!InterpreterToVM.instanceOf(buf, this.getMeta().java_nio_Buffer)) {
            return -1L;
        }
        return ((Integer)this.getMeta().java_nio_Buffer_capacity.get(buf)).intValue();
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public int RegisterNative(@JavaType(value=Class.class) StaticObject clazz, @Pointer TruffleObject methodNamePtr, @Pointer TruffleObject methodSignaturePtr, @Pointer TruffleObject closure) {
        String methodName = NativeUtils.interopPointerToString(methodNamePtr);
        String methodSignature = NativeUtils.interopPointerToString(methodSignaturePtr);
        assert (methodName != null && methodSignature != null);
        Symbol<Symbol.Name> name = this.getNames().lookup(methodName);
        Symbol<Symbol.Signature> signature = this.getSignatures().lookupValidSignature(methodSignature);
        Meta meta = this.getMeta();
        if (name == null || signature == null) {
            this.setPendingException(Meta.initException(meta.java_lang_NoSuchMethodError));
            return -1;
        }
        Method targetMethod = clazz.getMirrorKlass(this.getMeta()).lookupDeclaredMethod(name, signature);
        if (targetMethod == null || !targetMethod.isNative()) {
            this.setPendingException(Meta.initException(meta.java_lang_NoSuchMethodError));
            return -1;
        }
        targetMethod.unregisterNative();
        this.getSubstitutions().removeRuntimeSubstitution(targetMethod);
        Substitutions.EspressoRootNodeFactory factory = null;
        factory = this.lookupKnownVmMethods(closure, targetMethod);
        if (factory == null) {
            NativeSignature ns = Method.buildJniNativeSignature(targetMethod.getParsedSignature());
            TruffleObject boundNative = this.getNativeAccess().bindSymbol(closure, ns);
            factory = JniEnv.createJniRootNodeFactory(() -> EspressoRootNode.createNative(targetMethod.getMethodVersion(), boundNative), targetMethod);
        }
        Symbol<Symbol.Type> classType = clazz.getMirrorKlass(this.getMeta()).getType();
        this.getSubstitutions().registerRuntimeSubstitution(classType, name, signature, factory, true);
        return 0;
    }

    private Substitutions.EspressoRootNodeFactory lookupKnownVmMethods(@Pointer TruffleObject closure, Method targetMethod) {
        try {
            long jvmMethodAddress = InteropLibrary.getUncached().asPointer((Object)closure);
            CallableFromNative.Factory knownVmMethod = this.getVM().lookupKnownVmMethod(jvmMethodAddress);
            if (knownVmMethod != null) {
                if (!CallableFromNative.validParameterCount(knownVmMethod, targetMethod.getMethodVersion())) {
                    this.getLogger().warning("Implicit intrinsification of VM method does not have matching parameter counts:");
                    this.getLogger().warning("VM method " + knownVmMethod.methodName() + " has " + knownVmMethod.parameterCount() + " parameters,");
                    this.getLogger().warning("Bound to " + (targetMethod.isStatic() ? "static" : "instance") + " method " + targetMethod.getNameAsString() + " which has " + targetMethod.getParameterCount() + " parameters");
                    return null;
                }
                return JniEnv.createJniRootNodeFactory(() -> EspressoRootNode.createIntrinsifiedNative(targetMethod.getMethodVersion(), knownVmMethod, this.getVM()), targetMethod);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    private static Substitutions.EspressoRootNodeFactory createJniRootNodeFactory(final Supplier<EspressoRootNode> methodRootNodeSupplier, final Method targetMethod) {
        return new Substitutions.EspressoRootNodeFactory(){

            @Override
            public EspressoRootNode createNodeIfValid(final Method methodToSubstitute, boolean forceValid) {
                if (forceValid || methodToSubstitute == targetMethod) {
                    return (EspressoRootNode)methodRootNodeSupplier.get();
                }
                Substitutions.getLogger().warning((Supplier)new Supplier<String>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public String get() {
                        StaticObject expectedLoader = this.this$0.targetMethod.getDeclaringKlass().getDefiningClassLoader();
                        StaticObject givenLoader = methodToSubstitute.getDeclaringKlass().getDefiningClassLoader();
                        return "Runtime substitution for " + String.valueOf(this.this$0.targetMethod) + " does not apply.\n\tExpected class loader: " + String.valueOf(InteropLibrary.getUncached().toDisplayString((Object)expectedLoader, false)) + "\n\tGiven class loader: " + String.valueOf(InteropLibrary.getUncached().toDisplayString((Object)givenLoader, false)) + "\n";
                    }
                });
                return null;
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public int UnregisterNatives(@JavaType(value=Class.class) StaticObject clazz) {
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        for (Method m : klass.getDeclaredMethods()) {
            if (!m.isNative()) continue;
            this.getSubstitutions().removeRuntimeSubstitution(m);
            m.unregisterNative();
        }
        return 0;
    }

    @JniImpl
    public @JavaType(value=Executable.class) StaticObject ToReflectedMethod(@JavaType(value=Class.class) StaticObject unused, @Handle(value=Method.class) long methodId, boolean isStatic, @Inject EspressoLanguage language) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.getDeclaringKlass().isAssignableFrom(unused.getMirrorKlass(this.getMeta())));
        StaticObject methods = null;
        methods = method.isConstructor() ? this.getVM().JVM_GetClassDeclaredConstructors(method.getDeclaringKlass().mirror(), false) : this.getVM().JVM_GetClassDeclaredMethods(method.getDeclaringKlass().mirror(), false);
        for (StaticObject declMethod : (StaticObject[])methods.unwrap(language)) {
            assert (InterpreterToVM.instanceOf(declMethod, this.getMeta().java_lang_reflect_Executable));
            Method m = null;
            if (method.isConstructor()) {
                assert (InterpreterToVM.instanceOf(declMethod, this.getMeta().java_lang_reflect_Constructor));
                m = (Method)this.getMeta().HIDDEN_CONSTRUCTOR_KEY.getHiddenObject(declMethod);
            } else {
                assert (InterpreterToVM.instanceOf(declMethod, this.getMeta().java_lang_reflect_Method));
                m = (Method)this.getMeta().HIDDEN_METHOD_KEY.getHiddenObject(declMethod);
            }
            if (method != m) continue;
            return declMethod;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Method/constructor not found " + String.valueOf(method));
    }

    @JniImpl
    public @JavaType(value=Field.class) StaticObject ToReflectedField(@JavaType(value=Class.class) StaticObject unused, @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long fieldId, boolean isStatic, @Inject EspressoLanguage language) {
        com.oracle.truffle.espresso.impl.Field field = this.fieldIds.getObject(fieldId);
        assert (field.getDeclaringKlass().isAssignableFrom(unused.getMirrorKlass(this.getMeta())));
        StaticObject fields = this.getVM().JVM_GetClassDeclaredFields(field.getDeclaringKlass().mirror(), false);
        for (StaticObject declField : (StaticObject[])fields.unwrap(language)) {
            assert (InterpreterToVM.instanceOf(declField, this.getMeta().java_lang_reflect_Field));
            com.oracle.truffle.espresso.impl.Field f = (com.oracle.truffle.espresso.impl.Field)this.getMeta().HIDDEN_FIELD_KEY.getHiddenObject(declField);
            if (field != f) continue;
            return declField;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Field not found " + String.valueOf(field));
    }

    @JniImpl
    public @Handle(value=com.oracle.truffle.espresso.impl.Field.class) long FromReflectedField(@JavaType(value=Field.class) StaticObject field) {
        assert (InterpreterToVM.instanceOf(field, this.getMeta().java_lang_reflect_Field));
        com.oracle.truffle.espresso.impl.Field guestField = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, this.getMeta());
        guestField.getDeclaringKlass().initialize();
        return this.fieldIds.handlify(guestField);
    }

    @JniImpl
    public @Handle(value=Method.class) long FromReflectedMethod(@JavaType(value=Executable.class) StaticObject method) {
        Method guestMethod;
        assert (InterpreterToVM.instanceOf(method, this.getMeta().java_lang_reflect_Method) || InterpreterToVM.instanceOf(method, this.getMeta().java_lang_reflect_Constructor));
        if (InterpreterToVM.instanceOf(method, this.getMeta().java_lang_reflect_Method)) {
            guestMethod = Method.getHostReflectiveMethodRoot(method, this.getMeta());
        } else if (InterpreterToVM.instanceOf(method, this.getMeta().java_lang_reflect_Constructor)) {
            guestMethod = Method.getHostReflectiveConstructorRoot(method, this.getMeta());
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
        guestMethod.getDeclaringKlass().initialize();
        return this.methodIds.handlify(guestMethod);
    }

    @JniImpl
    public static @JavaType(value=Object.class) StaticObject NewLocalRef(@JavaType(value=Object.class) StaticObject ref) {
        return ref;
    }

    @JniImpl
    public @Handle(value=StaticObject.class) long NewGlobalRef(@Handle(value=StaticObject.class) long handle) {
        return this.getHandles().createGlobal(this.getHandles().get(JNIHandles.toIntHandle(handle)));
    }

    @JniImpl
    public void DeleteGlobalRef(@Handle(value=StaticObject.class) long handle) {
        this.getHandles().deleteGlobalRef(JNIHandles.toIntHandle(handle));
    }

    @JniImpl
    public void DeleteLocalRef(@Handle(value=StaticObject.class) long handle) {
        this.getHandles().deleteLocalRef(JNIHandles.toIntHandle(handle));
    }

    @JniImpl
    public @Handle(value=StaticObject.class) long NewWeakGlobalRef(@Handle(value=StaticObject.class) long handle) {
        return this.getHandles().createWeakGlobal(this.getHandles().get(JNIHandles.toIntHandle(handle)));
    }

    @JniImpl
    public void DeleteWeakGlobalRef(@Handle(value=StaticObject.class) long handle) {
        this.getHandles().deleteGlobalRef(JNIHandles.toIntHandle(handle));
    }

    @JniImpl
    public int PushLocalFrame(int capacity) {
        this.getHandles().pushFrame(capacity);
        return 0;
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject PopLocalFrame(@JavaType(value=Object.class) StaticObject object) {
        this.getHandles().popFrame();
        return object;
    }

    @JniImpl
    @NoSafepoint
    public static boolean IsSameObject(@JavaType(value=Object.class) StaticObject ref1, @JavaType(value=Object.class) StaticObject ref2) {
        return ref1 == ref2;
    }

    @JniImpl
    public int GetObjectRefType(@Handle(value=StaticObject.class) long handle) {
        return this.getHandles().getObjectRefType(JNIHandles.toIntHandle(handle));
    }

    @JniImpl
    @NoSafepoint
    public static int EnsureLocalCapacity(int capacity) {
        if (capacity >= 0 && capacity <= 65536) {
            return 0;
        }
        return -1;
    }

    @JniImpl
    @NoSafepoint
    public int GetVersion() {
        if (this.jniVersion == null) {
            this.jniVersion = JniVersion.getJniVersion(this.getJavaVersion());
        }
        return this.jniVersion.version();
    }

    @JniImpl
    public static int GetArrayLength(@JavaType(value=Object.class) StaticObject array) {
        return ArrayLengthFactory.WithoutNullCheckNodeGen.getUncached().executeAsInt(array);
    }

    @JniImpl
    public @Pointer TruffleObject GetPrimitiveArrayCritical(@JavaType(value=Object.class) StaticObject object, @Pointer TruffleObject isCopyPtr, @Inject EspressoLanguage language) {
        if (!this.getUncached().isNull((Object)isCopyPtr)) {
            ByteBuffer isCopyBuf = NativeUtils.directByteBuffer(isCopyPtr, 1L);
            isCopyBuf.put((byte)1);
        }
        StaticObject array = object;
        StaticObject clazz = JniEnv.GetObjectClass(array);
        JavaKind componentKind = ((ArrayKlass)clazz.getMirrorKlass(this.getMeta())).getComponentType().getJavaKind();
        assert (componentKind.isPrimitive());
        int length = JniEnv.GetArrayLength(array);
        ByteBuffer region = this.allocateDirect(length, componentKind);
        @Pointer TruffleObject addressPtr = NativeUtils.byteBufferPointer(region);
        switch (componentKind) {
            case Boolean: {
                this.GetBooleanArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Byte: {
                this.GetByteArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Short: {
                this.GetShortArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Char: {
                this.GetCharArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Int: {
                this.GetIntArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Float: {
                this.GetFloatArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Long: {
                this.GetLongArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            case Double: {
                this.GetDoubleArrayRegion(array, 0, length, addressPtr, language);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
        return addressPtr;
    }

    @JniImpl
    public void ReleasePrimitiveArrayCritical(@JavaType(value=Object.class) StaticObject object, @Pointer TruffleObject carrayPtr, int mode, @Inject EspressoLanguage language) {
        if (mode == 0 || mode == 1) {
            StaticObject array = object;
            StaticObject clazz = JniEnv.GetObjectClass(array);
            JavaKind componentKind = ((ArrayKlass)clazz.getMirrorKlass(this.getMeta())).getComponentType().getJavaKind();
            assert (componentKind.isPrimitive());
            int length = JniEnv.GetArrayLength(array);
            switch (componentKind) {
                case Boolean: {
                    this.SetBooleanArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Byte: {
                    this.SetByteArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Short: {
                    this.SetShortArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Char: {
                    this.SetCharArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Int: {
                    this.SetIntArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Float: {
                    this.SetFloatArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Long: {
                    this.SetLongArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                case Double: {
                    this.SetDoubleArrayRegion(array, 0, length, carrayPtr, language);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        }
        if (mode == 0 || mode == 2) {
            this.releasePtr(carrayPtr);
        }
    }

    @JniImpl
    public static @JavaType(value=Class.class) StaticObject GetObjectClass(@JavaType(value=Object.class) StaticObject self) {
        return self.getKlass().mirror();
    }

    @JniImpl
    public @JavaType(value=Class.class) StaticObject GetSuperclass(@JavaType(value=Class.class) StaticObject clazz) {
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        if (klass.isInterface() || klass.getSuperClass() == null) {
            return StaticObject.NULL;
        }
        return klass.getSuperKlass().mirror();
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject NewObjectVarargs(@JavaType(value=Class.class) StaticObject clazz, @Handle(value=Method.class) long methodId, @Pointer TruffleObject varargsPtr) {
        Method method = this.methodIds.getObject(methodId);
        assert (method.isConstructor());
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        if (klass.isInterface() || klass.isAbstract()) {
            Meta meta = this.getMeta();
            throw meta.throwException(meta.java_lang_InstantiationException);
        }
        klass.initialize();
        StaticObject instance = klass.allocateInstance(this.getContext());
        method.invokeDirect(instance, this.popVarArgs(varargsPtr, method.getParsedSignature()));
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    @JniImpl
    public @JavaType(value=Class.class) StaticObject FindClass(@Pointer TruffleObject namePtr, @Inject SubstitutionProfiler profiler) {
        String name = NativeUtils.interopPointerToString(namePtr);
        Meta meta = this.getMeta();
        if (name == null || name.indexOf(46) > -1) {
            profiler.profile(7);
            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, name);
        }
        Object internalName = name;
        if (!name.startsWith("[")) {
            internalName = "L" + name + ";";
        }
        if (!Validation.validTypeDescriptor(ByteSequence.create((String)internalName), true)) {
            profiler.profile(6);
            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, name);
        }
        StaticObject protectionDomain = StaticObject.NULL;
        StaticObject loader = StaticObject.NULL;
        StaticObject caller = this.getVM().JVM_GetCallerClass(0, profiler);
        if (StaticObject.notNull(caller)) {
            Klass callerKlass = caller.getMirrorKlass(meta);
            loader = callerKlass.getDefiningClassLoader();
            if (StaticObject.isNull(loader) && meta.java_lang_ClassLoader$NativeLibrary.equals(callerKlass)) {
                StaticObject result = (StaticObject)meta.java_lang_ClassLoader$NativeLibrary_getFromClass.invokeDirect(null, new Object[0]);
                loader = result.getMirrorKlass(meta).getDefiningClassLoader();
                protectionDomain = this.getVM().JVM_GetProtectionDomain(result);
            }
        } else {
            loader = (StaticObject)meta.java_lang_ClassLoader_getSystemClassLoader.invokeDirect(null, new Object[0]);
        }
        StaticObject guestClass = StaticObject.NULL;
        try {
            String dotName = name.replace('/', '.');
            guestClass = (StaticObject)meta.java_lang_Class_forName_String_boolean_ClassLoader.invokeDirect(null, meta.toGuestString(dotName), false, loader);
            EspressoError.guarantee(StaticObject.notNull(guestClass), "Class.forName returned null", dotName);
        }
        catch (EspressoException e) {
            profiler.profile(5);
            if (InterpreterToVM.instanceOf(e.getGuestException(), meta.java_lang_ClassNotFoundException)) {
                profiler.profile(4);
                throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, name);
            }
            throw e;
        }
        meta.HIDDEN_PROTECTION_DOMAIN.setHiddenObject(guestClass, protectionDomain);
        guestClass.getMirrorKlass(meta).safeInitialize();
        return guestClass;
    }

    @JniImpl
    public @JavaType(value=Class.class) StaticObject DefineClass(@Pointer TruffleObject namePtr, @JavaType(value=ClassLoader.class) StaticObject loader, @Pointer TruffleObject bufPtr, int bufLen) {
        return this.getVM().JVM_DefineClass(namePtr, loader, bufPtr, bufLen, StaticObject.NULL);
    }

    @JniImpl
    public @JavaType(value=Object.class) StaticObject AllocObject(@JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        if (StaticObject.isNull(clazz)) {
            throw meta.throwException(this.getMeta().java_lang_InstantiationException);
        }
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        return klass.allocateInstance(this.getContext());
    }

    @JniImpl
    public boolean IsAssignableFrom(@JavaType(value=Class.class) StaticObject clazz1, @JavaType(value=Class.class) StaticObject clazz2) {
        Klass klass2 = clazz2.getMirrorKlass(this.getMeta());
        return klass2.isAssignableFrom(clazz1.getMirrorKlass(this.getMeta()));
    }

    @JniImpl
    public boolean IsInstanceOf(@JavaType(value=Object.class) StaticObject obj, @JavaType(value=Class.class) StaticObject clazz) {
        if (StaticObject.isNull(obj)) {
            return true;
        }
        return InterpreterToVM.instanceOf(obj, clazz.getMirrorKlass(this.getMeta()));
    }

    @JniImpl
    public @JavaType(internalName="Ljava/lang/Module;") StaticObject GetModule(@JavaType(value=Class.class) StaticObject clazz) {
        Meta meta = this.getMeta();
        if (StaticObject.isNull(clazz)) {
            throw meta.throwNullPointerException();
        }
        if (!meta.java_lang_Class.isAssignableFrom(clazz.getKlass())) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Invalid Class");
        }
        return clazz.getMirrorKlass(this.getMeta()).module().module();
    }

    @JniImpl
    public boolean IsVirtualThread(@JavaType(value=Thread.class) StaticObject thread) {
        Meta meta = this.getMeta();
        if (StaticObject.isNull(thread)) {
            return false;
        }
        return meta.java_lang_BaseVirtualThread.isAssignableFrom(thread.getKlass());
    }

    private class VarArgsImpl
    implements VarArgs {
        private final @Pointer TruffleObject nativePointer;

        VarArgsImpl(TruffleObject nativePointer) {
            this.nativePointer = nativePointer;
        }

        @Override
        public boolean popBoolean() {
            try {
                return (Boolean)JniEnv.this.getUncached().execute((Object)JniEnv.this.popBoolean, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public byte popByte() {
            try {
                return (Byte)JniEnv.this.getUncached().execute((Object)JniEnv.this.popByte, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public char popChar() {
            try {
                return ((Character)JniEnv.this.getUncached().execute((Object)JniEnv.this.popChar, new Object[]{this.nativePointer})).charValue();
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public short popShort() {
            try {
                return (Short)JniEnv.this.getUncached().execute((Object)JniEnv.this.popShort, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public int popInt() {
            try {
                return (Integer)JniEnv.this.getUncached().execute((Object)JniEnv.this.popInt, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public float popFloat() {
            try {
                return ((Float)JniEnv.this.getUncached().execute((Object)JniEnv.this.popFloat, new Object[]{this.nativePointer})).floatValue();
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public double popDouble() {
            try {
                return (Double)JniEnv.this.getUncached().execute((Object)JniEnv.this.popDouble, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public long popLong() {
            try {
                return (Long)JniEnv.this.getUncached().execute((Object)JniEnv.this.popLong, new Object[]{this.nativePointer});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public Object popObject() {
            try {
                Object ret = JniEnv.this.getUncached().execute((Object)JniEnv.this.popObject, new Object[]{this.nativePointer});
                @Handle(value=StaticObject.class) long handle = 0L;
                handle = JniEnv.this.getUncached().isPointer(ret) ? JniEnv.this.getUncached().asPointer(ret) : ((Long)ret).longValue();
                StaticObject result = JniEnv.this.getHandles().get(Math.toIntExact(handle));
                if (result instanceof StaticObject) {
                    return result;
                }
                if (JniEnv.this.getUncached().isNull((Object)result)) {
                    return StaticObject.NULL;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.unimplemented("non null native pointer in JniEnv");
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException | ClassCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

