/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.ffi.Callback;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;

public abstract class NativeEnv
extends ContextAccessImpl {
    private static final int LOOKUP_CALLBACK_ARGS_COUNT = 1;
    private final InteropLibrary uncached = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private final Set<@Pointer TruffleObject> nativeClosures = Collections.newSetFromMap(new IdentityHashMap());
    private Map<String, CallableFromNative.Factory> methods;

    public NativeEnv(EspressoContext context) {
        super(context);
    }

    protected abstract List<CallableFromNative.Factory> getCollector();

    protected int lookupCallBackArgsCount() {
        return 1;
    }

    protected NativeSignature lookupCallbackSignature() {
        return NativeSignature.create(NativeType.POINTER, NativeType.POINTER);
    }

    protected void processCallBackResult(String name, CallableFromNative.Factory factory, Object ... args) {
        assert (args.length == this.lookupCallBackArgsCount());
    }

    public JNIHandles getHandles() {
        return this.jni().getHandles();
    }

    protected final InteropLibrary getUncached() {
        return this.uncached;
    }

    protected JniEnv jni() {
        return this.getContext().getJNI();
    }

    protected TruffleObject initializeAndGetEnv(TruffleObject initializeFunctionPointer, Object ... extraArgs) {
        return this.initializeAndGetEnv(false, initializeFunctionPointer, extraArgs);
    }

    @CompilerDirectives.TruffleBoundary
    protected TruffleObject initializeAndGetEnv(boolean prependExtra, TruffleObject initializeFunctionPointer, Object ... extraArgs) {
        TruffleObject res;
        Object[] newArgs = this.prepareInit(prependExtra, extraArgs);
        try {
            res = (TruffleObject)this.getUncached().execute((Object)initializeFunctionPointer, newArgs);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        finally {
            this.cleanupAfterInit();
        }
        return res;
    }

    private Map<String, CallableFromNative.Factory> buildMethodsMap() {
        HashMap<String, CallableFromNative.Factory> map = new HashMap<String, CallableFromNative.Factory>();
        for (CallableFromNative.Factory method : this.getCollector()) {
            EspressoError.guarantee(!map.containsKey(method.methodName()), "Substitution already exists", method);
            map.put(method.methodName(), method);
        }
        return Collections.unmodifiableMap(map);
    }

    private Object[] prepareInit(boolean prependExtra, Object[] extraArgs) {
        int pos;
        Object[] newArgs = new Object[extraArgs.length + 1];
        if (prependExtra) {
            newArgs[newArgs.length - 1] = this.getLookupCallbackClosure();
            pos = 0;
        } else {
            newArgs[0] = this.getLookupCallbackClosure();
            pos = 1;
        }
        Object[] objectArray = extraArgs;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object arg;
            newArgs[pos] = arg = objectArray[i];
            ++pos;
        }
        this.methods = this.buildMethodsMap();
        return newArgs;
    }

    private void cleanupAfterInit() {
        this.methods = null;
    }

    private TruffleObject getLookupCallbackClosure() {
        Callback callback = new Callback(this.lookupCallBackArgsCount(), new Callback.Function(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object ... args) {
                try {
                    String name = NativeUtils.interopPointerToString((TruffleObject)args[0]);
                    CallableFromNative.Factory factory = NativeEnv.this.lookupFactory(name);
                    NativeEnv.this.processCallBackResult(name, factory, args);
                    return NativeEnv.this.createNativeClosureForFactory(factory, name);
                }
                catch (ClassCastException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere(e);
                }
                catch (OutOfMemoryError | RuntimeException | StackOverflowError e) {
                    throw e;
                }
                catch (Throwable e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere(e);
                }
            }
        });
        return this.getNativeAccess().createNativeClosure(callback, this.lookupCallbackSignature());
    }

    private CallableFromNative.Factory lookupFactory(String methodName) {
        assert (this.methods != null);
        CompilerAsserts.neverPartOfCompilation();
        return this.methods.get(methodName);
    }

    protected abstract TruffleLogger getLogger();

    @CompilerDirectives.TruffleBoundary
    private TruffleObject createNativeClosureForFactory(CallableFromNative.Factory factory, final String methodName) {
        if (factory == null) {
            final String envName = this.getClass().getSimpleName();
            this.getLogger().log(Level.FINER, "Fetching unknown/unimplemented {0} method: {1}", new Object[]{envName, methodName});
            @Pointer TruffleObject errorClosure = this.getNativeAccess().createNativeClosure(new Callback(0, new Callback.Function(){
                final /* synthetic */ NativeEnv this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object call(Object ... args) {
                    CompilerDirectives.transferToInterpreter();
                    this.this$0.getLogger().log(Level.SEVERE, "Calling unimplemented {0} method: {1}", new Object[]{envName, methodName});
                    throw EspressoError.unimplemented(envName + " method: " + methodName);
                }
            }), NativeSignature.create(NativeType.VOID, new NativeType[0]));
            this.nativeClosures.add(errorClosure);
            return errorClosure;
        }
        NativeSignature signature = factory.jniNativeSignature();
        Callback target = this.intrinsicWrapper(factory);
        @Pointer TruffleObject nativeClosure = this.getNativeAccess().createNativeClosure(target, signature);
        this.nativeClosures.add(nativeClosure);
        return nativeClosure;
    }

    protected abstract String getName();

    private Callback intrinsicWrapper(final CallableFromNative.Factory factory) {
        int extraArg = factory.prependEnv() ? 1 : 0;
        return new Callback(factory.parameterCount() + extraArg, new Callback.Function(){
            @CompilerDirectives.CompilationFinal
            private volatile CallTarget target;
            final /* synthetic */ NativeEnv this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call(Object ... args) {
                boolean isJni = factory.prependEnv();
                try {
                    CallTarget actualTarget = this.target;
                    if (actualTarget == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        3 var4_5 = this;
                        synchronized (var4_5) {
                            actualTarget = this.target;
                            if (actualTarget == null) {
                                CallableFromNative subst = factory.create();
                                String name = this.this$0.getName() + "." + factory.methodName();
                                NativeRootNode rootNode = new NativeRootNode(this.this$0.getLanguage(), subst, name);
                                this.target = actualTarget = rootNode.getCallTarget();
                            }
                        }
                    }
                    return actualTarget.call(args);
                }
                catch (EspressoException | OutOfMemoryError | StackOverflowError e) {
                    if (isJni) {
                        EspressoException wrappedError = e instanceof EspressoException ? (EspressoException)((Object)e) : (e instanceof StackOverflowError ? this.this$0.getContext().getStackOverflow() : this.this$0.getContext().getOutOfMemory());
                        this.this$0.jni().setPendingException(wrappedError);
                        return NativeEnv.defaultValue(factory.returnType());
                    }
                    throw e;
                }
            }
        });
    }

    protected static Object defaultValue(NativeType nativeType) {
        switch (nativeType) {
            case BOOLEAN: {
                return false;
            }
            case BYTE: {
                return (byte)0;
            }
            case CHAR: {
                return Character.valueOf('\u0000');
            }
            case SHORT: {
                return (short)0;
            }
            case INT: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case POINTER: {
                return RawPointer.nullInstance();
            }
            case VOID: 
            case OBJECT: {
                return 0L;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Unexpected NativeType: " + String.valueOf((Object)nativeType));
    }

    private static class NativeRootNode
    extends RootNode {
        @Node.Child
        private CallableFromNative node;
        private final NativeEnvComputer getNativeEnvFromContext;
        private final String name;

        NativeRootNode(EspressoLanguage language, CallableFromNative node, String name) {
            super((TruffleLanguage)language);
            String generatedBy;
            this.node = node;
            this.name = name;
            switch (generatedBy = node.generatedBy()) {
                case "VmImpl": {
                    this.getNativeEnvFromContext = NativeEnvComputer.getVM;
                    break;
                }
                case "ManagementImpl": {
                    this.getNativeEnvFromContext = NativeEnvComputer.getManagement;
                    break;
                }
                case "JniImpl": {
                    this.getNativeEnvFromContext = NativeEnvComputer.getJNI;
                    break;
                }
                case "JvmtiImpl": {
                    this.getNativeEnvFromContext = NativeEnvComputer.getJvmti;
                    break;
                }
                default: {
                    throw EspressoError.shouldNotReachHere("Unknown NativeEnv subclass found " + generatedBy);
                }
            }
        }

        public Object execute(VirtualFrame frame) {
            EspressoContext context = EspressoContext.get((Node)this);
            Object nativeEnv = this.getNativeEnvFromContext.apply(context);
            return this.node.invoke(nativeEnv, frame.getArguments());
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        @FunctionalInterface
        private static interface NativeEnvComputer
        extends Function<EspressoContext, Object> {
            public static final NativeEnvComputer getVM = EspressoContext::getVM;
            public static final NativeEnvComputer getManagement = context -> context.getVM().getManagement();
            public static final NativeEnvComputer getJNI = EspressoContext::getJNI;
            public static final NativeEnvComputer getJvmti = context -> context.getVM().getJvmti();
        }
    }
}

