/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.espresso.descriptors.Symbol;
import java.util.Objects;

public final class ExceptionHandler {
    public static final ExceptionHandler[] EMPTY_ARRAY = new ExceptionHandler[0];
    private final int startBCI;
    private final int endBCI;
    private final int handlerBCI;
    private final int catchTypeCPI;
    private final Symbol<Symbol.Type> catchType;

    public ExceptionHandler(int startBCI, int endBCI, int catchBCI, int catchTypeCPI, Symbol<Symbol.Type> catchType) {
        this.startBCI = startBCI;
        this.endBCI = endBCI;
        this.handlerBCI = catchBCI;
        this.catchTypeCPI = catchTypeCPI;
        this.catchType = catchType;
    }

    public int getStartBCI() {
        return this.startBCI;
    }

    public int getEndBCI() {
        return this.endBCI;
    }

    public int getHandlerBCI() {
        return this.handlerBCI;
    }

    public int catchTypeCPI() {
        return this.catchTypeCPI;
    }

    public boolean isCatchAll() {
        return this.catchTypeCPI == 0;
    }

    public boolean covers(int bci) {
        return this.startBCI <= bci && bci < this.endBCI;
    }

    public Symbol<Symbol.Type> getCatchType() {
        return this.catchType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExceptionHandler)) {
            return false;
        }
        ExceptionHandler that = (ExceptionHandler)obj;
        if (this.startBCI != that.startBCI || this.endBCI != that.endBCI || this.handlerBCI != that.handlerBCI || this.catchTypeCPI != that.catchTypeCPI) {
            return false;
        }
        return Objects.equals(this.catchType, that.catchType);
    }

    public String toString() {
        return "ExceptionHandler<startBCI=" + this.startBCI + ", endBCI=" + this.endBCI + ", handlerBCI=" + this.handlerBCI + ", catchTypeCPI=" + this.catchTypeCPI + ", catchType=" + String.valueOf(this.catchType) + ">";
    }

    public int hashCode() {
        return this.catchTypeCPI ^ this.endBCI ^ this.handlerBCI;
    }
}

