/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ByteBufferInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ForeignExceptionInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.InterruptedExceptionInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ListInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop;
import org.graalvm.collections.Pair;

public class InteropKlassesDispatch {
    public static final int BASE_INTEROP_ID = 0;
    public static final int ESPRESSO_INTEROP_ID = 1;
    public static final int FOREIGN_EXCEPTION_INTEROP_ID = 2;
    public static final int INTERRUPTED_EXCEPTION_INTEROP_ID = 3;
    public static final int ITERABLE_INTEROP_ID = 4;
    public static final int ITERATOR_INTEROP_ID = 5;
    public static final int LIST_INTEROP_ID = 6;
    public static final int MAP_ENTRY_INTEROP_ID = 7;
    public static final int MAP_INTEROP_ID = 8;
    public static final int THROWABLE_INTEROP_ID = 9;
    public static final int BYTE_BUFFER_INTEROP_ID = 10;
    public static final int DISPATCH_TOTAL = 11;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final Pair<ObjectKlass, Class<?>>[][] classes;

    InteropKlassesDispatch(Meta meta) {
        this.classes = new Pair[][]{{Pair.create((Object)meta.java_util_List, ListInterop.class), Pair.create((Object)meta.java_lang_Iterable, IterableInterop.class)}, {Pair.create((Object)meta.java_util_Map, MapInterop.class)}, {Pair.create((Object)meta.java_util_Map_Entry, MapEntryInterop.class)}, {Pair.create((Object)meta.java_util_Iterator, IteratorInterop.class)}, {Pair.create((Object)meta.java_nio_ByteBuffer, ByteBufferInterop.class)}, {Pair.create((Object)meta.java_lang_InterruptedException, InterruptedExceptionInterop.class), Pair.create((Object)meta.java_lang_Throwable, ThrowableInterop.class)}};
    }

    public Class<?> resolveDispatch(Klass k) {
        Class result = null;
        if (k.isPrimitive()) {
            result = BaseInterop.class;
        } else if (k.isArray()) {
            result = EspressoInterop.class;
        } else {
            if (k.getMeta().polyglot != null && k.getMeta().polyglot.ForeignException == k) {
                return ForeignExceptionInterop.class;
            }
            Pair<ObjectKlass, Class<?>>[][] pairArray = this.classes;
            int n = pairArray.length;
            block0: for (int i = 0; i < n; ++i) {
                Pair<ObjectKlass, Class<?>>[] exclusive;
                for (Pair<ObjectKlass, Class<?>> pair : exclusive = pairArray[i]) {
                    if (!((ObjectKlass)pair.getLeft()).isAssignableFrom(k)) continue;
                    if (result != null) {
                        result = EspressoInterop.class;
                        break block0;
                    }
                    result = (Class)pair.getRight();
                    continue block0;
                }
            }
            if (result == null) {
                result = EspressoInterop.class;
            }
        }
        return result;
    }

    public static int dispatchToId(Class<?> dispatch) {
        if (dispatch == BaseInterop.class) {
            return 0;
        }
        if (dispatch == EspressoInterop.class) {
            return 1;
        }
        if (dispatch == ForeignExceptionInterop.class) {
            return 2;
        }
        if (dispatch == InterruptedExceptionInterop.class) {
            return 3;
        }
        if (dispatch == IterableInterop.class) {
            return 4;
        }
        if (dispatch == IteratorInterop.class) {
            return 5;
        }
        if (dispatch == ListInterop.class) {
            return 6;
        }
        if (dispatch == MapEntryInterop.class) {
            return 7;
        }
        if (dispatch == MapInterop.class) {
            return 8;
        }
        if (dispatch == ThrowableInterop.class) {
            return 9;
        }
        if (dispatch == ByteBufferInterop.class) {
            return 10;
        }
        throw EspressoError.shouldNotReachHere();
    }
}

