/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNode;

@GeneratedBy(value=AbstractInstrumentableBytecodeNode.class)
final class AbstractInstrumentableBytecodeNodeWrapper
extends AbstractInstrumentableBytecodeNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private AbstractInstrumentableBytecodeNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    AbstractInstrumentableBytecodeNodeWrapper(AbstractInstrumentableBytecodeNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public AbstractInstrumentableBytecodeNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }

    @Override
    void initializeFrame(VirtualFrame frame) {
        this.delegateNode.initializeFrame(frame);
    }

    @Override
    Method.MethodVersion getMethodVersion() {
        return this.delegateNode.getMethodVersion();
    }

    @Override
    protected boolean isTrivial() {
        return this.delegateNode.isTrivial();
    }
}

