/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoBaseStatementNodeWrapper;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableNode;

@ExportLibrary(value=NodeLibrary.class)
@GenerateWrapper
public abstract class EspressoBaseStatementNode
extends EspressoInstrumentableNode {
    public void execute(VirtualFrame frame) {
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.StatementTag.class;
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new EspressoBaseStatementNodeWrapper(this, probe);
    }

    public final BytecodeNode getBytecodeNode() {
        Node parent;
        for (parent = this.getParent(); !(parent instanceof BytecodeNode) && parent != null; parent = parent.getParent()) {
        }
        return (BytecodeNode)parent;
    }

    @ExportMessage
    public final boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public final Object getScope(Frame frame, boolean nodeEnter) {
        return this.getScopeSlowPath(frame != null ? frame.materialize() : null, nodeEnter);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getScopeSlowPath(MaterializedFrame frame, boolean nodeEnter) {
        return this.getBytecodeNode().getScope((Frame)frame, nodeEnter);
    }
}

