/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.ReturnAddress;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.continuation.HostFrameRecord;

public final class EspressoFrame {
    private static final int BCI_SLOT = 0;
    private static final int VALUES_START = 1;

    private EspressoFrame() {
        throw EspressoError.shouldNotReachHere();
    }

    public static FrameDescriptor createFrameDescriptor(int locals, int stack) {
        int slotCount = locals + Math.max(stack, 1);
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder((int)(slotCount + 1));
        int bciSlot = builder.addSlot(FrameSlotKind.Static, null, null);
        assert (bciSlot == 0);
        int valuesStart = builder.addSlots(slotCount, FrameSlotKind.Static);
        assert (valuesStart == 1);
        return builder.build();
    }

    public static void dup1(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
    }

    public static void dupx1(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
        EspressoFrame.copyStatic(frame, top - 2, top - 1);
        EspressoFrame.copyStatic(frame, top, top - 2);
    }

    public static void dupx2(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top);
        EspressoFrame.copyStatic(frame, top - 2, top - 1);
        EspressoFrame.copyStatic(frame, top - 3, top - 2);
        EspressoFrame.copyStatic(frame, top, top - 3);
    }

    public static void dup2(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
    }

    public static void swapSingle(Frame frame, int top) {
        EspressoFrame.swapStatic(frame, top);
    }

    public static void dup2x1(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
        EspressoFrame.copyStatic(frame, top - 3, top - 1);
        EspressoFrame.copyStatic(frame, top, top - 3);
        EspressoFrame.copyStatic(frame, top + 1, top - 2);
    }

    public static void dup2x2(Frame frame, int top) {
        EspressoFrame.copyStatic(frame, top - 1, top + 1);
        EspressoFrame.copyStatic(frame, top - 2, top);
        EspressoFrame.copyStatic(frame, top - 3, top - 1);
        EspressoFrame.copyStatic(frame, top - 4, top - 2);
        EspressoFrame.copyStatic(frame, top, top - 4);
        EspressoFrame.copyStatic(frame, top + 1, top - 3);
    }

    private static void swapStatic(Frame frame, int top) {
        assert (top >= 2);
        frame.swapStatic(top - 1, top - 2);
    }

    private static void copyStatic(Frame frame, int src, int dst) {
        assert (src >= 0 && dst >= 0);
        frame.copyStatic(src, dst);
    }

    public static int popInt(Frame frame, int slot) {
        assert (slot >= 0);
        int result = frame.getIntStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static StaticObject peekObject(Frame frame, int slot) {
        assert (slot >= 0);
        Object result = frame.getObjectStatic(slot);
        assert (result != null);
        return (StaticObject)result;
    }

    public static StaticObject popObject(Frame frame, int slot) {
        assert (slot >= 0);
        Object result = frame.getObjectStatic(slot);
        EspressoFrame.clearReference(frame, slot);
        return (StaticObject)result;
    }

    public static float popFloat(Frame frame, int slot) {
        assert (slot >= 0);
        float result = frame.getFloatStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static long popLong(Frame frame, int slot) {
        assert (slot >= 0);
        long result = frame.getLongStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    public static double popDouble(Frame frame, int slot) {
        assert (slot >= 0);
        double result = frame.getDoubleStatic(slot);
        EspressoFrame.clearPrimitive(frame, slot);
        return result;
    }

    static Object popReturnAddressOrObject(Frame frame, int slot) {
        assert (slot >= 0);
        Object result = frame.getObjectStatic(slot);
        EspressoFrame.clearReference(frame, slot);
        assert (result instanceof StaticObject || result instanceof ReturnAddress);
        return result;
    }

    static void putReturnAddress(Frame frame, int slot, int targetBCI) {
        assert (slot >= 0);
        frame.setObjectStatic(slot, (Object)ReturnAddress.create(targetBCI));
    }

    public static void putObject(Frame frame, int slot, StaticObject value) {
        assert (slot >= 0);
        assert (value != null);
        frame.setObjectStatic(slot, (Object)value);
    }

    public static void putInt(Frame frame, int slot, int value) {
        assert (slot >= 0);
        frame.setIntStatic(slot, value);
    }

    public static void putFloat(Frame frame, int slot, float value) {
        assert (slot >= 0);
        frame.setFloatStatic(slot, value);
    }

    public static void putLong(Frame frame, int slot, long value) {
        assert (slot >= 0);
        frame.setLongStatic(slot + 1, value);
    }

    public static void putDouble(Frame frame, int slot, double value) {
        assert (slot >= 0);
        frame.setDoubleStatic(slot + 1, value);
    }

    private static void clearReference(Frame frame, int slot) {
        assert (slot >= 0);
        frame.clearObjectStatic(slot);
    }

    private static void clearPrimitive(Frame frame, int slot) {
        assert (slot >= 0);
        frame.clearPrimitiveStatic(slot);
    }

    public static void clear(Frame frame, int slot) {
        assert (slot >= 0);
        frame.clearStatic(slot);
    }

    public static void clearLocal(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        EspressoFrame.clear(frame, 1 + localSlot);
    }

    public static void setLocalObject(Frame frame, int localSlot, StaticObject value) {
        assert (localSlot >= 0);
        assert (value != null);
        frame.setObjectStatic(1 + localSlot, (Object)value);
    }

    static void setLocalObjectOrReturnAddress(Frame frame, int localSlot, Object value) {
        assert (value instanceof StaticObject || value instanceof ReturnAddress);
        frame.setObjectStatic(1 + localSlot, value);
    }

    public static void setLocalInt(Frame frame, int localSlot, int value) {
        assert (localSlot >= 0);
        frame.setIntStatic(1 + localSlot, value);
    }

    public static void setLocalFloat(Frame frame, int localSlot, float value) {
        assert (localSlot >= 0);
        frame.setFloatStatic(1 + localSlot, value);
    }

    public static void setLocalLong(Frame frame, int localSlot, long value) {
        assert (localSlot >= 0);
        frame.setLongStatic(1 + localSlot, value);
    }

    public static void setLocalDouble(Frame frame, int localSlot, double value) {
        assert (localSlot >= 0);
        frame.setDoubleStatic(1 + localSlot, value);
    }

    public static int getLocalInt(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        return frame.getIntStatic(1 + localSlot);
    }

    public static StaticObject getLocalObject(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        Object result = frame.getObjectStatic(1 + localSlot);
        assert (result != null);
        return (StaticObject)result;
    }

    static int getLocalReturnAddress(Frame frame, int localSlot) {
        Object result = frame.getObjectStatic(1 + localSlot);
        assert (result != null);
        return ((ReturnAddress)result).getBci();
    }

    public static float getLocalFloat(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        return frame.getFloatStatic(1 + localSlot);
    }

    public static long getLocalLong(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        return frame.getLongStatic(1 + localSlot);
    }

    public static double getLocalDouble(Frame frame, int localSlot) {
        assert (localSlot >= 0);
        return frame.getDoubleStatic(1 + localSlot);
    }

    static void setBCI(Frame frame, int bci) {
        frame.setIntStatic(0, EspressoFrame.encodeBCI(bci));
    }

    static int getBCI(Frame frame) {
        return EspressoFrame.decodeBCI(frame.getIntStatic(0));
    }

    public static int encodeBCI(int bci) {
        return bci + 1;
    }

    public static int decodeBCI(int encodedBCI) {
        return encodedBCI - 1;
    }

    public static int startingStackOffset(int maxLocals) {
        return 1 + maxLocals;
    }

    public static StaticObject peekReceiver(VirtualFrame frame, int top, Method m) {
        assert (!m.isStatic());
        int skipSlots = Signatures.slotsForParameters(m.getParsedSignature());
        int slot = top - skipSlots - 1;
        assert (slot >= 0);
        StaticObject result = EspressoFrame.peekObject((Frame)frame, slot);
        assert (result != null);
        return result;
    }

    @ExplodeLoop
    public static Object[] popArguments(VirtualFrame frame, int top, boolean hasReceiver, Symbol<Symbol.Type>[] signature) {
        int argCount = Signatures.parameterCount(signature);
        int extraParam = hasReceiver ? 1 : 0;
        Object[] args = new Object[argCount + extraParam];
        CompilerAsserts.partialEvaluationConstant((int)argCount);
        CompilerAsserts.partialEvaluationConstant(signature);
        CompilerAsserts.partialEvaluationConstant((boolean)hasReceiver);
        int argAt = top - 1;
        for (int i = argCount - 1; i >= 0; --i) {
            Symbol<Symbol.Type> argType = Signatures.parameterType(signature, i);
            switch (argType.byteAt(0)) {
                case 90: {
                    args[i + extraParam] = EspressoFrame.popInt((Frame)frame, argAt) != 0;
                    break;
                }
                case 66: {
                    args[i + extraParam] = (byte)EspressoFrame.popInt((Frame)frame, argAt);
                    break;
                }
                case 83: {
                    args[i + extraParam] = (short)EspressoFrame.popInt((Frame)frame, argAt);
                    break;
                }
                case 67: {
                    args[i + extraParam] = Character.valueOf((char)EspressoFrame.popInt((Frame)frame, argAt));
                    break;
                }
                case 73: {
                    args[i + extraParam] = EspressoFrame.popInt((Frame)frame, argAt);
                    break;
                }
                case 70: {
                    args[i + extraParam] = Float.valueOf(EspressoFrame.popFloat((Frame)frame, argAt));
                    break;
                }
                case 74: {
                    args[i + extraParam] = EspressoFrame.popLong((Frame)frame, argAt);
                    --argAt;
                    break;
                }
                case 68: {
                    args[i + extraParam] = EspressoFrame.popDouble((Frame)frame, argAt);
                    --argAt;
                    break;
                }
                case 76: 
                case 91: {
                    args[i + extraParam] = EspressoFrame.popObject((Frame)frame, argAt);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
            --argAt;
        }
        if (hasReceiver) {
            args[0] = EspressoFrame.popObject((Frame)frame, argAt);
        }
        return args;
    }

    @ExplodeLoop
    public static Object[] popBasicArgumentsWithArray(VirtualFrame frame, int top, Symbol<Symbol.Type>[] signature, boolean hasReceiver, Object[] args) {
        CompilerAsserts.partialEvaluationConstant((int)Signatures.parameterCount(signature));
        CompilerAsserts.partialEvaluationConstant(signature);
        int extraParam = hasReceiver ? 1 : 0;
        int argAt = top - 1;
        for (int i = Signatures.parameterCount(signature) - 1; i >= 0; --i) {
            Symbol<Symbol.Type> argType = Signatures.parameterType(signature, i);
            switch (argType.byteAt(0)) {
                case 66: 
                case 67: 
                case 73: 
                case 83: 
                case 90: {
                    args[i + extraParam] = EspressoFrame.popInt((Frame)frame, argAt);
                    break;
                }
                case 70: {
                    args[i + extraParam] = Float.valueOf(EspressoFrame.popFloat((Frame)frame, argAt));
                    break;
                }
                case 74: {
                    args[i + extraParam] = EspressoFrame.popLong((Frame)frame, argAt);
                    --argAt;
                    break;
                }
                case 68: {
                    args[i + extraParam] = EspressoFrame.popDouble((Frame)frame, argAt);
                    --argAt;
                    break;
                }
                case 76: 
                case 91: {
                    args[i + extraParam] = EspressoFrame.popObject((Frame)frame, argAt);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
            --argAt;
        }
        if (hasReceiver) {
            args[0] = EspressoFrame.popObject((Frame)frame, argAt);
        }
        return args;
    }

    public static int putKind(VirtualFrame frame, int top, Object value, JavaKind kind) {
        assert (top >= 0);
        switch (kind) {
            case Boolean: {
                EspressoFrame.putInt((Frame)frame, top, (Boolean)value != false ? 1 : 0);
                break;
            }
            case Byte: {
                EspressoFrame.putInt((Frame)frame, top, ((Byte)value).byteValue());
                break;
            }
            case Short: {
                EspressoFrame.putInt((Frame)frame, top, ((Short)value).shortValue());
                break;
            }
            case Char: {
                EspressoFrame.putInt((Frame)frame, top, ((Character)value).charValue());
                break;
            }
            case Int: {
                EspressoFrame.putInt((Frame)frame, top, (Integer)value);
                break;
            }
            case Float: {
                EspressoFrame.putFloat((Frame)frame, top, ((Float)value).floatValue());
                break;
            }
            case Long: {
                EspressoFrame.putLong((Frame)frame, top, (Long)value);
                break;
            }
            case Double: {
                EspressoFrame.putDouble((Frame)frame, top, (Double)value);
                break;
            }
            case Object: {
                EspressoFrame.putObject((Frame)frame, top, (StaticObject)value);
                break;
            }
            case Void: {
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
        return kind.getSlotCount();
    }

    public static Object peekKind(VirtualFrame frame, int top, JavaKind kind) {
        assert (top >= 0);
        switch (kind) {
            case Boolean: {
                return frame.getIntStatic(top) != 0;
            }
            case Byte: {
                return (byte)frame.getIntStatic(top);
            }
            case Short: {
                return (short)frame.getIntStatic(top);
            }
            case Char: {
                return Character.valueOf((char)frame.getIntStatic(top));
            }
            case Int: {
                return frame.getIntStatic(top);
            }
            case Float: {
                return Float.valueOf(frame.getFloatStatic(top));
            }
            case Long: {
                return frame.getLongStatic(top);
            }
            case Double: {
                return frame.getDoubleStatic(top);
            }
            case Object: {
                return frame.getObjectStatic(top);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    public static int putType(VirtualFrame frame, int top, Object value, Symbol<Symbol.Type> type) {
        assert (top >= 0);
        switch (type.byteAt(0)) {
            case 90: {
                EspressoFrame.putInt((Frame)frame, top, (Boolean)value != false ? 1 : 0);
                break;
            }
            case 66: {
                EspressoFrame.putInt((Frame)frame, top, ((Byte)value).byteValue());
                break;
            }
            case 83: {
                EspressoFrame.putInt((Frame)frame, top, ((Short)value).shortValue());
                break;
            }
            case 67: {
                EspressoFrame.putInt((Frame)frame, top, ((Character)value).charValue());
                break;
            }
            case 73: {
                EspressoFrame.putInt((Frame)frame, top, (Integer)value);
                break;
            }
            case 70: {
                EspressoFrame.putFloat((Frame)frame, top, ((Float)value).floatValue());
                break;
            }
            case 74: {
                EspressoFrame.putLong((Frame)frame, top, (Long)value);
                break;
            }
            case 68: {
                EspressoFrame.putDouble((Frame)frame, top, (Double)value);
                break;
            }
            case 76: 
            case 91: {
                EspressoFrame.putObject((Frame)frame, top, (StaticObject)value);
                break;
            }
            case 86: {
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
        return Types.slotCount(type);
    }

    public static void taint(Frame frame) {
        Object object;
        if (EspressoFrame.isTainted(frame)) {
            return;
        }
        Object[] args = frame.getArguments();
        if (args.length > 0 && (object = args[0]) instanceof HostFrameRecord) {
            HostFrameRecord hfr = (HostFrameRecord)object;
            hfr.taint();
        }
    }

    public static boolean isTainted(Frame frame) {
        Object object;
        Object[] args = frame.getArguments();
        if (args.length > 0 && (object = args[0]) instanceof HostFrameRecord) {
            HostFrameRecord hfr = (HostFrameRecord)object;
            return hfr.isTainted();
        }
        return false;
    }
}

