/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.nodes.SubstitutionScope;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.vm.VM;

@ExportLibrary(value=NodeLibrary.class)
final class IntrinsifiedNativeMethodNode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    private CallableFromNative nativeMethod;
    private final Object env;

    IntrinsifiedNativeMethodNode(Method.MethodVersion methodVersion, CallableFromNative.Factory factory, Object env) {
        super(methodVersion);
        assert (CallableFromNative.validParameterCount(factory, methodVersion));
        this.nativeMethod = (CallableFromNative)this.insert(factory.create());
        this.env = env;
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        Method method = this.getMethodVersion().getMethod();
        if (method.isStatic()) {
            int parameterCount = method.getParameterCount();
            Object[] newArgs = new Object[parameterCount + 1];
            newArgs[0] = method.getDeclaringKlass().mirror();
            System.arraycopy(args, 0, newArgs, 1, parameterCount);
            args = newArgs;
        }
        return this.nativeMethod.invokeDirect(this.env, args);
    }

    @Override
    public int getBci(Frame frame) {
        return VM.EspressoStackElement.NATIVE_BCI;
    }

    @ExportMessage
    public boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public Object getScope(Frame frame, boolean nodeEnter) {
        return new SubstitutionScope(frame.getArguments(), this.getMethodVersion());
    }
}

