/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNode;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;

@ExportLibrary(value=NodeLibrary.class)
final class MethodWithBytecodeNode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    AbstractInstrumentableBytecodeNode bytecodeNode;

    MethodWithBytecodeNode(BytecodeNode bytecodeNode) {
        super(bytecodeNode.getMethodVersion());
        this.bytecodeNode = bytecodeNode;
    }

    @Override
    public int getBci(Frame frame) {
        return this.bytecodeNode.getBci(frame);
    }

    @Override
    Object execute(VirtualFrame frame) {
        this.bytecodeNode.initializeFrame(frame);
        return this.bytecodeNode.execute(frame);
    }

    @Override
    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"}, justification="bytecodeNode may be replaced by instrumentation with a wrapper node")
    boolean isTrivial() {
        return !(this.bytecodeNode instanceof InstrumentableNode.WrapperNode) && this.bytecodeNode.isTrivial();
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.RootTag.class;
    }

    @ExportMessage
    public boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public Object getScope(Frame frame, boolean nodeEnter) {
        return this.getScopeSlowPath(frame != null ? frame.materialize() : null, nodeEnter);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getScopeSlowPath(MaterializedFrame frame, boolean nodeEnter) {
        return this.bytecodeNode.getScope((Frame)frame, nodeEnter);
    }
}

