/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

public abstract class ArrayLength {

    @NodeInfo(shortName="ARRAYLENGTH !nullcheck")
    @GenerateUncached
    @ImportStatic(value={Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public final int executeAsInt(StaticObject array) {
            long arrayLength = this.executeAsLong(array);
            if (arrayLength > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)arrayLength;
        }

        public abstract long executeAsLong(StaticObject var1);

        @Specialization(guards={"array.isEspressoObject()"})
        long doEspresso(StaticObject array) {
            assert (!StaticObject.isNull(array));
            return InterpreterToVM.arrayLength(array, this.getLanguage());
        }

        @Specialization(guards={"array.isForeignObject()", "isBufferLikeByteArray(language, getMeta(), interop, array)"})
        long doBufferLike(StaticObject array, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            assert (!StaticObject.isNull(array));
            try {
                return interop.getBufferSize(array.rawForeignObject(language));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Specialization(guards={"array.isForeignObject()", "!isBufferLikeByteArray(language, getMeta(), interop, array)", "isArrayLike(interop, array.rawForeignObject(language))"})
        long doArrayLike(StaticObject array, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            assert (!StaticObject.isNull(array));
            try {
                return interop.getArraySize(array.rawForeignObject(language));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

