/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InitCheck;
import com.oracle.truffle.espresso.nodes.bytecodes.Utils;

@NodeInfo(shortName="INVOKESTATIC")
public abstract class InvokeStatic
extends EspressoNode {
    final Method staticMethod;

    InvokeStatic(Method staticMethod) {
        assert (staticMethod.isStatic());
        this.staticMethod = staticMethod;
    }

    public Method getStaticMethod() {
        return this.staticMethod;
    }

    public abstract Object execute(Object[] var1);

    @Specialization
    Object callWithClassInitCheck(Object[] args, @Cached InitCheck initCheck, @Cached(value="create(staticMethod)") WithoutClassInitCheck invokeStatic) {
        initCheck.execute(this.staticMethod.getDeclaringKlass());
        return invokeStatic.execute(args);
    }

    static Method.MethodVersion methodLookup(Method staticMethod) {
        assert (staticMethod.isStatic());
        if (staticMethod.isRemovedByRedefinition()) {
            return staticMethod.getContext().getClassRedefinition().handleRemovedMethod(staticMethod, staticMethod.getDeclaringKlass()).getMethodVersion();
        }
        return staticMethod.getMethodVersion();
    }

    @NodeInfo(shortName="INVOKESTATIC !initcheck")
    @ImportStatic(value={InvokeStatic.class, Utils.class})
    public static abstract class WithoutClassInitCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;
        final Method staticMethod;

        WithoutClassInitCheck(Method staticMethod) {
            assert (staticMethod.isStatic());
            this.staticMethod = staticMethod;
        }

        public abstract Object execute(Object[] var1);

        @Specialization(assumptions={"resolvedMethod.getRedefineAssumption()"})
        Object callDirect(Object[] args, @Cached(value="methodLookup(staticMethod)") Method.MethodVersion resolvedMethod, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode) {
            return directCallNode.call(args);
        }

        @Specialization(replaces={"callDirect"})
        Object callIndirect(Object[] args, @Cached IndirectCallNode indirectCallNode) {
            Method.MethodVersion target = InvokeStatic.methodLookup(this.staticMethod);
            return indirectCallNode.call(target.getCallTarget(), args);
        }
    }

    @NodeInfo(shortName="INVOKESTATIC dynamic")
    @GenerateUncached
    public static abstract class Dynamic
    extends EspressoNode {
        public abstract Object execute(Method var1, Object[] var2);

        @Specialization
        Object callWithClassInitCheck(Method staticMethod, Object[] args, @Cached InitCheck initCheck, @Cached WithoutClassInitCheck invokeStatic) {
            initCheck.execute(staticMethod.getDeclaringKlass());
            return invokeStatic.execute(staticMethod, args);
        }

        @NodeInfo(shortName="INVOKESTATIC dynamic !initcheck")
        @GenerateUncached
        public static abstract class WithoutClassInitCheck
        extends EspressoNode {
            protected static final int LIMIT = 2;

            public abstract Object execute(Method var1, Object[] var2);

            @Specialization(limit="LIMIT", guards={"staticMethod == cachedStaticMethod"})
            Object callDirect(Method staticMethod, Object[] args, @Cached(value="staticMethod") Method cachedStaticMethod, @Cached(value="create(cachedStaticMethod)") com.oracle.truffle.espresso.nodes.bytecodes.InvokeStatic$WithoutClassInitCheck invokeStatic) {
                return invokeStatic.execute(args);
            }

            @Specialization(replaces={"callDirect"})
            Object callIndirect(Method staticMethod, Object[] args, @Cached IndirectCallNode indirectCallNode) {
                Method.MethodVersion target = InvokeStatic.methodLookup(staticMethod);
                return indirectCallNode.call(target.getCallTarget(), args);
            }
        }
    }
}

