/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.commands;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@GenerateUncached
@GenerateInline(value=false)
public abstract class AddPathToBindingsNode
extends EspressoNode {
    public abstract void execute(Object[] var1) throws UnsupportedTypeException, ArityException;

    @Specialization
    protected void addPath(Object[] args, @Bind(value="getContext()") EspressoContext context, @CachedLibrary(limit="1") InteropLibrary lib) throws UnsupportedTypeException, ArityException {
        StaticObject guestPath = AddPathToBindingsNode.getGuestPath(args, context, lib);
        context.getLazyCaches().getAddPathToBindingsCache().execute(guestPath);
    }

    private static StaticObject getGuestPath(Object[] args, EspressoContext context, InteropLibrary lib) throws ArityException, UnsupportedTypeException {
        StaticObject guestPath;
        if (args.length != 1) {
            throw ArityException.create((int)1, (int)1, (int)args.length);
        }
        Object path = args[0];
        if (!lib.isString(path)) {
            throw UnsupportedTypeException.create((Object[])args);
        }
        try {
            guestPath = context.getMeta().toGuestString(lib.asString(path));
        }
        catch (UnsupportedMessageException e) {
            throw UnsupportedTypeException.create((Object[])args);
        }
        return guestPath;
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static class InvocableAddToBindings
    implements TruffleObject {
        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] args, @Cached AddPathToBindingsNode addPath) throws ArityException, UnsupportedTypeException {
            addPath.execute(args);
            return StaticObject.NULL;
        }
    }
}

