/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EntryTable;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.jni.Mangle;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.shadowed.asm.ClassWriter;
import com.oracle.truffle.espresso.shadowed.asm.Label;
import com.oracle.truffle.espresso.shadowed.asm.MethodVisitor;
import com.oracle.truffle.espresso.shadowed.asm.Type;
import com.oracle.truffle.espresso.vm.ModulesHelperVM;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class EspressoForeignProxyGenerator
extends ClassWriter {
    private static final String JL_OBJECT = "java/lang/Object";
    private static final String JL_THROWABLE = "java/lang/Throwable";
    private static final String JLR_UNDECLARED_THROWABLE_EX = "java/lang/reflect/UndeclaredThrowableException";
    private static final int VARARGS = 128;
    private final Meta meta;
    private final EspressoContext context;
    private final StaticObject proxyClassLoader;
    private final String className;
    private final ObjectKlass[] interfaces;
    private final ObjectKlass superKlass;
    private final int accessFlags;
    private final Map<String, List<ProxyMethod>> proxyMethods = new HashMap<String, List<ProxyMethod>>();
    private static final AtomicLong nextUniqueNumber = new AtomicLong();
    public static final String PROXY_PACKAGE_PREFIX = "com.oracle.truffle.espresso.polyglot";
    public static final String PROXY_NAME_PREFIX = "Foreign$Proxy$";

    private EspressoForeignProxyGenerator(Meta meta, ObjectKlass[] parents, ObjectKlass superKlass, EspressoContext context) {
        super(2);
        this.meta = meta;
        this.context = context;
        this.interfaces = parents;
        this.superKlass = superKlass;
        this.accessFlags = 49;
        this.proxyClassLoader = context.getBindingsLoader();
        this.className = EspressoForeignProxyGenerator.nextClassName(this.proxyClassContext(this.referencedTypes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static GeneratedProxyBytes getProxyKlassBytes(String metaName, ObjectKlass[] parents, ObjectKlass superKlass, EspressoContext context) {
        EspressoContext espressoContext = context;
        synchronized (espressoContext) {
            GeneratedProxyBytes generatedProxyBytes = context.getProxyBytesOrNull(metaName);
            if (generatedProxyBytes == null) {
                EspressoForeignProxyGenerator generator = new EspressoForeignProxyGenerator(context.getMeta(), parents, superKlass, context);
                generatedProxyBytes = new GeneratedProxyBytes(generator.generateClassFile(), generator.className, superKlass);
                context.registerProxyBytes(metaName, generatedProxyBytes);
            }
            return generatedProxyBytes;
        }
    }

    private Set<Klass> referencedTypes() {
        HashSet<Klass> types = new HashSet<Klass>();
        for (ObjectKlass intf : this.interfaces) {
            for (Method m : intf.getDeclaredMethods()) {
                if (Modifier.isStatic(m.getModifiers())) continue;
                EspressoForeignProxyGenerator.addElementType(types, m.resolveReturnKlass());
                EspressoForeignProxyGenerator.addElementTypes(types, m.resolveParameterKlasses());
                EspressoForeignProxyGenerator.addElementTypes(types, m.getCheckedExceptions());
            }
        }
        return types;
    }

    private static void addElementTypes(HashSet<Klass> types, Klass ... classes) {
        for (Klass cls : classes) {
            EspressoForeignProxyGenerator.addElementType(types, cls);
        }
    }

    private static void addElementType(HashSet<Klass> types, Klass cls) {
        Klass type = cls.getElementalType();
        if (!type.isPrimitive()) {
            types.add(type);
        }
    }

    private ProxyClassContext proxyClassContext(Set<Klass> refTypes) {
        ModuleTable.ModuleEntry targetModule;
        HashMap<ObjectKlass, ModuleTable.ModuleEntry> packagePrivateTypes = new HashMap<ObjectKlass, ModuleTable.ModuleEntry>();
        boolean nonExported = false;
        for (ObjectKlass objectKlass : this.interfaces) {
            ModuleTable.ModuleEntry m = objectKlass.module();
            if (!Modifier.isPublic(objectKlass.getModifiers())) {
                packagePrivateTypes.put(objectKlass, m);
                continue;
            }
            if (m.isOpen() || objectKlass.packageEntry().isUnqualifiedExported()) continue;
            nonExported = true;
        }
        if (packagePrivateTypes.size() > 0) {
            targetModule = null;
            EntryTable.NamedEntry targetPackage = null;
            for (Map.Entry entry : packagePrivateTypes.entrySet()) {
                PackageTable.PackageEntry currentPackage = ((ObjectKlass)entry.getKey()).packageEntry();
                ModuleTable.ModuleEntry m = (ModuleTable.ModuleEntry)entry.getValue();
                if (targetModule != null && targetModule != m || targetPackage != null && !targetPackage.equals(currentPackage)) {
                    throw new IllegalArgumentException("cannot have non-public interfaces in different packages");
                }
                if (m.classLoader() != this.proxyClassLoader) {
                    throw new IllegalArgumentException("non-public interface is not defined by the given loader");
                }
                targetModule = m;
                targetPackage = currentPackage;
            }
            for (ObjectKlass intf : this.interfaces) {
                ModuleTable.ModuleEntry m = intf.module();
                if (m == targetModule || targetModule.canRead(m, this.context) && (m.isOpen() || intf.packageEntry().isUnqualifiedExported())) continue;
                throw new IllegalArgumentException(String.valueOf(targetModule) + " can't access " + String.valueOf(intf.getName()));
            }
            return new ProxyClassContext(targetModule, (PackageTable.PackageEntry)targetPackage, 0);
        }
        targetModule = this.getDynamicModule(this.context.getBindingsLoader());
        HashSet<ObjectKlass> types = new HashSet<ObjectKlass>(Arrays.asList(this.interfaces));
        types.add(this.superKlass);
        types.addAll(refTypes);
        for (Klass klass : types) {
            this.ensureAccess(targetModule, klass);
        }
        String pkgName = nonExported ? "com.oracle.truffle.espresso.polyglot." + String.valueOf(targetModule.getName()) : targetModule.getNameAsString();
        try {
            PackageTable.PackageEntry packageEntry = ModulesHelperVM.extractPackageEntry(pkgName.replace('.', '/'), targetModule, this.meta, null);
            return new ProxyClassContext(targetModule, packageEntry, 1);
        }
        catch (EspressoException espressoException) {
            throw new InternalError(pkgName + " not exist in " + String.valueOf(targetModule.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleTable.ModuleEntry getDynamicModule(StaticObject loader) {
        ClassRegistry.DynamicModuleWrapper proxyDynamicModuleWrapper;
        ClassRegistry classRegistry = this.context.getRegistries().getClassRegistry(this.proxyClassLoader);
        ClassRegistry.DynamicModuleWrapper dynamicModuleWrapper = proxyDynamicModuleWrapper = classRegistry.getProxyDynamicModuleWrapper();
        synchronized (dynamicModuleWrapper) {
            ModuleTable.ModuleEntry result = proxyDynamicModuleWrapper.getDynamicProxyModule();
            if (result == null) {
                String moduleName = "foreign.proxy";
                String pkgName = "com.oracle.truffle.espresso.polyglot." + moduleName;
                StaticObject moduleDescriptor = (StaticObject)this.meta.polyglot.VMHelper_getDynamicModuleDescriptor.invokeDirect(null, this.meta.toGuestString(moduleName), this.meta.toGuestString(pkgName));
                StaticObject module = (StaticObject)this.meta.jdk_internal_module_Modules_defineModule.invokeDirect(null, loader, moduleDescriptor, StaticObject.NULL);
                ModuleTable.ModuleEntry moduleEntry = ModulesHelperVM.extractToModuleEntry(module, this.meta, null);
                moduleEntry.setCanReadAllUnnamed();
                ModuleTable.ModuleEntry javaBaseModule = this.context.getRegistries().getJavaBaseModule();
                moduleEntry.addReads(javaBaseModule);
                ModuleTable.ModuleEntry polyglotAPIModule = this.context.getRegistries().getPolyglotAPIModule();
                moduleEntry.addReads(polyglotAPIModule);
                String pn = "com.oracle.truffle.espresso.polyglot." + moduleEntry.getNameAsString();
                PackageTable.PackageEntry pkgEntry = ModulesHelperVM.extractPackageEntry(pn.replace('.', '/'), moduleEntry, this.meta, null);
                pkgEntry.addExports(javaBaseModule);
                proxyDynamicModuleWrapper.setDynamicProxyModule(moduleEntry);
                result = moduleEntry;
            }
            return result;
        }
    }

    private void ensureAccess(ModuleTable.ModuleEntry target, Klass c) {
        PackageTable.PackageEntry pe;
        ModuleTable.ModuleEntry m = c.module();
        if (!target.canRead(m, this.context)) {
            target.addReads(m);
        }
        if (!(pe = c.packageEntry()).isUnqualifiedExported() && !pe.isQualifiedExportTo(target)) {
            pe.addExports(target);
        }
    }

    private static String nextClassName(ProxyClassContext proxyClassContext) {
        return proxyClassContext.packageName + ".Foreign$Proxy$" + nextUniqueNumber.getAndIncrement();
    }

    private byte[] generateClassFile() {
        this.visit(52, this.accessFlags, EspressoForeignProxyGenerator.dotToSlash(this.className), null, this.superKlass.getNameAsString(), EspressoForeignProxyGenerator.typeNames(this.interfaces));
        this.generateToStringMethod();
        if (this.superKlass != this.meta.java_lang_Object) {
            this.addSuperImplementedMethods(this.superKlass);
        }
        for (ObjectKlass intf : this.interfaces) {
            for (Method m : intf.getDeclaredMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers())) continue;
                this.addProxyMethod(m, false);
            }
        }
        for (List list : this.proxyMethods.values()) {
            EspressoForeignProxyGenerator.checkReturnTypes(list);
        }
        this.generateConstructor();
        for (List list : this.proxyMethods.values()) {
            for (ProxyMethod pm : list) {
                pm.generateMethod(this);
            }
        }
        return this.toByteArray();
    }

    private void addSuperImplementedMethods(ObjectKlass klass) {
        if (klass == klass.getMeta().java_lang_Object) {
            return;
        }
        for (Method method : klass.getDeclaredMethods()) {
            if (method.isAbstract()) continue;
            this.addProxyMethod(method, true);
        }
        for (ModifiersProvider modifiersProvider : klass.getSuperInterfaces()) {
            for (Method m : ((ObjectKlass)modifiersProvider).getDeclaredMethods()) {
                if (m.isAbstract()) continue;
                this.addProxyMethod(m, true);
            }
            this.addSuperImplementedMethods((ObjectKlass)modifiersProvider);
        }
        this.addSuperImplementedMethods(klass.getSuperKlass());
    }

    private void generateToStringMethod() {
        MethodVisitor mv = this.visitMethod(17, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label startBlock = new Label();
        Label endBlock = new Label();
        Label runtimeHandler = new Label();
        Label throwableHandler = new Label();
        mv.visitLabel(startBlock);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "toDisplayString", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitLabel(endBlock);
        mv.visitLabel(runtimeHandler);
        mv.visitInsn(191);
        mv.visitLabel(throwableHandler);
        mv.visitVarInsn(58, 1);
        mv.visitTypeInsn(187, JLR_UNDECLARED_THROWABLE_EX);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, JLR_UNDECLARED_THROWABLE_EX, "<init>", "(Ljava/lang/Throwable;)V", false);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static String[] typeNames(Klass[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        int size = classes.length;
        String[] ifaces = new String[size];
        for (int i = 0; i < size; ++i) {
            ifaces[i] = EspressoForeignProxyGenerator.dotToSlash(classes[i].getNameAsString());
        }
        return ifaces;
    }

    private void generateConstructor() {
        MethodVisitor ctor = this.visitMethod(1, "<init>", "()V", null, null);
        ctor.visitParameter(null, 0);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, this.superKlass.getNameAsString(), "<init>", "()V", false);
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void addProxyMethod(Method m, boolean isSuperKlassMethod) {
        String name = m.getNameAsString();
        Klass[] parameterTypes = m.resolveParameterKlasses();
        Klass returnType = m.resolveReturnKlass();
        Klass[] exceptionTypes = m.getCheckedExceptions();
        Symbol<Symbol.Signature> signature = m.getRawSignature();
        String sig = name + EspressoForeignProxyGenerator.getParameterDescriptors(parameterTypes);
        List<ProxyMethod> sigmethods = this.proxyMethods.get(sig);
        if (sigmethods != null) {
            for (ProxyMethod pm : sigmethods) {
                if (returnType != pm.returnType) continue;
                ArrayList<Klass> legalExceptions = new ArrayList<Klass>();
                EspressoForeignProxyGenerator.collectCompatibleTypes(exceptionTypes, pm.exceptionTypes, legalExceptions);
                EspressoForeignProxyGenerator.collectCompatibleTypes(pm.exceptionTypes, exceptionTypes, legalExceptions);
                pm.exceptionTypes = new Klass[legalExceptions.size()];
                pm.exceptionTypes = legalExceptions.toArray(pm.exceptionTypes);
                return;
            }
        } else {
            sigmethods = new ArrayList<ProxyMethod>(3);
            this.proxyMethods.put(sig, sigmethods);
        }
        sigmethods.add(new ProxyMethod(name, parameterTypes, returnType, exceptionTypes, EspressoForeignProxyGenerator.isVarArgs(m.getModifiers()), signature, isSuperKlassMethod));
    }

    private static boolean isVarArgs(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    private static void checkReturnTypes(List<ProxyMethod> methods) {
        if (methods.size() < 2) {
            return;
        }
        LinkedList<Klass> uncoveredReturnTypes = new LinkedList<Klass>();
        block0: for (ProxyMethod pm : methods) {
            Klass newReturnType = pm.returnType;
            if (newReturnType.isPrimitive()) {
                throw new IllegalArgumentException("methods with same signature " + EspressoForeignProxyGenerator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + String.valueOf(newReturnType.getName()) + " and others");
            }
            boolean added = false;
            ListIterator<Klass> liter = uncoveredReturnTypes.listIterator();
            while (liter.hasNext()) {
                Klass uncoveredReturnType = (Klass)liter.next();
                if (newReturnType.isAssignableFrom(uncoveredReturnType)) {
                    assert (!added);
                    continue block0;
                }
                if (!uncoveredReturnType.isAssignableFrom(newReturnType)) continue;
                if (!added) {
                    liter.set(newReturnType);
                    added = true;
                    continue;
                }
                liter.remove();
            }
            if (added) continue;
            uncoveredReturnTypes.add(newReturnType);
        }
        if (uncoveredReturnTypes.size() > 1) {
            ProxyMethod pm = methods.get(0);
            throw new IllegalArgumentException("methods with same signature " + EspressoForeignProxyGenerator.getFriendlyMethodSignature(pm.methodName, pm.parameterTypes) + " but incompatible return types: " + String.valueOf(uncoveredReturnTypes));
        }
    }

    private static String dotToSlash(String name) {
        return name.replace('.', '/');
    }

    private String getMethodDescriptor(Klass[] parameterTypes, Klass returnType) {
        return EspressoForeignProxyGenerator.getParameterDescriptors(parameterTypes) + (returnType == this.meta._void ? "V" : EspressoForeignProxyGenerator.getFieldType(returnType));
    }

    private static String getParameterDescriptors(Klass[] parameterTypes) {
        StringBuilder desc = new StringBuilder("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            desc.append(EspressoForeignProxyGenerator.getFieldType(parameterTypes[i]));
        }
        desc.append(')');
        return desc.toString();
    }

    private static String getFieldType(Klass type) {
        if (type.isPrimitive()) {
            return String.valueOf(JavaKind.fromTypeString(type.getTypeAsString()).getTypeChar());
        }
        if (type.isArray()) {
            return type.getTypeAsString();
        }
        return "L" + EspressoForeignProxyGenerator.dotToSlash(type.getNameAsString()) + ";";
    }

    private static String getFriendlyMethodSignature(String name, Klass[] parameterTypes) {
        StringBuilder sig = new StringBuilder(name);
        sig.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sig.append(',');
            }
            Klass parameterType = parameterTypes[i];
            int dimensions = 0;
            while (parameterType.isArray()) {
                parameterType = ((ArrayKlass)parameterType).getComponentType();
                ++dimensions;
            }
            sig.append(parameterType.getName());
            while (dimensions-- > 0) {
                sig.append("[]");
            }
        }
        sig.append(')');
        return sig.toString();
    }

    private int getWordsPerType(Klass type) {
        if (type == this.meta._long || type == this.meta._double) {
            return 2;
        }
        return 1;
    }

    private static void collectCompatibleTypes(Klass[] from, Klass[] with, List<Klass> list) {
        block0: for (Klass fc : from) {
            if (list.contains(fc)) continue;
            for (Klass wc : with) {
                if (!wc.isAssignableFrom(fc)) continue;
                list.add(fc);
                continue block0;
            }
        }
    }

    private List<Klass> computeUniqueCatchList(Klass[] exceptions) {
        ArrayList<Klass> uniqueList = new ArrayList<Klass>();
        uniqueList.add(this.meta.java_lang_Error);
        uniqueList.add(this.meta.java_lang_RuntimeException);
        block0: for (Klass ex : exceptions) {
            if (ex.isAssignableFrom(this.meta.java_lang_Throwable)) {
                uniqueList.clear();
                break;
            }
            if (!this.meta.java_lang_Throwable.isAssignableFrom(ex)) continue;
            int j = 0;
            while (j < uniqueList.size()) {
                Klass ex2 = (Klass)uniqueList.get(j);
                if (ex2.isAssignableFrom(ex)) continue block0;
                if (ex.isAssignableFrom(ex2)) {
                    uniqueList.remove(j);
                    continue;
                }
                ++j;
            }
            uniqueList.add(ex);
        }
        return uniqueList;
    }

    private final class ProxyClassContext {
        private final String packageName;

        private ProxyClassContext(ModuleTable.ModuleEntry module, PackageTable.PackageEntry packageEntry, int accessFlags) {
            if (module.isNamed()) {
                if (packageEntry == null) {
                    throw new InternalError("Unnamed package cannot be added to " + String.valueOf(module));
                }
            } else if (Modifier.isPublic(accessFlags)) {
                throw new InternalError("public proxy in unnamed module: " + String.valueOf(module));
            }
            if ((accessFlags & 0xFFFFFFFE) != 0) {
                throw new InternalError("proxy access flags must be Modifier.PUBLIC or 0");
            }
            this.packageName = packageEntry.getNameAsString();
        }
    }

    public static class GeneratedProxyBytes {
        public final byte[] bytes;
        public final String name;
        private final ObjectKlass superklass;

        GeneratedProxyBytes(byte[] bytes, String name, ObjectKlass superKlass) {
            this.bytes = bytes;
            this.name = name;
            this.superklass = superKlass;
        }

        public WrappedProxyKlass getProxyKlass(ObjectKlass proxyKlass) {
            return new WrappedProxyKlass(proxyKlass);
        }

        public ObjectKlass getSuperklass() {
            return this.superklass;
        }
    }

    private final class ProxyMethod {
        public String methodName;
        public Klass[] parameterTypes;
        public Klass returnType;
        public Klass[] exceptionTypes;
        boolean isVarArgs;
        Symbol<Symbol.Signature> signature;
        boolean isOptimizedMethod;

        private ProxyMethod(String methodName, Klass[] parameterTypes, Klass returnType, Klass[] exceptionTypes, boolean isVarArgs, Symbol<Symbol.Signature> signature, boolean isOptimizedMethod) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.exceptionTypes = exceptionTypes;
            this.isVarArgs = isVarArgs;
            this.signature = signature;
            this.isOptimizedMethod = isOptimizedMethod;
        }

        private void generateMethod(ClassWriter cw) {
            String invokeSig;
            String invokeName;
            if (this.isOptimizedMethod) {
                return;
            }
            String desc = EspressoForeignProxyGenerator.this.getMethodDescriptor(this.parameterTypes, this.returnType);
            int methodAccess = 17;
            if (this.isVarArgs) {
                methodAccess |= 0x80;
            }
            MethodVisitor mv = cw.visitMethod(methodAccess, this.methodName, desc, null, EspressoForeignProxyGenerator.typeNames(this.exceptionTypes));
            int[] parameterSlot = new int[this.parameterTypes.length];
            int nextSlot = 1;
            for (int i = 0; i < parameterSlot.length; ++i) {
                parameterSlot[i] = nextSlot;
                nextSlot += EspressoForeignProxyGenerator.this.getWordsPerType(this.parameterTypes[i]);
            }
            mv.visitCode();
            Label startBlock = new Label();
            Label endBlock = new Label();
            Label runtimeHandler = new Label();
            Label throwableHandler = new Label();
            List<Klass> catchList = EspressoForeignProxyGenerator.this.computeUniqueCatchList(this.exceptionTypes);
            if (!catchList.isEmpty()) {
                for (Klass ex : catchList) {
                    mv.visitTryCatchBlock(startBlock, endBlock, runtimeHandler, EspressoForeignProxyGenerator.dotToSlash(ex.getNameAsString()));
                }
                mv.visitTryCatchBlock(startBlock, endBlock, throwableHandler, EspressoForeignProxyGenerator.JL_THROWABLE);
            }
            mv.visitLabel(startBlock);
            if (this.returnType.isPrimitive()) {
                JavaKind kind = this.returnType.getJavaKind();
                if (kind == JavaKind.Char) {
                    mv.visitLdcInsn(Type.getType(kind.toBoxedJavaClass()));
                    invokeName = "invokeMemberWithCast";
                    invokeSig = "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;";
                } else {
                    invokeName = "invokeMember";
                    invokeSig = "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;";
                }
            } else {
                mv.visitLdcInsn(Type.getType(this.returnType.getTypeAsString()));
                invokeName = "invokeMemberWithCast";
                invokeSig = "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;";
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(Mangle.truffleJniMethodName(this.methodName, this.signature));
            if (this.parameterTypes.length > 0) {
                this.emitIconstInsn(mv, this.parameterTypes.length);
                mv.visitTypeInsn(189, EspressoForeignProxyGenerator.JL_OBJECT);
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    mv.visitInsn(89);
                    this.emitIconstInsn(mv, i);
                    this.codeWrapArgument(mv, this.parameterTypes[i], parameterSlot[i]);
                    mv.visitInsn(83);
                }
            } else {
                mv.visitInsn(3);
                mv.visitTypeInsn(189, EspressoForeignProxyGenerator.JL_OBJECT);
            }
            mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", invokeName, invokeSig, false);
            if (this.returnType == EspressoForeignProxyGenerator.this.meta._void) {
                mv.visitInsn(87);
                mv.visitInsn(177);
            } else {
                this.codeUnwrapReturnValue(mv, this.returnType);
            }
            mv.visitLabel(endBlock);
            mv.visitLabel(runtimeHandler);
            mv.visitInsn(191);
            mv.visitLabel(throwableHandler);
            mv.visitVarInsn(58, 1);
            mv.visitTypeInsn(187, EspressoForeignProxyGenerator.JLR_UNDECLARED_THROWABLE_EX);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, EspressoForeignProxyGenerator.JLR_UNDECLARED_THROWABLE_EX, "<init>", "(Ljava/lang/Throwable;)V", false);
            mv.visitInsn(191);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }

        private void codeWrapArgument(MethodVisitor mv, Klass type, int slot) {
            if (type.isPrimitive()) {
                JavaKind kind = JavaKind.fromTypeString(type.getTypeAsString());
                switch (kind) {
                    case Int: 
                    case Boolean: 
                    case Char: 
                    case Byte: 
                    case Short: {
                        mv.visitVarInsn(21, slot);
                        break;
                    }
                    case Long: {
                        mv.visitVarInsn(22, slot);
                        break;
                    }
                    case Float: {
                        mv.visitVarInsn(23, slot);
                        break;
                    }
                    case Double: {
                        mv.visitVarInsn(24, slot);
                        break;
                    }
                    default: {
                        throw EspressoError.shouldNotReachHere();
                    }
                }
                mv.visitMethodInsn(184, EspressoForeignProxyGenerator.dotToSlash(kind.toBoxedJavaClass().getName()), "valueOf", kind.getWrapperValueOfDesc(), false);
            } else {
                mv.visitVarInsn(25, slot);
            }
        }

        private void codeUnwrapReturnValue(MethodVisitor mv, Klass type) {
            if (type.isPrimitive()) {
                JavaKind kind = JavaKind.fromTypeString(type.getTypeAsString());
                switch (kind) {
                    case Char: {
                        String wrapperClassName = EspressoForeignProxyGenerator.dotToSlash(kind.toBoxedJavaClass().getName());
                        mv.visitTypeInsn(192, wrapperClassName);
                        mv.visitMethodInsn(182, wrapperClassName, kind.getUnwrapMethodName(), kind.getUnwrapMethodDesc(), false);
                        mv.visitInsn(172);
                        break;
                    }
                    case Int: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asInt", "(Ljava/lang/Object;)I", false);
                        mv.visitInsn(172);
                        break;
                    }
                    case Boolean: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asBoolean", "(Ljava/lang/Object;)Z", false);
                        mv.visitInsn(172);
                        break;
                    }
                    case Byte: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asByte", "(Ljava/lang/Object;)B", false);
                        mv.visitInsn(172);
                        break;
                    }
                    case Short: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asShort", "(Ljava/lang/Object;)S", false);
                        mv.visitInsn(172);
                        break;
                    }
                    case Long: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asLong", "(Ljava/lang/Object;)J", false);
                        mv.visitInsn(173);
                        break;
                    }
                    case Float: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asFloat", "(Ljava/lang/Object;)F", false);
                        mv.visitInsn(174);
                        break;
                    }
                    case Double: {
                        mv.visitMethodInsn(184, "com/oracle/truffle/espresso/polyglot/Interop", "asDouble", "(Ljava/lang/Object;)D", false);
                        mv.visitInsn(175);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } else {
                if (type.isArray()) {
                    mv.visitTypeInsn(192, type.getTypeAsString());
                } else {
                    mv.visitTypeInsn(192, type.getNameAsString());
                }
                mv.visitInsn(176);
            }
        }

        private void emitIconstInsn(MethodVisitor mv, int cst) {
            if (cst >= -1 && cst <= 5) {
                mv.visitInsn(3 + cst);
            } else if (cst >= -128 && cst <= 127) {
                mv.visitIntInsn(16, cst);
            } else if (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE) {
                mv.visitIntInsn(17, cst);
            } else {
                mv.visitLdcInsn(cst);
            }
        }
    }
}

