/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;

@GenerateUncached
public abstract class LookupInternalTypeConverterNode
extends EspressoNode {
    static final int LIMIT = 3;

    public abstract PolyglotTypeMappings.InternalTypeConverter execute(String var1) throws ClassCastException;

    @Specialization(guards={"cachedMetaName.equals(metaName)"}, limit="LIMIT")
    PolyglotTypeMappings.InternalTypeConverter doCached(String metaName, @Cached(value="metaName") String cachedMetaName, @Cached(value="doUncached(metaName)") PolyglotTypeMappings.InternalTypeConverter converter) throws ClassCastException {
        assert (converter == this.doUncached(metaName));
        return converter;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"doCached"})
    PolyglotTypeMappings.InternalTypeConverter doUncached(String metaName) throws ClassCastException {
        return this.getContext().getPolyglotTypeMappings().mapInternalTypeConversion(metaName);
    }
}

