/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.methodhandle;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public class MHInvokeGenericNode
extends MethodHandleIntrinsicNode {
    private final StaticObject appendix;
    private final boolean unbasic;
    @Node.Child
    private DirectCallNode callNode;

    public MHInvokeGenericNode(Method method, StaticObject memberName, StaticObject appendix) {
        super(method);
        this.appendix = appendix;
        Method target = (Method)method.getMeta().HIDDEN_VMTARGET.getHiddenObject(memberName);
        this.callNode = method.getContext().getEspressoEnv().SplitMethodHandles ? DirectCallNode.create((CallTarget)target.forceSplit().getCallTarget()) : DirectCallNode.create((CallTarget)target.getCallTarget());
        this.unbasic = target.getReturnKind() != method.getReturnKind();
    }

    @Override
    public Object call(Object[] args) {
        assert (args[args.length - 1] == null);
        args[args.length - 1] = this.appendix;
        return this.callNode.call(args);
    }

    public static MHInvokeGenericNode create(EspressoLanguage language, Meta meta, ObjectKlass accessingKlass, Method method, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        ObjectKlass callerKlass = accessingKlass == null ? meta.java_lang_Object : accessingKlass;
        StaticObject appendixBox = StaticObject.createArray(meta.java_lang_Object_array, new StaticObject[1], meta.getContext());
        StaticObject memberName = (StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkMethod.invokeDirect(null, callerKlass.mirror(), 5, method.getDeclaringKlass().mirror(), meta.toGuestString(methodName), meta.toGuestString(signature), appendixBox);
        StaticObject appendix = (StaticObject)appendixBox.get(language, 0);
        return new MHInvokeGenericNode(method, memberName, appendix);
    }

    @Override
    public Object processReturnValue(Object obj, JavaKind kind) {
        if (this.unbasic) {
            return super.processReturnValue(obj, kind);
        }
        return obj;
    }
}

