/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.methodhandle;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.methodhandle.MHLinkToNativeNodeGen;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.panama.DowncallStubNode;
import com.oracle.truffle.espresso.runtime.panama.DowncallStubs;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class MHLinkToNativeNode
extends MethodHandleIntrinsicNode {
    protected static final int LIMIT = 3;
    private final int argCount;
    private final Field downcallStubAddress;

    protected MHLinkToNativeNode(Method method, Field downcallStubAddress) {
        super(method);
        this.downcallStubAddress = downcallStubAddress;
        this.argCount = Signatures.parameterCount(method.getParsedSignature());
        assert (this.argCount >= 1);
    }

    public static MHLinkToNativeNode create(Method method, Meta meta) {
        return MHLinkToNativeNodeGen.create(method, meta.jdk_internal_foreign_abi_NativeEntryPoint_downcallStubAddress);
    }

    @Override
    public Object call(Object[] args) {
        return this.execute(args);
    }

    protected abstract Object execute(Object[] var1);

    @Specialization(guards={"downcallStubId == getDowncallStubId(args)"}, limit="LIMIT")
    protected Object doCached(Object[] args, @Cached(value="getDowncallStubId(args)") long downcallStubId, @Cached(value="createDowncallStubNode(downcallStubId)") DowncallStubNode node) {
        assert (args.length == this.argCount);
        return node.call(args);
    }

    @Specialization
    protected Object doUncached(Object[] args) {
        assert (args.length == this.argCount);
        long downcallStubId = this.getDowncallStubId(args);
        EspressoContext context = this.getContext();
        DowncallStubs.DowncallStub stub = context.getDowncallStubs().getStub(downcallStubId);
        return stub.uncachedCall(args, context);
    }

    protected DowncallStubNode createDowncallStubNode(long downcallStubId) {
        EspressoContext context = this.getContext();
        DowncallStubs.DowncallStub stub = context.getDowncallStubs().getStub(downcallStubId);
        return DowncallStubNode.create(stub, context.getNativeAccess());
    }

    protected long getDowncallStubId(Object[] args) {
        StaticObject nativeEntryPoint = (StaticObject)args[this.argCount - 1];
        return this.downcallStubAddress.getLong(nativeEntryPoint);
    }
}

