/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class QuickNode
extends BaseQuickNode {
    protected final int top;
    private final int callerBCI;

    protected QuickNode(int top, int callerBCI) {
        this.top = top;
        this.callerBCI = callerBCI;
    }

    @Override
    public abstract int execute(VirtualFrame var1, boolean var2);

    protected final StaticObject nullCheck(StaticObject value) {
        if (StaticObject.isNull(value)) {
            this.getBytecodeNode().enterImplicitExceptionProfile();
            throw this.getMeta().throwNullPointerException();
        }
        return value;
    }

    @Override
    public int getBci(Frame frame) {
        return this.callerBCI;
    }

    public int getCallerBCI() {
        return this.callerBCI;
    }

    public SourceSection getSourceSection() {
        return this.getBytecodeNode().getSourceSectionAtBCI(this.callerBCI);
    }
}

